
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_acc_trans_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_acc_trans_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_acc_trans_mappings` WRITE;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` DISABLE KEYS */;
INSERT INTO `accounting_acc_trans_mappings` VALUES (1,1,'2024/0001','transfer',1,'2024-12-20 00:24:00',NULL,'2024-12-20 00:25:16','2024-12-20 00:25:16');
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_account_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_type` varchar(191) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `show_balance` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=155 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_account_types` WRITE;
/*!40000 ALTER TABLE `accounting_account_types` DISABLE KEYS */;
INSERT INTO `accounting_account_types` VALUES (1,'accounts_receivable',NULL,NULL,'asset','sub_type',NULL,NULL,0,NULL,NULL),(2,'current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(3,'cash_and_cash_equivalents',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(4,'fixed_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(5,'non_current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(6,'accounts_payable',NULL,NULL,'liability','sub_type',NULL,NULL,0,NULL,NULL),(7,'credit_card',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(8,'current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(9,'non_current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(10,'owners_equity',NULL,NULL,'equity','sub_type',NULL,NULL,1,NULL,NULL),(11,'income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),(12,'other_income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),(13,'cost_of_sale',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(14,'expenses',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(15,'other_expense',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(16,'accounts_receivable',NULL,NULL,NULL,'detail_type',1,'',1,NULL,NULL),(17,'allowance_for_bad_debts',NULL,NULL,NULL,'detail_type',2,'allowance_for_bad_debts_desc',1,NULL,NULL),(18,'assets_available_for_sale',NULL,NULL,NULL,'detail_type',2,'assets_available_for_sale_desc',1,NULL,NULL),(19,'development_costs',NULL,NULL,NULL,'detail_type',2,'development_costs_desc',1,NULL,NULL),(20,'employee_cash_advances',NULL,NULL,NULL,'detail_type',2,'employee_cash_advances_desc',1,NULL,NULL),(21,'inventory',NULL,NULL,NULL,'detail_type',2,'inventory_desc',1,NULL,NULL),(22,'investments_-_other',NULL,NULL,NULL,'detail_type',2,'investments_-_other_desc',1,NULL,NULL),(23,'loans_to_officers',NULL,NULL,NULL,'detail_type',2,'loans_to_officers_desc',1,NULL,NULL),(24,'loans_to_others',NULL,NULL,NULL,'detail_type',2,'loans_to_others_desc',1,NULL,NULL),(25,'loans_to_shareholders',NULL,NULL,NULL,'detail_type',2,'loans_to_shareholders_desc',1,NULL,NULL),(26,'other_current_assets',NULL,NULL,NULL,'detail_type',2,'other_current_assets_desc',1,NULL,NULL),(27,'prepaid_expenses',NULL,NULL,NULL,'detail_type',2,'prepaid_expenses_desc',1,NULL,NULL),(28,'retainage',NULL,NULL,NULL,'detail_type',2,'retainage_desc',1,NULL,NULL),(29,'undeposited_funds',NULL,NULL,NULL,'detail_type',2,'undeposited_funds_desc',1,NULL,NULL),(30,'bank',NULL,NULL,NULL,'detail_type',3,'bank_desc',1,NULL,NULL),(31,'cash_and_cash_equivalents',NULL,NULL,NULL,'detail_type',3,'cash_and_cash_equivalents_desc',1,NULL,NULL),(32,'cash_on_hand',NULL,NULL,NULL,'detail_type',3,'cash_on_hand_desc',1,NULL,NULL),(33,'client_trust_account',NULL,NULL,NULL,'detail_type',3,'client_trust_account_desc',1,NULL,NULL),(34,'money_market',NULL,NULL,NULL,'detail_type',3,'money_market_desc',1,NULL,NULL),(35,'rents_held_in_trust',NULL,NULL,NULL,'detail_type',3,'rents_held_in_trust_desc',1,NULL,NULL),(36,'savings',NULL,NULL,NULL,'detail_type',3,'savings_desc',1,NULL,NULL),(37,'accumulated_depletion',NULL,NULL,NULL,'detail_type',4,'accumulated_depletion_desc',1,NULL,NULL),(38,'accumulated_depreciation_on_property,_plant_and_equipment',NULL,NULL,NULL,'detail_type',4,'accumulated_depreciation_on_property,_plant_and_equipment_desc',1,NULL,NULL),(39,'buildings',NULL,NULL,NULL,'detail_type',4,'buildings_desc',1,NULL,NULL),(40,'depletable_assets',NULL,NULL,NULL,'detail_type',4,'depletable_assets_desc',1,NULL,NULL),(41,'furniture_and_fixtures',NULL,NULL,NULL,'detail_type',4,'furniture_and_fixtures_desc',1,NULL,NULL),(42,'land',NULL,NULL,NULL,'detail_type',4,'land_desc',1,NULL,NULL),(43,'leasehold_improvements',NULL,NULL,NULL,'detail_type',4,'leasehold_improvements_desc',1,NULL,NULL),(44,'machinery_and_equipment',NULL,NULL,NULL,'detail_type',4,'machinery_and_equipment_desc',1,NULL,NULL),(45,'other_fixed_assets',NULL,NULL,NULL,'detail_type',4,'other_fixed_assets_desc',1,NULL,NULL),(46,'vehicles',NULL,NULL,NULL,'detail_type',4,'vehicles_desc',1,NULL,NULL),(47,'accumulated_amortisation_of_non-current_assets',NULL,NULL,NULL,'detail_type',5,'accumulated_amortisation_of_non-current_assets_desc',1,NULL,NULL),(48,'assets_held_for_sale',NULL,NULL,NULL,'detail_type',5,'assets_held_for_sale_desc',1,NULL,NULL),(49,'deferred_tax',NULL,NULL,NULL,'detail_type',5,'deferred_tax_desc',1,NULL,NULL),(50,'goodwill',NULL,NULL,NULL,'detail_type',5,'goodwill_desc',1,NULL,NULL),(51,'intangible_assets',NULL,NULL,NULL,'detail_type',5,'intangible_assets_desc',1,NULL,NULL),(52,'lease_buyout',NULL,NULL,NULL,'detail_type',5,'lease_buyout_desc',1,NULL,NULL),(53,'licences',NULL,NULL,NULL,'detail_type',5,'licences_desc',1,NULL,NULL),(54,'long-term_investments',NULL,NULL,NULL,'detail_type',5,'long-term_investments_desc',1,NULL,NULL),(55,'organisational_costs',NULL,NULL,NULL,'detail_type',5,'organisational_costs_desc',1,NULL,NULL),(56,'other_non-current_assets',NULL,NULL,NULL,'detail_type',5,'other_non-current_assets_desc',1,NULL,NULL),(57,'security_deposits',NULL,NULL,NULL,'detail_type',5,'security_deposits_desc',1,NULL,NULL),(58,'accounts_payable_(a/p)',NULL,NULL,NULL,'detail_type',6,'accounts_payable_(a/p)_desc',1,NULL,NULL),(59,'credit_card',NULL,NULL,NULL,'detail_type',7,'credit_card_desc',1,NULL,NULL),(60,'accrued_liabilities',NULL,NULL,NULL,'detail_type',8,'accrued_liabilities_desc',1,NULL,NULL),(61,'client_trust_accounts_-_liabilities',NULL,NULL,NULL,'detail_type',8,'client_trust_accounts_-_liabilities_desc',1,NULL,NULL),(62,'current_tax_liability',NULL,NULL,NULL,'detail_type',8,'current_tax_liability_desc',1,NULL,NULL),(63,'current_portion_of_obligations_under_finance_leases',NULL,NULL,NULL,'detail_type',8,'current_portion_of_obligations_under_finance_leases_desc',1,NULL,NULL),(64,'dividends_payable',NULL,NULL,NULL,'detail_type',8,'dividends_payable_desc',1,NULL,NULL),(65,'income_tax_payable',NULL,NULL,NULL,'detail_type',8,'income_tax_payable_desc',1,NULL,NULL),(66,'insurance_payable',NULL,NULL,NULL,'detail_type',8,'insurance_payable_desc',1,NULL,NULL),(67,'line_of_credit',NULL,NULL,NULL,'detail_type',8,'line_of_credit_desc',1,NULL,NULL),(68,'loan_payable',NULL,NULL,NULL,'detail_type',8,'loan_payable_desc',1,NULL,NULL),(69,'other_current_liabilities',NULL,NULL,NULL,'detail_type',8,'other_current_liabilities_desc',1,NULL,NULL),(70,'payroll_clearing',NULL,NULL,NULL,'detail_type',8,'payroll_clearing_desc',1,NULL,NULL),(71,'payroll_liabilities',NULL,NULL,NULL,'detail_type',8,'payroll_liabilities_desc',1,NULL,NULL),(72,'prepaid_expenses_payable',NULL,NULL,NULL,'detail_type',8,'prepaid_expenses_payable_desc',1,NULL,NULL),(73,'rents_in_trust_-_liability',NULL,NULL,NULL,'detail_type',8,'rents_in_trust_-_liability_desc',1,NULL,NULL),(74,'sales_and_service_tax_payable',NULL,NULL,NULL,'detail_type',8,'sales_and_service_tax_payable_desc',1,NULL,NULL),(75,'accrued_holiday_payable',NULL,NULL,NULL,'detail_type',9,'accrued_holiday_payable_desc',1,NULL,NULL),(76,'accrued_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'accrued_non-current_liabilities_desc',1,NULL,NULL),(77,'liabilities_related_to_assets_held_for_sale',NULL,NULL,NULL,'detail_type',9,'liabilities_related_to_assets_held_for_sale_desc',1,NULL,NULL),(78,'long-term_debt',NULL,NULL,NULL,'detail_type',9,'long-term_debt_desc',1,NULL,NULL),(79,'notes_payable',NULL,NULL,NULL,'detail_type',9,'notes_payable_desc',1,NULL,NULL),(80,'other_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'other_non-current_liabilities_desc',1,NULL,NULL),(81,'shareholder_notes_payable',NULL,NULL,NULL,'detail_type',9,'shareholder_notes_payable_desc',1,NULL,NULL),(82,'accumulated_adjustment',NULL,NULL,NULL,'detail_type',10,'accumulated_adjustment_desc',1,NULL,NULL),(83,'dividend_disbursed',NULL,NULL,NULL,'detail_type',10,'dividend_disbursed_desc',1,NULL,NULL),(84,'equity_in_earnings_of_subsidiaries',NULL,NULL,NULL,'detail_type',10,'equity_in_earnings_of_subsidiaries_desc',1,NULL,NULL),(85,'opening_balance_equity',NULL,NULL,NULL,'detail_type',10,'opening_balance_equity_desc',1,NULL,NULL),(86,'ordinary_shares',NULL,NULL,NULL,'detail_type',10,'ordinary_shares_desc',1,NULL,NULL),(87,'other_comprehensive_income',NULL,NULL,NULL,'detail_type',10,'other_comprehensive_income_desc',1,NULL,NULL),(88,'owner\'s_equity',NULL,NULL,NULL,'detail_type',10,'owner\'s_equity_desc',1,NULL,NULL),(89,'paid-in_capital_or_surplus',NULL,NULL,NULL,'detail_type',10,'paid-in_capital_or_surplus_desc',1,NULL,NULL),(90,'partner_contributions',NULL,NULL,NULL,'detail_type',10,'partner_contributions_desc',1,NULL,NULL),(91,'partner_distributions',NULL,NULL,NULL,'detail_type',10,'partner_distributions_desc',1,NULL,NULL),(92,'partner\'s_equity',NULL,NULL,NULL,'detail_type',10,'partner\'s_equity_desc',1,NULL,NULL),(93,'preferred_shares',NULL,NULL,NULL,'detail_type',10,'preferred_shares_desc',1,NULL,NULL),(94,'retained_earnings',NULL,NULL,NULL,'detail_type',10,'retained_earnings_desc',1,NULL,NULL),(95,'share_capital',NULL,NULL,NULL,'detail_type',10,'share_capital_desc',1,NULL,NULL),(96,'treasury_shares',NULL,NULL,NULL,'detail_type',10,'treasury_shares_desc',1,NULL,NULL),(97,'discounts/refunds_given',NULL,NULL,NULL,'detail_type',11,'discounts/refunds_given_desc',1,NULL,NULL),(98,'non-profit_income',NULL,NULL,NULL,'detail_type',11,'non-profit_income_desc',1,NULL,NULL),(99,'other_primary_income',NULL,NULL,NULL,'detail_type',11,'other_primary_income_desc',1,NULL,NULL),(100,'revenue_-_general',NULL,NULL,NULL,'detail_type',11,'revenue_-_general_desc',1,NULL,NULL),(101,'sales_-_retail',NULL,NULL,NULL,'detail_type',11,'sales_-_retail_desc',1,NULL,NULL),(102,'sales_-_wholesale',NULL,NULL,NULL,'detail_type',11,'sales_-_wholesale_desc',1,NULL,NULL),(103,'sales_of_product_income',NULL,NULL,NULL,'detail_type',11,'sales_of_product_income_desc',1,NULL,NULL),(104,'service/fee_income',NULL,NULL,NULL,'detail_type',11,'service/fee_income_desc',1,NULL,NULL),(105,'unapplied_cash_payment_income',NULL,NULL,NULL,'detail_type',11,'unapplied_cash_payment_income_desc',1,NULL,NULL),(106,'dividend_income',NULL,NULL,NULL,'detail_type',12,'dividend_income_desc',1,NULL,NULL),(107,'interest_earned',NULL,NULL,NULL,'detail_type',12,'interest_earned_desc',1,NULL,NULL),(108,'loss_on_disposal_of_assets',NULL,NULL,NULL,'detail_type',12,'loss_on_disposal_of_assets_desc',1,NULL,NULL),(109,'other_investment_income',NULL,NULL,NULL,'detail_type',12,'other_investment_income_desc',1,NULL,NULL),(110,'other_miscellaneous_income',NULL,NULL,NULL,'detail_type',12,'other_miscellaneous_income_desc',1,NULL,NULL),(111,'other_operating_income',NULL,NULL,NULL,'detail_type',12,'other_operating_income_desc',1,NULL,NULL),(112,'tax-exempt_interest',NULL,NULL,NULL,'detail_type',12,'tax-exempt_interest_desc',1,NULL,NULL),(113,'unrealised_loss_on_securities,_net_of_tax',NULL,NULL,NULL,'detail_type',12,'unrealised_loss_on_securities,_net_of_tax_desc',1,NULL,NULL),(114,'cost_of_labour_-_cos',NULL,NULL,NULL,'detail_type',13,'cost_of_labour_-_cos_desc',1,NULL,NULL),(115,'equipment_rental_-_cos',NULL,NULL,NULL,'detail_type',13,'equipment_rental_-_cos_desc',1,NULL,NULL),(116,'freight_and_delivery_-_cos',NULL,NULL,NULL,'detail_type',13,'freight_and_delivery_-_cos_desc',1,NULL,NULL),(117,'other_costs_of_sales_-_cos',NULL,NULL,NULL,'detail_type',13,'other_costs_of_sales_-_cos_desc',1,NULL,NULL),(118,'supplies_and_materials_-_cos',NULL,NULL,NULL,'detail_type',13,'supplies_and_materials_-_cos_desc',1,NULL,NULL),(119,'advertising/promotional',NULL,NULL,NULL,'detail_type',14,'advertising/promotional_desc',1,NULL,NULL),(120,'amortisation_expense',NULL,NULL,NULL,'detail_type',14,'amortisation_expense_desc',1,NULL,NULL),(121,'auto',NULL,NULL,NULL,'detail_type',14,'auto_desc',1,NULL,NULL),(122,'bad_debts',NULL,NULL,NULL,'detail_type',14,'bad_debts_desc',1,NULL,NULL),(123,'bank_charges',NULL,NULL,NULL,'detail_type',14,'bank_charges_desc',1,NULL,NULL),(124,'charitable_contributions',NULL,NULL,NULL,'detail_type',14,'charitable_contributions_desc',1,NULL,NULL),(125,'commissions_and_fees',NULL,NULL,NULL,'detail_type',14,'commissions_and_fees_desc',1,NULL,NULL),(126,'cost_of_labour',NULL,NULL,NULL,'detail_type',14,'cost_of_labour_desc',1,NULL,NULL),(127,'dues_and_subscriptions',NULL,NULL,NULL,'detail_type',14,'dues_and_subscriptions_desc',1,NULL,NULL),(128,'equipment_rental',NULL,NULL,NULL,'detail_type',14,'equipment_rental_desc',1,NULL,NULL),(129,'finance_costs',NULL,NULL,NULL,'detail_type',14,'finance_costs_desc',1,NULL,NULL),(130,'income_tax_expense',NULL,NULL,NULL,'detail_type',14,'income_tax_expense_desc',1,NULL,NULL),(131,'insurance',NULL,NULL,NULL,'detail_type',14,'insurance_desc',1,NULL,NULL),(132,'interest_paid',NULL,NULL,NULL,'detail_type',14,'interest_paid_desc',1,NULL,NULL),(133,'legal_and_professional_fees',NULL,NULL,NULL,'detail_type',14,'legal_and_professional_fees_desc',1,NULL,NULL),(134,'loss_on_discontinued_operations,_net_of_tax',NULL,NULL,NULL,'detail_type',14,'loss_on_discontinued_operations,_net_of_tax_desc',1,NULL,NULL),(135,'management_compensation',NULL,NULL,NULL,'detail_type',14,'management_compensation_desc',1,NULL,NULL),(136,'meals_and_entertainment',NULL,NULL,NULL,'detail_type',14,'meals_and_entertainment_desc',1,NULL,NULL),(137,'office/general_administrative_expenses',NULL,NULL,NULL,'detail_type',14,'office/general_administrative_expenses_desc',1,NULL,NULL),(138,'other_miscellaneous_service_cost',NULL,NULL,NULL,'detail_type',14,'other_miscellaneous_service_cost_desc',1,NULL,NULL),(139,'other_selling_expenses',NULL,NULL,NULL,'detail_type',14,'other_selling_expenses_desc',1,NULL,NULL),(140,'payroll_expenses',NULL,NULL,NULL,'detail_type',14,'payroll_expenses_desc',1,NULL,NULL),(141,'rent_or_lease_of_buildings',NULL,NULL,NULL,'detail_type',14,'rent_or_lease_of_buildings_desc',1,NULL,NULL),(142,'repair_and_maintenance',NULL,NULL,NULL,'detail_type',14,'repair_and_maintenance_desc',1,NULL,NULL),(143,'shipping_and_delivery_expense',NULL,NULL,NULL,'detail_type',14,'shipping_and_delivery_expense_desc',1,NULL,NULL),(144,'supplies_and_materials',NULL,NULL,NULL,'detail_type',14,'supplies_and_materials_desc',1,NULL,NULL),(145,'taxes_paid',NULL,NULL,NULL,'detail_type',14,'taxes_paid_desc',1,NULL,NULL),(146,'travel_expenses_-_general_and_admin_expenses',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_general_and_admin_expenses_desc',1,NULL,NULL),(147,'travel_expenses_-_selling_expense',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_selling_expense_desc',1,NULL,NULL),(148,'unapplied_cash_bill_payment_expense',NULL,NULL,NULL,'detail_type',14,'unapplied_cash_bill_payment_expense_desc',1,NULL,NULL),(149,'utilities',NULL,NULL,NULL,'detail_type',14,'utilities_desc',1,NULL,NULL),(150,'amortisation',NULL,NULL,NULL,'detail_type',15,'amortisation_desc',1,NULL,NULL),(151,'depreciation',NULL,NULL,NULL,'detail_type',15,'depreciation_desc',1,NULL,NULL),(152,'exchange_gain_or_loss',NULL,NULL,NULL,'detail_type',15,'exchange_gain_or_loss_desc',1,NULL,NULL),(153,'other_expense',NULL,NULL,NULL,'detail_type',15,'other_expense_desc',1,NULL,NULL),(154,'penalties_and_settlements',NULL,NULL,NULL,'detail_type',15,'penalties_and_settlements_desc',1,NULL,NULL);
/*!40000 ALTER TABLE `accounting_account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `gl_code` varchar(191) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_sub_type_id` bigint(20) DEFAULT NULL,
  `detail_type_id` bigint(20) DEFAULT NULL,
  `parent_account_id` bigint(20) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts` WRITE;
/*!40000 ALTER TABLE `accounting_accounts` DISABLE KEYS */;
INSERT INTO `accounting_accounts` VALUES (1,'Accounts Payable (A/P)',NULL,1,'liability',6,58,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(2,'Credit Card',NULL,1,'liability',7,59,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(3,'Wage expenses',NULL,1,'expenses',14,140,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(4,'Utilities',NULL,1,'expenses',14,149,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(5,'Unrealised loss on securities, net of tax',NULL,1,'income',12,113,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(6,'Undeposited Funds',NULL,1,'asset',2,29,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(7,'Uncategorised Income',NULL,1,'income',11,103,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(8,'Uncategorised Expense',NULL,1,'expenses',14,138,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(9,'Uncategorised Asset',NULL,1,'asset',2,26,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(10,'Unapplied Cash Payment Income',NULL,1,'income',11,105,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(11,'Travel expenses - selling expense',NULL,1,'expenses',14,147,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(12,'Travel expenses - general and admin expenses',NULL,1,'expenses',14,146,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(13,'Supplies',NULL,1,'expenses',14,145,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(14,'Subcontractors - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(15,'Stationery and printing',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(16,'Short-term debit',NULL,1,'liability',8,69,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(17,'Shipping and delivery expense',NULL,1,'expenses',14,143,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(18,'Share capital',NULL,1,'equity',10,95,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(19,'Sales of Product Income',NULL,1,'income',11,103,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(20,'Sales - wholesale',NULL,1,'income',11,102,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(21,'Sales - retail',NULL,1,'income',11,101,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(22,'Sales',NULL,1,'income',11,103,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(23,'Revenue - General',NULL,1,'income',11,100,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(24,'Retained Earnings',NULL,1,'equity',10,94,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(25,'Repair and maintenance',NULL,1,'expenses',14,142,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(26,'Rent or lease payments',NULL,1,'expenses',14,141,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(27,'Reconciliation Discrepancies',NULL,1,'expenses',15,153,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(28,'Purchases',NULL,1,'expenses',14,144,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(29,'Property, plant and equipment',NULL,1,'asset',4,42,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(30,'Prepaid Expenses',NULL,1,'asset',2,27,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(31,'Payroll liabilities',NULL,1,'liability',8,71,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(32,'Payroll Expenses',NULL,1,'expenses',14,140,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(33,'Payroll Clearing',NULL,1,'liability',8,70,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(34,'Overhead - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(35,'Other Types of Expenses-Advertising Expenses',NULL,1,'expenses',14,119,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(36,'Other selling expenses',NULL,1,'expenses',14,139,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(37,'Other operating income (expenses)',NULL,1,'income',12,111,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(38,'Other general and administrative expenses',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(39,'Other comprehensive income',NULL,1,'equity',10,87,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(40,'Other - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(41,'Office expenses',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(42,'Meals and entertainment',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(43,'Materials - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(44,'Management compensation',NULL,1,'expenses',14,135,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(45,'Loss on disposal of assets',NULL,1,'income',12,108,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(46,'Loss on discontinued operations, net of tax',NULL,1,'expenses',14,134,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(47,'Long-term investments',NULL,1,'asset',5,54,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(48,'Long-term debt',NULL,1,'liability',9,78,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(49,'Liabilities related to assets held for sale',NULL,1,'liability',9,77,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(50,'Legal and professional fees',NULL,1,'expenses',14,133,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(51,'Inventory Asset',NULL,1,'asset',2,21,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(52,'Inventory',NULL,1,'asset',2,21,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(53,'Interest income',NULL,1,'income',12,107,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(54,'Interest expense',NULL,1,'expenses',14,132,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(55,'Intangibles',NULL,1,'asset',5,51,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(56,'Insurance - Liability',NULL,1,'expenses',14,131,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(57,'Insurance - General',NULL,1,'expenses',14,131,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(58,'Insurance - Disability',NULL,1,'expenses',14,131,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(59,'Income tax payable',NULL,1,'liability',8,65,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(60,'Income tax expense',NULL,1,'expenses',14,130,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(61,'Goodwill',NULL,1,'asset',5,50,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(62,'Freight and delivery - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(63,'Equity in earnings of subsidiaries',NULL,1,'equity',10,84,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(64,'Equipment rental',NULL,1,'expenses',14,128,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(65,'Dues and Subscriptions',NULL,1,'expenses',14,127,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(66,'Dividends payable',NULL,1,'liability',8,64,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(67,'Dividend income',NULL,1,'income',12,106,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(68,'Dividend disbursed',NULL,1,'equity',10,83,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(69,'Discounts given - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(70,'Direct labour - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(71,'Deferred tax assets',NULL,1,'asset',5,49,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(72,'Cost of sales',NULL,1,'expenses',13,118,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(73,'Commissions and fees',NULL,1,'expenses',14,125,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(74,'Change in inventory - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(75,'Cash and cash equivalents',NULL,1,'asset',3,31,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(76,'Billable Expense Income',NULL,1,'income',11,103,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(77,'Bank charges',NULL,1,'expenses',14,123,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(78,'Bad debts',NULL,1,'expenses',14,122,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(79,'Available for sale assets (short-term)',NULL,1,'asset',2,18,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(80,'Assets held for sale',NULL,1,'asset',5,48,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(81,'Amortisation expense',NULL,1,'expenses',14,120,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(82,'Allowance for bad debts',NULL,1,'asset',2,17,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(83,'Accumulated depreciation on property, plant and equipment',NULL,1,'asset',4,38,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(84,'Accrued non-current liabilities',NULL,1,'liability',9,76,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(85,'Accrued liabilities',NULL,1,'liability',8,60,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(86,'Accrued holiday payable',NULL,1,'liability',9,75,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(87,'Accounts Receivable (A/R)',NULL,1,'asset',1,16,NULL,NULL,'active',1,'2024-10-07 13:34:00','2024-10-07 13:34:00'),(88,'Shahid',NULL,1,'asset',1,16,87,NULL,'active',1,'2024-10-07 13:37:41','2024-12-20 00:17:02');
/*!40000 ALTER TABLE `accounting_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_accounts_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `acc_trans_mapping_id` int(11) DEFAULT NULL COMMENT 'id form accounting_acc_trans_mapping table',
  `transaction_id` int(11) DEFAULT NULL COMMENT 'id form transactions table',
  `transaction_payment_id` int(11) DEFAULT NULL COMMENT 'id form transaction_payments table',
  `amount` decimal(22,4) NOT NULL,
  `type` varchar(100) NOT NULL COMMENT 'debit, credit etc',
  `sub_type` varchar(100) NOT NULL,
  `map_type` varchar(100) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounting_accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounting_accounts_transactions` VALUES (1,1,1,NULL,NULL,2000.0000,'debit','transfer',NULL,1,'2024-12-20 00:24:00',NULL,'2024-12-20 00:25:16','2024-12-20 00:25:16'),(2,3,1,NULL,NULL,2000.0000,'credit','transfer',NULL,1,'2024-12-20 00:24:00',NULL,'2024-12-20 00:25:16','2024-12-20 00:25:16');
/*!40000 ALTER TABLE `accounting_accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_budgets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `financial_year` int(11) NOT NULL,
  `jan` decimal(22,4) DEFAULT NULL,
  `feb` decimal(22,4) DEFAULT NULL,
  `mar` decimal(22,4) DEFAULT NULL,
  `apr` decimal(22,4) DEFAULT NULL,
  `may` decimal(22,4) DEFAULT NULL,
  `jun` decimal(22,4) DEFAULT NULL,
  `jul` decimal(22,4) DEFAULT NULL,
  `aug` decimal(22,4) DEFAULT NULL,
  `sep` decimal(22,4) DEFAULT NULL,
  `oct` decimal(22,4) DEFAULT NULL,
  `nov` decimal(22,4) DEFAULT NULL,
  `dec` decimal(22,4) DEFAULT NULL,
  `quarter_1` decimal(22,4) DEFAULT NULL,
  `quarter_2` decimal(22,4) DEFAULT NULL,
  `quarter_3` decimal(22,4) DEFAULT NULL,
  `quarter_4` decimal(22,4) DEFAULT NULL,
  `yearly` decimal(22,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_budgets` WRITE;
/*!40000 ALTER TABLE `accounting_budgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_budgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `account_details` text DEFAULT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) DEFAULT NULL,
  `event` varchar(191) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) DEFAULT NULL,
  `properties` text DEFAULT NULL,
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=278 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 19:47:46','2024-08-23 19:47:46'),(2,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 19:50:42','2024-08-23 19:50:42'),(3,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 20:00:13','2024-08-23 20:00:13'),(4,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 20:01:05','2024-08-23 20:01:05'),(5,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 20:01:11','2024-08-23 20:01:11'),(6,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 20:01:33','2024-08-23 20:01:33'),(7,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 20:01:48','2024-08-23 20:01:48'),(8,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 20:02:19','2024-08-23 20:02:19'),(9,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 20:02:47','2024-08-23 20:02:47'),(10,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-23 23:44:45','2024-08-23 23:44:45'),(11,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 17:04:06','2024-08-24 17:04:06'),(12,'default','added',2,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 17:05:28','2024-08-24 17:05:28'),(13,'default','added',3,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 17:05:47','2024-08-24 17:05:47'),(14,'default','added',4,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 17:06:04','2024-08-24 17:06:04'),(15,'default','added',5,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 17:06:25','2024-08-24 17:06:25'),(16,'default','added',3,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(17,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 18:52:54','2024-08-24 18:52:54'),(18,'default','added',6,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 19:00:33','2024-08-24 19:00:33'),(19,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 19:17:05','2024-08-24 19:17:05'),(20,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-24 20:17:00','2024-08-24 20:17:00'),(21,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 15:48:00','2024-08-26 15:48:00'),(22,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 17:02:18','2024-08-26 17:02:18'),(23,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 17:02:25','2024-08-26 17:02:25'),(24,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 17:55:52','2024-08-26 17:55:52'),(25,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 17:57:10','2024-08-26 17:57:10'),(26,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 18:12:11','2024-08-26 18:12:11'),(27,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 18:15:31','2024-08-26 18:15:31'),(28,'default','added',13,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12.5}}',NULL,'2024-08-26 18:15:53','2024-08-26 18:15:53'),(29,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 18:27:40','2024-08-26 18:27:40'),(30,'default','added',14,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":125}}',NULL,'2024-08-26 18:37:10','2024-08-26 18:37:10'),(31,'default','added',15,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":1262.5}}',NULL,'2024-08-26 18:43:25','2024-08-26 18:43:25'),(32,'default','added',16,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":700}}',NULL,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(33,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 19:43:18','2024-08-26 19:43:18'),(34,'default','edited',14,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"125.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}',NULL,'2024-08-26 19:48:39','2024-08-26 19:48:39'),(35,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-26 19:57:21','2024-08-26 19:57:21'),(36,'default','added',17,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":375}}',NULL,'2024-08-26 20:06:32','2024-08-26 20:06:32'),(37,'default','payment_edited',17,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"375.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"375.0000\"}}',NULL,'2024-08-26 20:10:33','2024-08-26 20:10:33'),(38,'default','added',18,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":150}}',NULL,'2024-08-26 20:20:26','2024-08-26 20:20:26'),(39,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-27 07:11:04','2024-08-27 07:11:04'),(40,'default','added',19,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":12.5}}',NULL,'2024-08-27 19:56:38','2024-08-27 19:56:38'),(41,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-27 20:08:42','2024-08-27 20:08:42'),(42,'default','payment_edited',17,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"375.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"375.0000\"}}',NULL,'2024-08-27 20:12:29','2024-08-27 20:12:29'),(43,'default','payment_edited',18,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"150.0000\"}}',NULL,'2024-08-27 20:12:29','2024-08-27 20:12:29'),(44,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-27 21:05:49','2024-08-27 21:05:49'),(45,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-29 16:37:13','2024-08-29 16:37:13'),(46,'default','added',25,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":387.5}}',NULL,'2024-08-30 14:10:38','2024-08-30 14:10:38'),(47,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-08-30 22:18:34','2024-08-30 22:18:34'),(48,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 10:39:45','2024-09-02 10:39:45'),(49,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 10:41:42','2024-09-02 10:41:42'),(50,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 10:42:50','2024-09-02 10:42:50'),(51,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 10:46:27','2024-09-02 10:46:27'),(52,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 17:00:31','2024-09-02 17:00:31'),(53,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 17:03:26','2024-09-02 17:03:26'),(54,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 17:04:40','2024-09-02 17:04:40'),(55,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 17:12:14','2024-09-02 17:12:14'),(56,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 17:12:49','2024-09-02 17:12:49'),(57,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 17:17:02','2024-09-02 17:17:02'),(58,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-09-02 17:19:27','2024-09-02 17:19:27'),(59,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2024-09-02 17:39:40','2024-09-02 17:39:40'),(60,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-02 20:11:11','2024-09-02 20:11:11'),(61,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-03 11:46:01','2024-09-03 11:46:01'),(62,'default','added',26,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2024-09-03 11:50:48','2024-09-03 11:50:48'),(63,'default','added',27,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2024-09-03 11:52:30','2024-09-03 11:52:30'),(64,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-03 12:19:13','2024-09-03 12:19:13'),(65,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2024-09-03 22:51:59','2024-09-03 22:51:59'),(66,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-04 23:54:54','2024-09-04 23:54:54'),(67,'default','added',4,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Wajih wajih boukadida\"}',NULL,'2024-09-04 23:59:13','2024-09-04 23:59:13'),(68,'default','edited',4,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Wajih wajih boukadida\"}',NULL,'2024-09-04 23:59:45','2024-09-04 23:59:45'),(69,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-05 14:50:53','2024-09-05 14:50:53'),(70,'default','created',1,'Modules\\Project\\Entities\\Project','created',NULL,1,'App\\User','{\"attributes\":{\"id\":1,\"business_id\":1,\"name\":\"sddsd\",\"contact_id\":2,\"status\":\"not_started\",\"lead_id\":1,\"start_date\":\"2024-09-18 00:00:00\",\"end_date\":\"2024-09-17 00:00:00\",\"description\":\"<p>sdsdsds<\\/p>\",\"created_by\":1,\"settings\":{\"enable_timelog\":1,\"enable_invoice\":1,\"enable_notes_documents\":1,\"members_crud_task\":0,\"members_crud_note\":0,\"members_crud_timelog\":0,\"task_view\":\"list_view\",\"task_id_prefix\":\"#\"},\"custom_field1\":null,\"custom_field2\":null,\"custom_field3\":null,\"custom_field4\":null,\"created_at\":\"2024-09-05T09:44:52.000000Z\",\"updated_at\":\"2024-09-05T09:44:52.000000Z\"}}',NULL,'2024-09-05 15:14:52','2024-09-05 15:14:52'),(71,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-09 19:38:16','2024-09-09 19:38:16'),(72,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-12 15:17:18','2024-09-12 15:17:18'),(73,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-12 16:06:52','2024-09-12 16:06:52'),(74,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-12 16:12:08','2024-09-12 16:12:08'),(75,'default','added',28,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":712.5}}',NULL,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(76,'default','added',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2024-09-12 16:15:15','2024-09-12 16:15:15'),(77,'default','added',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2024-09-12 16:16:04','2024-09-12 16:16:04'),(78,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-12 17:07:23','2024-09-12 17:07:23'),(79,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-12 21:18:19','2024-09-12 21:18:19'),(80,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-13 15:34:46','2024-09-13 15:34:46'),(81,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-14 12:55:48','2024-09-14 12:55:48'),(82,'default','added',31,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425}}',NULL,'2024-09-14 12:57:26','2024-09-14 12:57:26'),(83,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-14 13:06:13','2024-09-14 13:06:13'),(84,'default','added',32,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12.5}}',NULL,'2024-09-14 13:06:54','2024-09-14 13:06:54'),(85,'default','sell_deleted',32,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":32,\"invoice_no\":\"0006\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12.5000\"}}',NULL,'2024-09-14 13:08:23','2024-09-14 13:08:23'),(86,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-14 15:05:18','2024-09-14 15:05:18'),(87,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-14 15:58:08','2024-09-14 15:58:08'),(88,'default','login',6,'App\\User',NULL,5,6,'App\\User','[]',NULL,'2024-09-14 16:00:33','2024-09-14 16:00:33'),(89,'default','added',33,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12.5}}',NULL,'2024-09-14 16:56:00','2024-09-14 16:56:00'),(90,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-14 20:52:45','2024-09-14 20:52:45'),(91,'default','added',34,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":375}}',NULL,'2024-09-14 20:55:46','2024-09-14 20:55:46'),(92,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-16 09:12:56','2024-09-16 09:12:56'),(93,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-18 07:15:36','2024-09-18 07:15:36'),(94,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-19 08:56:45','2024-09-19 08:56:45'),(95,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-19 23:39:04','2024-09-19 23:39:04'),(96,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-24 09:17:48','2024-09-24 09:17:49'),(97,'default','added',35,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":400}}',NULL,'2024-09-24 09:31:43','2024-09-24 09:31:43'),(98,'default','added',36,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":400}}',NULL,'2024-09-24 09:33:13','2024-09-24 09:33:13'),(99,'default','added',37,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":187.5}}',NULL,'2024-09-24 09:34:42','2024-09-24 09:34:42'),(100,'default','payment_edited',36,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"400.0000\"}}',NULL,'2024-09-24 10:29:07','2024-09-24 10:29:07'),(101,'default','payment_edited',36,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"400.0000\"}}',NULL,'2024-09-24 10:29:09','2024-09-24 10:29:09'),(102,'default','payment_edited',37,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"187.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"187.5000\"}}',NULL,'2024-09-24 10:29:09','2024-09-24 10:29:09'),(103,'default','payment_edited',37,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"187.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"187.5000\"}}',NULL,'2024-09-24 10:31:14','2024-09-24 10:31:14'),(104,'default','payment_edited',37,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"187.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"187.5000\"}}',NULL,'2024-09-24 10:32:05','2024-09-24 10:32:05'),(105,'default','added',38,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":375}}',NULL,'2024-09-24 10:32:24','2024-09-24 10:32:24'),(106,'default','payment_edited',37,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"187.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"187.5000\"}}',NULL,'2024-09-24 14:01:30','2024-09-24 14:01:30'),(107,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-24 18:06:55','2024-09-24 18:06:55'),(108,'default','added',39,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":100}}',NULL,'2024-09-24 18:11:00','2024-09-24 18:11:00'),(109,'default','payment_edited',39,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"100.0000\"}}',NULL,'2024-09-24 18:18:00','2024-09-24 18:18:00'),(110,'default','added',40,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":562.5}}',NULL,'2024-09-24 18:44:58','2024-09-24 18:44:58'),(111,'default','payment_edited',40,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"562.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"562.5000\"}}',NULL,'2024-09-24 18:45:44','2024-09-24 18:45:44'),(112,'default','added',41,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":187.5}}',NULL,'2024-09-24 19:08:48','2024-09-24 19:08:48'),(113,'default','added',42,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":187.5}}',NULL,'2024-09-24 19:17:48','2024-09-24 19:17:48'),(114,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2024-09-24 20:23:37','2024-09-24 20:23:37'),(115,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-25 20:50:37','2024-09-25 20:50:37'),(116,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-25 20:51:25','2024-09-25 20:51:25'),(117,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-25 20:54:18','2024-09-25 20:54:18'),(118,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-25 20:54:22','2024-09-25 20:54:22'),(119,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-09-26 17:41:37','2024-09-26 17:41:37'),(120,'default','added',13,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-09-26 17:42:46','2024-09-26 17:42:46'),(121,'default','added',44,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":937.5}}',NULL,'2024-09-26 17:50:45','2024-09-26 17:50:45'),(122,'default','edited',44,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":937.5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"937.5000\"}}',NULL,'2024-09-26 17:51:51','2024-09-26 17:51:51'),(123,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-02 17:59:13','2024-10-02 17:59:13'),(124,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-06 11:57:06','2024-10-06 11:57:06'),(125,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-06 16:42:32','2024-10-06 16:42:32'),(126,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-07 13:31:37','2024-10-07 13:31:37'),(127,'default','added',14,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-10-07 13:33:35','2024-10-07 13:33:35'),(128,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-17 14:18:25','2024-10-17 14:18:25'),(129,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-18 14:50:46','2024-10-18 14:50:46'),(130,'default','edited',45,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"197.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"sub_status\":\"quotation\",\"final_total\":197.5}}',NULL,'2024-10-18 15:29:29','2024-10-18 15:29:29'),(131,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-18 16:25:23','2024-10-18 16:25:23'),(132,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-25 19:46:29','2024-10-25 19:46:29'),(133,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-25 19:49:23','2024-10-25 19:49:23'),(134,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-25 19:50:14','2024-10-25 19:50:14'),(135,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-25 19:50:50','2024-10-25 19:50:50'),(136,'default','added',46,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2024-10-25 19:52:17','2024-10-25 19:52:17'),(137,'default','added',47,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":200}}',NULL,'2024-10-25 19:52:47','2024-10-25 19:52:47'),(138,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-29 13:15:37','2024-10-29 13:15:37'),(139,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-29 14:57:06','2024-10-29 14:57:06'),(140,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-29 21:35:08','2024-10-29 21:35:08'),(141,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-10-30 15:15:29','2024-10-30 15:15:29'),(142,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-06 23:00:07','2024-11-06 23:00:07'),(143,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-07 18:19:21','2024-11-07 18:19:21'),(144,'default','added',48,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":375}}',NULL,'2024-11-07 18:21:40','2024-11-07 18:21:40'),(145,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-09 13:37:26','2024-11-09 13:37:26'),(146,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-11 19:51:57','2024-11-11 19:51:57'),(147,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-12 18:54:43','2024-11-12 18:54:43'),(148,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-12 18:56:18','2024-11-12 18:56:18'),(149,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-13 04:48:20','2024-11-13 04:48:20'),(150,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-13 07:21:03','2024-11-13 07:21:03'),(151,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-13 15:05:10','2024-11-13 15:05:10'),(152,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-14 22:57:14','2024-11-14 22:57:14'),(153,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-15 14:41:12','2024-11-15 14:41:12'),(154,'default','added',49,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":750}}',NULL,'2024-11-15 14:47:01','2024-11-15 14:47:01'),(155,'default','added',52,'App\\Transaction',NULL,1,1,'App\\User','{\"from_api\":\"test_client\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"final_total\":25}}',NULL,'2024-11-15 15:03:57','2024-11-15 15:03:57'),(156,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-16 21:39:29','2024-11-16 21:39:29'),(157,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-17 06:01:55','2024-11-17 06:01:55'),(158,'default','added',53,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":362.5}}',NULL,'2024-11-17 06:15:38','2024-11-17 06:15:38'),(159,'default','added',54,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":937.5}}',NULL,'2024-11-17 06:16:51','2024-11-17 06:16:51'),(160,'default','added',55,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(161,'default','added',56,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":50}}',NULL,'2024-11-17 06:20:54','2024-11-17 06:20:54'),(162,'default','added',16,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-11-17 06:25:00','2024-11-17 06:25:00'),(163,'default','added',57,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":25}}',NULL,'2024-11-17 06:25:07','2024-11-17 06:25:07'),(164,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-18 16:18:08','2024-11-18 16:18:08'),(165,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-25 13:37:19','2024-11-25 13:37:19'),(166,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-25 22:33:53','2024-11-25 22:33:53'),(167,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-28 15:39:14','2024-11-28 15:39:14'),(168,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-29 08:34:21','2024-11-29 08:34:21'),(169,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-29 12:23:10','2024-11-29 12:23:10'),(170,'default','added',58,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8450}}',NULL,'2024-11-29 14:08:36','2024-11-29 14:08:36'),(171,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-11-30 00:05:00','2024-11-30 00:05:00'),(172,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-02 10:59:45','2024-12-02 10:59:45'),(173,'default','added',59,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2024-12-02 12:51:01','2024-12-02 12:51:01'),(174,'default','login',8,'App\\User',NULL,7,8,'App\\User','[]',NULL,'2024-12-02 14:10:05','2024-12-02 14:10:05'),(175,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-05 23:05:08','2024-12-05 23:05:08'),(176,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-06 03:00:57','2024-12-06 03:00:57'),(177,'default','added',60,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1175}}',NULL,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(178,'default','added',61,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2024-12-06 03:06:06','2024-12-06 03:06:06'),(179,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-06 04:17:58','2024-12-06 04:17:58'),(180,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-06 11:03:31','2024-12-06 11:03:31'),(181,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-07 14:38:44','2024-12-07 14:38:44'),(182,'default','added',63,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":387.5}}',NULL,'2024-12-07 14:45:50','2024-12-07 14:45:50'),(183,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-07 15:27:48','2024-12-07 15:27:48'),(184,'default','added',64,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2024-12-07 15:28:24','2024-12-07 15:28:24'),(185,'default','added',9,'App\\User',NULL,1,1,'App\\User','{\"name\":\"mr Yasir khan\"}',NULL,'2024-12-07 15:39:31','2024-12-07 15:39:31'),(186,'default','added',65,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12.5}}',NULL,'2024-12-07 15:50:30','2024-12-07 15:50:30'),(187,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-08 18:47:11','2024-12-08 18:47:11'),(188,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-09 10:40:44','2024-12-09 10:40:44'),(189,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-09 10:42:43','2024-12-09 10:42:43'),(190,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-10 23:00:08','2024-12-10 23:00:08'),(191,'default','added',18,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-12-10 23:22:29','2024-12-10 23:22:29'),(192,'default','added',66,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0}}',NULL,'2024-12-10 23:23:01','2024-12-10 23:23:01'),(193,'default','edited',66,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2024-12-10 23:41:04','2024-12-10 23:41:04'),(194,'default','added',67,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2024-12-10 23:44:01','2024-12-10 23:44:01'),(195,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-11 23:22:06','2024-12-11 23:22:06'),(196,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-12 00:03:33','2024-12-12 00:03:33'),(197,'default','added',69,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0}}',NULL,'2024-12-12 00:12:48','2024-12-12 00:12:48'),(198,'default','login',11,'App\\User',NULL,9,11,'App\\User','[]',NULL,'2024-12-12 22:15:22','2024-12-12 22:15:22'),(199,'default','logout',11,'App\\User',NULL,9,11,'App\\User','[]',NULL,'2024-12-12 23:21:26','2024-12-12 23:21:26'),(200,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-14 17:00:41','2024-12-14 17:00:41'),(201,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-15 12:32:37','2024-12-15 12:32:37'),(202,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-17 12:37:30','2024-12-17 12:37:30'),(203,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-19 13:34:33','2024-12-19 13:34:33'),(204,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-19 18:06:37','2024-12-19 18:06:37'),(205,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-19 23:50:33','2024-12-19 23:50:33'),(206,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-20 10:46:18','2024-12-20 10:46:18'),(207,'default','updated',1,'Modules\\Project\\Entities\\Project','updated',NULL,1,'App\\User','{\"attributes\":{\"status\":\"in_progress\",\"updated_at\":\"2024-12-20T06:06:02.000000Z\"},\"old\":{\"status\":\"not_started\",\"updated_at\":\"2024-09-05T09:44:52.000000Z\"}}',NULL,'2024-12-20 11:36:02','2024-12-20 11:36:02'),(208,'default','updated',1,'Modules\\Project\\Entities\\Project','updated',NULL,1,'App\\User','{\"attributes\":{\"status\":\"not_started\",\"updated_at\":\"2024-12-20T06:06:11.000000Z\"},\"old\":{\"status\":\"in_progress\",\"updated_at\":\"2024-12-20T06:06:02.000000Z\"}}',NULL,'2024-12-20 11:36:11','2024-12-20 11:36:11'),(209,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-23 15:24:53','2024-12-23 15:24:53'),(210,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-12-31 10:28:17','2024-12-31 10:28:17'),(211,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-07 12:26:12','2025-01-07 12:26:12'),(212,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-07 14:08:35','2025-01-07 14:08:35'),(213,'default','added',70,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":62775}}',NULL,'2025-01-07 14:15:24','2025-01-07 14:15:24'),(214,'default','added',71,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-01-07 14:16:27','2025-01-07 14:16:27'),(215,'default','added',72,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":100}}',NULL,'2025-01-07 14:17:29','2025-01-07 14:17:29'),(216,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-07 14:22:32','2025-01-07 14:22:32'),(217,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-07 18:00:16','2025-01-07 18:00:16'),(218,'default','added',73,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-01-07 18:01:20','2025-01-07 18:01:20'),(219,'default','payment_edited',37,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"187.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"187.5000\"}}',NULL,'2025-01-07 18:15:37','2025-01-07 18:15:37'),(220,'default','payment_edited',38,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"375.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"375.0000\"}}',NULL,'2025-01-07 18:15:37','2025-01-07 18:15:37'),(221,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-09 15:36:54','2025-01-09 15:36:54'),(222,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-12 04:38:22','2025-01-12 04:38:22'),(223,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-14 23:14:54','2025-01-14 23:14:54'),(224,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-19 21:13:05','2025-01-19 21:13:05'),(225,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-19 21:14:14','2025-01-19 21:14:14'),(226,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-23 13:59:18','2025-01-23 13:59:18'),(227,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-24 17:15:07','2025-01-24 17:15:07'),(228,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-24 17:28:36','2025-01-24 17:28:36'),(229,'default','added',21,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-01-27 13:11:31','2025-01-27 13:11:31'),(230,'default','added',76,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"shipping_status\":\"shipped\",\"final_total\":300}}',NULL,'2025-01-27 13:16:20','2025-01-27 13:16:20'),(231,'default','edited',76,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"proforma\",\"shipping_status\":\"shipped\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"shipping_status\":\"shipped\",\"final_total\":\"300.0000\"}}',NULL,'2025-01-27 13:17:36','2025-01-27 13:17:36'),(232,'default','added',22,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-01-27 13:24:15','2025-01-27 13:24:15'),(233,'default','added',77,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":350}}',NULL,'2025-01-27 13:25:51','2025-01-27 13:25:51'),(234,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-07 11:08:10','2025-02-07 11:08:10'),(235,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-07 12:21:57','2025-02-07 12:21:57'),(236,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-07 16:57:32','2025-02-07 16:57:32'),(237,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-09 00:58:47','2025-02-09 00:58:47'),(238,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-10 17:41:53','2025-02-10 17:41:53'),(239,'default','added',78,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2025-02-10 19:54:58','2025-02-10 19:54:58'),(240,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-12 04:22:49','2025-02-12 04:22:49'),(241,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-13 11:22:15','2025-02-13 11:22:15'),(242,'default','login',13,'App\\User',NULL,11,13,'App\\User','[]',NULL,'2025-02-15 11:41:11','2025-02-15 11:41:11'),(243,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-17 13:18:41','2025-02-17 13:18:41'),(244,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-17 20:35:06','2025-02-17 20:35:06'),(245,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-18 18:20:01','2025-02-18 18:20:01'),(246,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-19 14:03:09','2025-02-19 14:03:09'),(247,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-19 14:18:58','2025-02-19 14:18:58'),(248,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-20 06:07:30','2025-02-20 06:07:30'),(249,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-20 11:53:05','2025-02-20 11:53:05'),(250,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-20 23:42:27','2025-02-20 23:42:27'),(251,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-21 07:34:59','2025-02-21 07:34:59'),(252,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-21 08:47:37','2025-02-21 08:47:37'),(253,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-21 11:21:12','2025-02-21 11:21:12'),(254,'default','added',79,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2025-02-21 12:23:43','2025-02-21 12:23:43'),(255,'default','added',80,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2025-02-21 12:26:31','2025-02-21 12:26:31'),(256,'default','added',81,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2025-02-21 12:45:02','2025-02-21 12:45:02'),(257,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-21 15:20:55','2025-02-21 15:20:55'),(258,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-21 15:52:07','2025-02-21 15:52:07'),(259,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-21 16:57:21','2025-02-21 16:57:21'),(260,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-21 22:52:14','2025-02-21 22:52:15'),(261,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-22 15:54:01','2025-02-22 15:54:01'),(262,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-22 15:56:20','2025-02-22 15:56:20'),(263,'default','added',82,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-02-22 16:07:35','2025-02-22 16:07:35'),(264,'default','added',83,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2025-02-22 16:11:20','2025-02-22 16:11:20'),(265,'default','edited',1,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Mr Ahmet \"}',NULL,'2025-02-22 16:30:06','2025-02-22 16:30:06'),(266,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-22 16:30:17','2025-02-22 16:30:17'),(267,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-22 16:30:58','2025-02-22 16:30:58'),(268,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-23 14:13:03','2025-02-23 14:13:03'),(269,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-23 22:21:33','2025-02-23 22:21:33'),(270,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-24 04:52:38','2025-02-24 04:52:38'),(271,'default','added',84,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2025-02-24 04:53:25','2025-02-24 04:53:25'),(272,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-24 10:04:13','2025-02-24 10:04:13'),(273,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-24 10:25:18','2025-02-24 10:25:18'),(274,'default','added',85,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}',NULL,'2025-02-24 10:30:38','2025-02-24 10:30:38'),(275,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-24 10:32:14','2025-02-24 10:32:14'),(276,'default','added',86,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2025-02-24 11:49:31','2025-02-24 11:49:31'),(277,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-24 13:22:14','2025-02-24 13:22:14');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `aiassistance_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aiassistance_history` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `tool_type` varchar(191) NOT NULL,
  `input_data` text DEFAULT NULL,
  `tokens_used` int(11) NOT NULL DEFAULT 0,
  `output_data` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `aiassistance_history` WRITE;
/*!40000 ALTER TABLE `aiassistance_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `aiassistance_history` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_maintenances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset_maintenances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `asset_id` int(11) NOT NULL,
  `maitenance_id` varchar(191) DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `assigned_to` int(11) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `maintenance_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_maintenances_business_id_index` (`business_id`),
  KEY `asset_maintenances_asset_id_index` (`asset_id`),
  KEY `asset_maintenances_status_index` (`status`),
  KEY `asset_maintenances_priority_index` (`priority`),
  KEY `asset_maintenances_created_by_index` (`created_by`),
  KEY `asset_maintenances_assigned_to_index` (`assigned_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_maintenances` WRITE;
/*!40000 ALTER TABLE `asset_maintenances` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_maintenances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned DEFAULT NULL,
  `transaction_type` varchar(191) NOT NULL,
  `ref_no` varchar(191) NOT NULL,
  `receiver` int(10) unsigned DEFAULT NULL COMMENT 'id from users table, who receives asset',
  `quantity` decimal(22,4) NOT NULL,
  `transaction_datetime` datetime NOT NULL,
  `allocated_upto` date DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL COMMENT 'id from asset_transactions table',
  `created_by` int(10) unsigned NOT NULL COMMENT 'id from users table, who allocated asset',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_transactions_business_id_foreign` (`business_id`),
  KEY `asset_transactions_asset_id_foreign` (`asset_id`),
  KEY `asset_transactions_receiver_foreign` (`receiver`),
  KEY `asset_transactions_parent_id_foreign` (`parent_id`),
  KEY `asset_transactions_created_by_foreign` (`created_by`),
  CONSTRAINT `asset_transactions_asset_id_foreign` FOREIGN KEY (`asset_id`) REFERENCES `assets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `asset_transactions_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `asset_transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_receiver_foreign` FOREIGN KEY (`receiver`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_transactions` WRITE;
/*!40000 ALTER TABLE `asset_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset_warranties` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `additional_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_warranties` WRITE;
/*!40000 ALTER TABLE `asset_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `asset_code` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `model` varchar(191) DEFAULT NULL,
  `serial_no` varchar(191) DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_type` varchar(191) DEFAULT NULL,
  `unit_price` decimal(22,4) NOT NULL,
  `depreciation` decimal(22,4) DEFAULT NULL,
  `is_allocatable` tinyint(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_business_id_foreign` (`business_id`),
  KEY `assets_category_id_foreign` (`category_id`),
  KEY `assets_created_by_foreign` (`created_by`),
  CONSTRAINT `assets_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `assets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 06:13:44','2017-12-18 06:13:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 06:04:39','2017-12-18 06:10:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 05:55:40','2017-12-18 05:55:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 05:58:40','2017-12-18 05:58:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 05:51:10','2017-12-18 05:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 05:51:10','2017-12-18 05:51:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) NOT NULL,
  `booking_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
INSERT INTO `bookings` VALUES (1,2,NULL,NULL,1,1,7,'2024-11-17 21:47:00','2024-11-17 21:47:00',1,'booked',NULL,'2024-11-16 21:47:26','2024-11-16 21:47:26');
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `use_for_repair` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'brands to be used on repair module',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'Kix','Kix Oil',1,0,NULL,'2024-08-24 18:55:08','2024-08-24 18:55:08'),(2,1,'aser',NULL,1,1,NULL,'2024-08-24 19:21:28','2024-08-24 19:21:28'),(3,1,'Adidas','Adidas',1,0,NULL,'2024-08-24 19:46:02','2024-08-24 19:46:02'),(4,1,'Apple',NULL,1,0,NULL,'2024-08-24 19:46:14','2024-08-24 19:46:14'),(5,1,'Levis','Levis',1,0,NULL,'2024-08-24 19:46:30','2024-08-24 19:46:30'),(6,1,'Lipton','Lipton',1,0,NULL,'2024-08-24 19:46:42','2024-08-24 19:46:42'),(7,1,'Nike','Nike',1,0,NULL,'2024-08-24 19:46:55','2024-08-24 19:46:55'),(8,1,'Oreo','Oreo',1,0,NULL,'2024-08-24 19:47:07','2024-08-24 19:47:07'),(9,1,'Samsung','Samsung',1,0,NULL,'2024-08-24 19:47:20','2024-08-24 19:47:20'),(10,1,'Sharewood','Sharewood',1,0,NULL,'2024-08-24 19:47:33','2024-08-24 19:47:33'),(11,1,'U.S. Polo Assn.','U.S. Polo Assn.',1,0,NULL,'2024-08-24 19:47:43','2024-08-24 19:47:43'),(12,1,'Barilla',NULL,1,0,NULL,'2024-08-29 16:42:15','2024-08-29 16:42:15'),(13,1,'Nike','Nk',1,0,'2024-12-06 13:21:54','2024-12-06 13:19:05','2024-12-06 13:21:54'),(14,1,'Dunlop',NULL,1,0,NULL,'2024-12-10 23:17:51','2024-12-10 23:17:51'),(15,1,'Toyota',NULL,1,0,NULL,'2025-01-27 13:40:09','2025-01-27 13:40:09');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) DEFAULT NULL,
  `tax_label_1` varchar(10) DEFAULT NULL,
  `tax_number_2` varchar(100) DEFAULT NULL,
  `tax_label_2` varchar(10) DEFAULT NULL,
  `code_label_1` varchar(191) DEFAULT NULL,
  `code_1` varchar(191) DEFAULT NULL,
  `code_label_2` varchar(191) DEFAULT NULL,
  `code_2` varchar(191) DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') NOT NULL DEFAULT 'includes',
  `logo` varchar(191) DEFAULT NULL,
  `sku_prefix` varchar(191) DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text DEFAULT NULL,
  `pos_settings` text DEFAULT NULL,
  `woocommerce_api_settings` text DEFAULT NULL,
  `woocommerce_skipped_orders` text DEFAULT NULL,
  `woocommerce_wh_oc_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_ou_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_od_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_or_secret` varchar(191) DEFAULT NULL,
  `essentials_settings` longtext DEFAULT NULL,
  `manufacturing_settings` text DEFAULT NULL,
  `weighing_scale_setting` text NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT 0,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') NOT NULL DEFAULT 'before',
  `enabled_modules` text DEFAULT NULL,
  `date_format` varchar(191) NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT 2,
  `quantity_precision` tinyint(4) NOT NULL DEFAULT 2,
  `ref_no_prefixes` text DEFAULT NULL,
  `theme_color` char(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `crm_settings` text DEFAULT NULL,
  `asset_settings` text DEFAULT NULL,
  `accounting_settings` text DEFAULT NULL,
  `prj_setting` longtext DEFAULT NULL,
  `repair_settings` text DEFAULT NULL,
  `repair_jobsheet_settings` text DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text DEFAULT NULL,
  `sms_settings` text DEFAULT NULL,
  `custom_labels` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Majid Saif',77,'1970-01-01','0',NULL,'0','GST',NULL,NULL,NULL,NULL,NULL,25.00,1,'Asia/Karachi',1,'fifo',0.00,'includes',NULL,NULL,1,'add_manufacturing','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"show_pricing_on_product_sugesstion\":\"1\",\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}','{\"woocommerce_app_url\":\"https:\\/\\/karachicloth.com\\/\",\"woocommerce_consumer_key\":\"ck_e6da542e4afa695e304aaa61cc58aa5332baea3b\",\"woocommerce_consumer_secret\":\"cs_4d0d23188e7f320b401498c4124793ffc9c0bb56\",\"location_id\":\"7\",\"default_tax_class\":null,\"product_tax_type\":\"inc\",\"default_selling_price_group\":null,\"sync_description_as\":\"long\",\"product_fields_for_create\":[\"category\",\"quantity\"],\"manage_stock_for_create\":\"none\",\"in_stock_for_create\":\"none\",\"product_fields_for_update\":[\"name\",\"price\",\"category\",\"quantity\"],\"manage_stock_for_update\":\"none\",\"in_stock_for_update\":\"none\",\"order_statuses\":{\"pending\":null,\"processing\":null,\"on-hold\":null,\"completed\":null,\"cancelled\":null,\"refunded\":null,\"failed\":null,\"shipped\":null},\"shipping_statuses\":{\"pending\":null,\"processing\":null,\"on-hold\":null,\"completed\":null,\"cancelled\":null,\"refunded\":null,\"failed\":null,\"shipped\":null},\"woocommerce_wh_oc_secret\":null,\"woocommerce_wh_ou_secret\":null,\"woocommerce_wh_od_secret\":null,\"woocommerce_wh_or_secret\":null}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,1,1,1,0,0,0,1,NULL,0,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\",\"modifiers\",\"booking\",\"kitchen\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}','primary',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":\"Width\",\"custom_field_2\":\"Height\",\"custom_field_3\":\"Rim\",\"custom_field_4\":\"Model\",\"custom_field_5\":\"Make\",\"custom_field_6\":\"Load index\",\"custom_field_7\":\"Treadwear\",\"custom_field_8\":\"Detail\",\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":\"date\",\"dropdown_options\":null},\"7\":{\"type\":\"text\",\"dropdown_options\":null},\"8\":{\"type\":\"dropdown\",\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":\"Mfg date\",\"is_custom_field_1_required\":\"1\",\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"enable_purchase_order\":\"1\",\"default_datatable_page_entries\":\"25\"}',1,'2024-08-23 19:47:28','2025-02-24 10:28:06'),(2,'EXCELLENT TECH',97,'2024-09-02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,2,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(3,'Demo',3,'2024-09-03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,3,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(4,'Replypoints',133,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,5,'Africa/Nairobi',1,'fifo',NULL,'includes','1726299081_hikeview logo 1.png',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(5,'demo bussiness',91,'2024-09-14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,6,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(6,'SEASONS',75,'2024-11-15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,7,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(7,'Dar es Salaam BMS',138,NULL,NULL,'VAT',NULL,'WITH HOLDI',NULL,NULL,NULL,NULL,NULL,25.00,8,'Africa/Dar_es_Salaam',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(8,'SEASONS',75,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,10,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(9,'SEASONS',75,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,11,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(10,'fdsf',135,'2025-02-06','4565','dsf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,12,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(11,'wdasd',1,'2025-02-13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,13,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(12,'fluterdeveloper.ar',91,'2025-02-22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,14,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2025-02-22 17:18:54','2025-02-22 17:18:54');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) DEFAULT NULL,
  `name` varchar(256) NOT NULL,
  `landmark` text DEFAULT NULL,
  `country` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `zip_code` char(7) NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `sale_invoice_scheme_id` int(11) DEFAULT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `featured_products` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `default_payment_accounts` text DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `accounting_default_map` text DEFAULT NULL COMMENT 'Default transactions mapping of accounting module',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','asdasd','df','asdasdas','dasdasd','safasd','413412',1,1,1,1,NULL,1,'browser',NULL,'03064388224',NULL,NULL,NULL,NULL,0,'{\"cash\":{\"is_enabled\":\"1\"},\"card\":{\"is_enabled\":\"1\"},\"cheque\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"},\"custom_pay_2\":{\"is_enabled\":\"1\"},\"custom_pay_3\":{\"is_enabled\":\"1\"},\"custom_pay_4\":{\"is_enabled\":\"1\"},\"custom_pay_5\":{\"is_enabled\":\"1\"},\"custom_pay_6\":{\"is_enabled\":\"1\"},\"custom_pay_7\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-23 19:47:28','2024-09-25 20:58:45'),(2,1,'BL0002','dasdqw',NULL,'asdasda','dasdas','sdasd','3123123',1,1,1,1,NULL,1,'browser',NULL,'099866',NULL,NULL,NULL,NULL,0,'{\"cash\":{\"is_enabled\":\"1\"},\"card\":{\"is_enabled\":\"1\"},\"cheque\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"},\"custom_pay_2\":{\"is_enabled\":\"1\"},\"custom_pay_3\":{\"is_enabled\":\"1\"},\"custom_pay_4\":{\"is_enabled\":\"1\"},\"custom_pay_5\":{\"is_enabled\":\"1\"},\"custom_pay_6\":{\"is_enabled\":\"1\"},\"custom_pay_7\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 17:22:22','2024-09-25 20:59:03'),(3,2,'BL0001','EXCELLENT TECH','SAFASF','QATAR','DOHA','DOHA','670564',2,NULL,2,2,NULL,1,'browser',NULL,'64564596','457642432','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(4,3,'BL0001','Demo','000','uae','sharjah','sharjah','0000',3,NULL,3,3,NULL,1,'browser',NULL,'','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(5,4,'BL0001','Replypoints','Hipson','Kenya','Nairobi County','thika','0100',4,NULL,4,4,NULL,1,'browser',NULL,'0710632400','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(6,5,'BL0001','demo bussiness','Freshly','Pakistan','punjab','Lahore','54000',5,NULL,5,5,NULL,1,'browser',NULL,'03044762779','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(7,1,'BL0003','Hitup - Slough Shop',NULL,'United Kingdom','Berskhire','Slough','SL1 1FQ',1,1,1,1,NULL,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"card\":{\"is_enabled\":\"1\"},\"cheque\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"},\"custom_pay_2\":{\"is_enabled\":\"1\"},\"custom_pay_3\":{\"is_enabled\":\"1\"},\"custom_pay_4\":{\"is_enabled\":\"1\"},\"custom_pay_5\":{\"is_enabled\":\"1\"},\"custom_pay_6\":{\"is_enabled\":\"1\"},\"custom_pay_7\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-25 20:56:18','2024-09-25 20:56:18'),(8,1,'BL0004','Hitup - London Shop',NULL,'United Kingdom','London','London','SW19 8U',1,1,1,1,NULL,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"card\":{\"is_enabled\":\"1\"},\"cheque\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"},\"custom_pay_2\":{\"is_enabled\":\"1\"},\"custom_pay_3\":{\"is_enabled\":\"1\"},\"custom_pay_4\":{\"is_enabled\":\"1\"},\"custom_pay_5\":{\"is_enabled\":\"1\"},\"custom_pay_6\":{\"is_enabled\":\"1\"},\"custom_pay_7\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-25 20:58:01','2024-09-25 20:58:01'),(9,6,'BL0001','SEASONS','1234.456','Malaysia','Perak','Sitiawan','32000',6,NULL,6,6,NULL,1,'browser',NULL,'0125057166','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(10,7,'BL0001','Dar es Salaam BMS','DSM','Tanzania','Dar es Salaam','Dar es Salaam','0507',7,NULL,7,7,NULL,1,'browser',NULL,'','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(11,8,'BL0001','SEASONS','1234.456','Malaysia','Perak','Sitiawan','32000',8,NULL,8,8,NULL,1,'browser',NULL,'','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(12,9,'BL0001','SEASONS','1234.456','Malaysia','Perak','Sitiawan','32000',9,NULL,9,9,NULL,1,'browser',NULL,'','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(13,10,'BL0001','fdsf','sdfds','australia','fsd','fsdf','556',11,NULL,10,10,NULL,1,'browser',NULL,'','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(14,11,'BL0001','wdasd','sdf','wdeqw','fdsf','fewfwe','5',12,NULL,11,11,NULL,1,'browser',NULL,'','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(15,12,'BL0001','fluterdeveloper.ar','BULAWAYO','Pakistan','punjab','Lahore','54000',14,NULL,12,12,NULL,1,'browser',NULL,'','','','https://codepul.com/',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(16,12,'fff','Driver One','fg','fg','fg','fg','fg',14,14,12,12,0,1,'browser',NULL,'+33 6 25 25 54 52',NULL,'admin@admin.com','https://codepul.com/',NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"card\":{\"is_enabled\":\"1\"},\"cheque\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"},\"custom_pay_2\":{\"is_enabled\":\"1\"},\"custom_pay_3\":{\"is_enabled\":\"1\"},\"custom_pay_4\":{\"is_enabled\":\"1\"},\"custom_pay_5\":{\"is_enabled\":\"1\"},\"custom_pay_6\":{\"is_enabled\":\"1\"},\"custom_pay_7\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-22 17:20:38','2025-02-22 17:20:38');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pay_method` varchar(191) DEFAULT NULL,
  `type` enum('debit','credit') NOT NULL,
  `transaction_type` varchar(191) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,12.5000,'cash','credit','sell',13,'2024-08-26 18:15:52','2024-08-26 18:15:52'),(2,1,712.5000,'cash','credit','sell',28,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(3,1,500.0000,'cash','credit','sell',28,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(4,1,-500.0000,'cash','credit','sell',28,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(5,1,50.0000,'cash','credit','sell',29,'2024-09-12 16:15:15','2024-09-12 16:15:15'),(6,1,100.0000,'card','credit','sell',30,'2024-09-12 16:16:04','2024-09-12 16:16:04'),(7,1,425.0000,'cash','credit','sell',31,'2024-09-14 12:57:26','2024-09-14 12:57:26'),(9,1,12.5000,'cash','credit','sell',33,'2024-09-14 16:56:00','2024-09-14 16:56:00'),(10,1,375.0000,'cash','credit','sell',34,'2024-09-14 20:55:46','2024-09-14 20:55:46'),(11,1,375.0000,'cash','credit','sell',34,'2024-09-14 20:55:46','2024-09-14 20:55:46'),(12,1,-375.0000,'cash','credit','sell',34,'2024-09-14 20:55:46','2024-09-14 20:55:46'),(13,1,200.0000,'cash','credit','sell',46,'2024-10-25 19:52:17','2024-10-25 19:52:17'),(14,1,375.0000,'cash','credit','sell',48,'2024-11-07 18:21:40','2024-11-07 18:21:40'),(15,1,362.5000,'cash','credit','sell',53,'2024-11-17 06:15:38','2024-11-17 06:15:38'),(16,1,937.5000,'cash','credit','sell',54,'2024-11-17 06:16:51','2024-11-17 06:16:51'),(17,1,15.0000,'cash','credit','sell',55,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(18,1,10.0000,'cash','credit','sell',55,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(19,1,10.0000,'cash','credit','sell',55,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(20,1,-10.0000,'cash','credit','sell',55,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(21,1,8450.0000,'card','credit','sell',58,'2024-11-29 14:08:36','2024-11-29 14:08:36'),(22,1,250.0000,'cash','credit','sell',59,'2024-12-02 12:51:01','2024-12-02 12:51:01'),(23,1,1175.0000,'cash','credit','sell',60,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(24,1,5.0000,'cash','debit','expense',61,'2024-12-06 03:06:06','2024-12-06 03:06:06'),(25,1,387.5000,'cash','credit','sell',63,'2024-12-07 14:45:50','2024-12-07 14:45:50'),(26,1,750.0000,'cash','credit','sell',64,'2024-12-07 15:28:24','2024-12-07 15:28:24'),(27,1,12.5000,'card','credit','sell',65,'2024-12-07 15:50:30','2024-12-07 15:50:30'),(28,1,50000.0000,'cash','credit','sell',70,'2025-01-07 14:15:24','2025-01-07 14:15:24'),(29,1,12775.0000,'cheque','credit','sell',70,'2025-01-07 14:15:24','2025-01-07 14:15:24'),(30,1,25.0000,'cash','credit','sell',71,'2025-01-07 14:16:27','2025-01-07 14:16:27'),(31,2,12345.0000,'cash','credit','initial',NULL,'2025-01-07 18:00:51','2025-01-07 18:00:51'),(32,2,25.0000,'cash','credit','sell',73,'2025-01-07 18:01:20','2025-01-07 18:01:20'),(33,2,450.0000,'cash','credit','sell',78,'2025-02-10 19:54:57','2025-02-10 19:54:57'),(34,2,450.0000,'cash','credit','sell',79,'2025-02-21 12:23:43','2025-02-21 12:23:43'),(35,2,350.0000,'cash','credit','sell',80,'2025-02-21 12:26:31','2025-02-21 12:26:31'),(36,2,250.0000,'cash','credit','sell',81,'2025-02-21 12:45:02','2025-02-21 12:45:02'),(37,2,25.0000,'cash','credit','sell',82,'2025-02-22 16:07:35','2025-02-22 16:07:35'),(38,2,25.0000,'cash','credit','sell',83,'2025-02-22 16:11:20','2025-02-22 16:11:20'),(39,2,100.0000,'cash','credit','sell',84,'2025-02-24 04:53:25','2025-02-24 04:53:25'),(40,2,125.0000,'cash','credit','sell',85,'2025-02-24 10:30:38','2025-02-24 10:30:38'),(41,2,1000.0000,'cash','credit','sell',86,'2025-02-24 11:49:31','2025-02-24 11:49:31');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `denominations` text DEFAULT NULL,
  `closing_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,1,'close','2025-01-07 14:18:09',56070.0000,3,1,NULL,NULL,'2024-08-23 19:59:00','2025-01-07 14:18:09'),(2,1,7,1,'open',NULL,0.0000,0,0,NULL,NULL,'2025-01-07 18:00:00','2025-01-07 18:00:51');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_cat_id` int(11) DEFAULT NULL,
  `category_type` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `slug` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_woocommerce_cat_id_index` (`woocommerce_cat_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Lubricant',1,'0123',0,1,44,'product',NULL,NULL,NULL,'2024-08-24 18:55:36','2025-02-07 16:43:44'),(2,'Accessories',1,'Accessories',0,1,45,'product','Accessories',NULL,NULL,'2024-08-24 19:36:14','2025-02-07 16:43:44'),(3,'Athletic Clothing',1,'03211',2,1,52,'product',NULL,NULL,NULL,'2024-08-24 19:36:46','2025-02-07 16:43:46'),(4,'Autobiography',1,'Accessories',2,1,53,'product','--Autobiography',NULL,NULL,'2024-08-24 19:37:11','2025-02-07 16:43:46'),(5,'Belts',1,'Accessories',2,1,54,'product','Belts',NULL,NULL,'2024-08-24 19:38:00','2025-02-07 16:43:46'),(6,'Book',1,'03212',0,1,46,'product','Book',NULL,NULL,'2024-08-24 19:39:25','2025-02-07 16:43:44'),(7,'Children\'s books',1,'03213',6,1,55,'product',NULL,NULL,NULL,'2024-08-24 19:40:18','2025-02-07 16:43:46'),(8,'Computer & Accessories',1,'03214',0,1,47,'product',NULL,NULL,NULL,'2024-08-24 19:41:13','2025-02-07 16:43:44'),(9,'Electronics',1,'03215',0,1,48,'product',NULL,NULL,NULL,'2024-08-24 19:41:56','2025-02-07 16:43:44'),(10,'Food & Grocery',1,NULL,0,1,49,'product',NULL,NULL,NULL,'2024-08-24 19:42:38','2025-02-07 16:43:44'),(11,'Men\'s',1,NULL,0,1,50,'product',NULL,NULL,NULL,'2024-08-24 19:43:01','2025-02-07 16:43:44'),(12,'Women\'s',1,NULL,0,1,51,'product',NULL,NULL,NULL,'2024-08-24 19:43:13','2025-02-07 16:43:44'),(13,'195',1,NULL,1,1,56,'product',NULL,NULL,NULL,'2024-12-11 00:11:18','2025-02-07 16:43:46');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cms_page_metas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_page_metas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cms_page_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(191) NOT NULL,
  `meta_value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cms_page_metas_cms_page_id_foreign` (`cms_page_id`),
  CONSTRAINT `cms_page_metas_cms_page_id_foreign` FOREIGN KEY (`cms_page_id`) REFERENCES `cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cms_page_metas` WRITE;
/*!40000 ALTER TABLE `cms_page_metas` DISABLE KEYS */;
INSERT INTO `cms_page_metas` VALUES (1,3,'industry','{\"id\":\"1\",\"title\":\"We\'re Ready For Your Business!\",\"description\":\"<p>If you\'re in need of business management software, you\'ve come to the right place.&nbsp;<\\/p>\\r\\n<p>We have a clean, modern modular design that is sure to fit your business!<\\/p>\",\"content\":[{\"icon\":\"fas fa-store-alt\",\"title\":\"Departmental Store\",\"description\":\"Looking for a software solution that can help you manage and sell all of your essential items in one place? Look no further than our one-stop departmental store software. Whether you need to sell clothes, shoes, bags, or any other type of item, our software has you covered. Plus, our easy-to-use interface makes it simple to get started selling right away. So why wait? Get started today!\"},{\"icon\":\"fas fa-store\",\"title\":\"Retail & Wholesale\",\"description\":\"A complete suite of features to manage both retail & wholesales stores. Set multiple prices for different customer segments or different business locations.\"},{\"icon\":\"fas fa-notes-medical\",\"title\":\"Pharmacy\",\"description\":\"Our software is perfect for any pharmaceutical company. You can set product expiration dates and lot numbers, and sell in different units of measure. Stop selling expired & to-be-expired items to customers. Check details reports on stock expiry by lot numbers\"},{\"icon\":\"fas fa-prescription-bottle\",\"title\":\"Liquor\",\"description\":\"Easy to use for every liquor shop. Sell in ml of simple sell the bottle, you can easily manage them.\"},{\"icon\":\"fas fa-mobile-alt\",\"title\":\"Mobile & Electronics\",\"description\":\"Record inventory serial number, sell items with particular serial number,\"},{\"icon\":\"fas fa-wrench\",\"title\":\"Repair Shop\",\"description\":\"A complete suite of features to manage repair business, create job sheet, assign job sheet to technician, repair status, convert job sheet to invoices. Self link for customers to check repair progress\"},{\"icon\":\"fas fa-home\",\"title\":null,\"description\":null},{\"icon\":\"fas fa-home\",\"title\":null,\"description\":null}]}',NULL,'2022-10-20 16:30:15'),(2,3,'feature','{\"id\":\"2\",\"title\":\"Features to skyrocket \\ud83d\\ude80 your business growth\",\"description\":\"<p>The pace of business growth has never been faster.<\\/p>\\r\\n<p>That\'s why we&rsquo;ve designed our cloud-based POS software to help you get ahead.<\\/p>\\r\\n<p>The easiest, most reliable way to grow and manage your business is right at your fingertips with our cloud-based POS and inventory management system.<\\/p>\\r\\n<p>Right software can be a lifesaver for your business, and with it, you can revolutionize your business\'s growth<\\/p>\",\"content\":[{\"icon\":\"fas fa-cloud\",\"title\":\"Access Anywhere!\",\"description\":\"Check your business data from anywhere, anytime. \\r\\nSee live updates in realtime\"},{\"icon\":\"fas fa-check-double\",\"title\":\"No Installation\",\"description\":\"No software to install, No hardware dependency. Just open browser & start using.\"},{\"icon\":\"fas fa-sitemap\",\"title\":\"MultiBranches & Warehouse\",\"description\":\"Manage stock of multiple branches  in one place effortlessly & real-time.\"},{\"icon\":\"fas fa-user-lock\",\"title\":\"User access limit\",\"description\":\"Powerful user Role & Permission management to limit employees  access to business data\"},{\"icon\":\"fas fa-cubes\",\"title\":\"Stock Management\",\"description\":\"Manage stocks with from multiple locations, stock expiry, lot number, stock history & much more.\"},{\"icon\":\"fas fa-wrench\",\"title\":\"Service Management\",\"description\":\"Manage & easily invoice for services. Also dedicated repair service management features to schedule & deliver services on time\"},{\"icon\":\"fas fa-users\",\"title\":\"HR Management\",\"description\":\"With HR management easily track daily attendance, shift management, leaves, payroll, Holidays, Departments,  & Designations\"},{\"icon\":\"fas fa-handshake\",\"title\":\"Customer Management\",\"description\":\"CRM module help you to track leads lifecycle, followup with leads, sources, followup, launch campaigns, proposals and lot more\"},{\"icon\":\"fas fa-hand-peace\",\"title\":\"Simplified Interface\",\"description\":\"Simple to use interface to get work done in few clicks. Save your time & make it easy for staffs to use.\"},{\"icon\":\"fas fa-chart-line\",\"title\":\"Reports\",\"description\":\"Comes inbuilt with lot of report to help business owners analyse every revenue, inventory, payments & human resource.\"}]}','2022-09-15 15:34:41','2022-10-20 15:39:11');
/*!40000 ALTER TABLE `cms_page_metas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cms_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) NOT NULL,
  `layout` varchar(191) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `content` longtext DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `tags` varchar(191) DEFAULT NULL,
  `feature_image` varchar(191) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cms_pages` WRITE;
/*!40000 ALTER TABLE `cms_pages` DISABLE KEYS */;
INSERT INTO `cms_pages` VALUES (1,'testimonial',NULL,'David Parr','<p class=\"testimonial-card-1__paragraph mb-3\">This software has become one of the backbones of our business. It helped us streamline the data of all our warehouses &amp; shops on one platform. I am not much of a techy guy but the admin panel also allows you to customize every aspect of the application.</p>\r\n          <p class=\"testimonial-card-1__paragraph mb-3\">All the reports help me to give an overview of different aspects of our business.</p>\r\n          <p class=\"testimonial-card-1__paragraph mb-3\">It is very powerful!</p>',NULL,NULL,NULL,3,9,1,'2022-08-19 11:25:05','2022-10-20 17:48:29'),(2,'testimonial',NULL,'Tim Johnson','<p>It is truly designed to help my business run more smoothly and efficiently. I can now track and manage inventory, customer information, and sales easily. The installation was quick and easy, and the interface is very user-friendly. I can now manage almost every business operation with one single software!</p>',NULL,NULL,NULL,NULL,1,1,'2022-09-10 16:07:17','2022-10-20 17:23:39'),(3,'page','home','Automate your business management at very-Low cost','<p>Best POS, Invoicing, Inventory &amp; Service management application for your growing business!</p>',NULL,NULL,NULL,1,0,1,'2022-09-10 16:26:24','2022-10-20 16:30:15'),(4,'page','contact','Contact Us','<p>We\'re happy to receive your message. Ask us anything, we\'ll respond as soon as possible.</p>',NULL,NULL,NULL,NULL,0,1,'2022-09-10 16:26:24','2022-09-16 12:04:20'),(5,'testimonial',NULL,'Krishna Watt','<p>We have used this for 9 months now. It has helped our business grow by leaps and bounds. The interface and its simplicity have made it easy for us to learn and get familiar with. The best thing about this software is that it is cloud-based and we can use it from our shop, warehouse, or mobile while traveling. I can also see its potential as we continue to grow. Highly Satisfied!</p>',NULL,NULL,NULL,NULL,1,1,'2022-09-16 12:07:25','2022-10-20 17:27:31');
/*!40000 ALTER TABLE `cms_pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cms_site_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cms_site_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `site_key` varchar(191) NOT NULL,
  `site_value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cms_site_details` WRITE;
/*!40000 ALTER TABLE `cms_site_details` DISABLE KEYS */;
INSERT INTO `cms_site_details` VALUES (1,'faqs','[{\"question\":\"Why should we switch to cloud-based business management software compared to traditional desktop software?\",\"answer\":\"Cloud-based software provides you a low-cost, secure & mobile software solutions. Compared to traditional software that requires it to install on a computer - cloud-based can be accessed from anywhere without any hardware dependency.\"},{\"question\":\"How secure is my business data?\",\"answer\":\"All data are stored in our centralized database which is highly protected with multi-layers of privileges. We takes regular frequency interval automated backup to protect from any unwanted consequences.\"},{\"question\":\"Whom should I reach out to in case of any problems?\",\"answer\":\"Please contact our support, write us in the contact section or call to the number mentioned. You\'re assured to receive a response in a maximum of 24 hours.\"},{\"question\":\"Is this POS application Free?\",\"answer\":\"We do provide a free tier for very small business or business that is about to start. To take more advantage of this POS software we recommend that you upgrade to a better plan that unlocks more features.\"},{\"question\":\"Do you provide consultancy or implementation solutions for using this POS software?\",\"answer\":\"Yes, with a pro plan you can connect with one of our experts who will help you with implementing the solution for your business.\"},{\"question\":\"Are there any additional hardware required or subscription charges?\",\"answer\":\"This is cloud-based software. You\'ll only need a device with an internet connection & chrome browser. It runs within the browser. No additional hardware is required. But you can use some hardware like barcode scanners, and printers for your convenience to speed up work.\"}]','2022-09-13 18:44:10','2022-10-20 17:16:28'),(2,'statistics','{\"tagline\":\"POS\'s Stats & Numbers\",\"description\":\"More & More businesses are adopting our cloud-based business management solution\",\"content\":[{\"stats\":\"75\",\"title\":\"REGISTERED BUSINESSES\"},{\"stats\":\"400+\",\"title\":\"DAILY USERS\"},{\"stats\":\"50K\",\"title\":\"INVOICES CREATED\"},{\"stats\":\"126+\",\"title\":\"ONLINE RESOURCES\"}]}','2022-09-13 18:44:10','2022-10-20 17:08:07'),(3,'google_analytics','null','2022-09-14 11:14:40','2022-09-16 11:49:09'),(4,'fb_pixel','null','2022-09-14 11:14:40','2022-09-16 11:49:09'),(5,'custom_js','null','2022-09-14 11:14:40','2022-09-16 11:49:09'),(6,'custom_css','null','2022-09-14 11:14:40','2022-09-16 11:49:09'),(7,'meta_tags','null','2022-09-14 11:14:40','2022-09-16 11:49:09'),(8,'chat_widget','null','2022-09-14 11:27:14','2022-09-16 11:49:09'),(9,'contact_us','[{\"label\":\"Call\",\"num\":\"0000000000\"},{\"label\":\"Support\",\"num\":\"0000000000\"},{\"label\":\"Enquiry\",\"num\":\"0000000000\"}]','2022-09-14 12:24:38','2022-09-16 11:49:09'),(10,'mail_us','[{\"label\":\"Contact\",\"email\":\"contact@example.com\"},{\"label\":\"Support\",\"email\":\"support@example.com\"}]','2022-09-14 12:24:38','2022-09-16 11:49:09'),(11,'follow_us','{\"facebook\":\"https:\\/\\/www.facebook.com\\/test\",\"instagram\":\"https:\\/\\/www.instagram.com\\/test\",\"twitter\":\"https:\\/\\/twitter.com\\/test\",\"linkedin\":\"https:\\/\\/in.linkedin.com\\/company\\/test\",\"youtube\":\"https:\\/\\/www.youtube.com\\/c\\/test\"}','2022-09-14 12:35:39','2022-10-20 17:08:07'),(12,'logo','null','2022-09-14 13:38:53','2022-09-16 11:49:09'),(13,'notifiable_email','\"notifyme@example.com\"','2022-09-14 13:38:53','2022-09-16 11:49:09');
/*!40000 ALTER TABLE `cms_site_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) NOT NULL,
  `contact_type` varchar(191) DEFAULT NULL,
  `supplier_business_name` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `prefix` varchar(191) DEFAULT NULL,
  `first_name` varchar(191) DEFAULT NULL,
  `middle_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `contact_id` varchar(191) DEFAULT NULL,
  `contact_status` varchar(191) NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `address_line_1` text DEFAULT NULL,
  `address_line_2` text DEFAULT NULL,
  `zip_code` varchar(191) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) NOT NULL,
  `landline` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `converted_by` int(11) DEFAULT NULL,
  `converted_on` datetime DEFAULT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_rp` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `shipping_address` text DEFAULT NULL,
  `shipping_custom_field_details` longtext DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_field_1` varchar(191) DEFAULT NULL,
  `export_custom_field_2` varchar(191) DEFAULT NULL,
  `export_custom_field_3` varchar(191) DEFAULT NULL,
  `export_custom_field_4` varchar(191) DEFAULT NULL,
  `export_custom_field_5` varchar(191) DEFAULT NULL,
  `export_custom_field_6` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `crm_source` varchar(191) DEFAULT NULL,
  `crm_life_stage` varchar(191) DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `custom_field5` varchar(191) DEFAULT NULL,
  `custom_field6` varchar(191) DEFAULT NULL,
  `custom_field7` varchar(191) DEFAULT NULL,
  `custom_field8` varchar(191) DEFAULT NULL,
  `custom_field9` varchar(191) DEFAULT NULL,
  `custom_field10` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  KEY `contacts_crm_source_index` (`crm_source`),
  KEY `contacts_crm_life_stage_index` (`crm_life_stage`),
  KEY `contacts_converted_by_index` (`converted_by`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(2,1,'customer','individual',NULL,'Adil Autos',NULL,'Adil',NULL,'Autos',NULL,'CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0345',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 17:05:28','2024-08-24 17:05:28'),(3,1,'customer','individual',NULL,'Asad autos',NULL,'Asad',NULL,'autos',NULL,'CO0003','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'08997',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 17:05:47','2024-08-24 17:05:47'),(4,1,'customer','individual',NULL,'Imran Autos',NULL,'Imran',NULL,'Autos',NULL,'CO0004','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'354',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 17:06:04','2024-08-24 17:06:04'),(5,1,'customer','individual',NULL,'Kamran autos',NULL,'Kamran',NULL,'autos',NULL,'CO0005','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'34t4',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 17:06:25','2024-08-24 17:06:25'),(6,1,'supplier','business','Kix Company','',NULL,NULL,NULL,NULL,NULL,'0928373838','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1738373838393',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 19:00:33','2024-08-24 19:00:33'),(7,1,'customer',NULL,NULL,'gxjn ncc',NULL,'gxjn','ncc',NULL,NULL,'CO0007','active',NULL,NULL,NULL,NULL,'nv v',NULL,NULL,NULL,'958800....9.',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-27 19:56:27','2024-08-27 19:56:27'),(8,1,'customer',NULL,NULL,'gxjn ncc',NULL,'gxjn','ncc',NULL,NULL,'CO0008','active',NULL,NULL,NULL,NULL,'nv v',NULL,NULL,NULL,'958800....9.',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-27 19:56:29','2024-08-27 19:56:29'),(9,2,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,2,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(10,3,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,3,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(11,4,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,5,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(12,5,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,6,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(13,1,'customer','individual',NULL,'MR  M.Saqlain Butt','MR ','M.Saqlain',NULL,'Butt',NULL,'test','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-25','03044762779',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-26 17:42:46','2024-09-26 17:42:46'),(14,1,'customer','individual',NULL,'MR  test customer','MR ','test','customer',NULL,NULL,'Test customer','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'03044762779',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-07 13:33:35','2024-10-07 13:33:35'),(15,6,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,7,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(16,1,'customer','individual',NULL,'Said Ms','Said','Ms',NULL,NULL,NULL,'Jt44938','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'06565667777',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-17 06:25:00','2024-11-17 06:25:00'),(17,7,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,8,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(18,1,'supplier','business','Cash','',NULL,NULL,NULL,NULL,NULL,'CO0012','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'45556554',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-10 23:22:29','2024-12-10 23:22:29'),(19,8,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,10,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(20,9,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,11,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(21,1,'customer',NULL,NULL,'',NULL,NULL,NULL,NULL,'helpdesk@omnimedia.co.bw','0000100BW','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'71007000','3981926',NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-27 13:11:31','2025-01-27 13:11:31'),(22,1,'customer',NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,'George BW','active',NULL,'Gaborone',NULL,NULL,'Plot 36282',NULL,NULL,NULL,'71936485',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-27 13:24:15','2025-01-27 13:24:15'),(23,10,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,12,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(24,11,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,13,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(25,12,'customer',NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,14,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-22 17:18:54','2025-02-22 17:18:54');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_call_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_call_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `call_type` varchar(191) DEFAULT NULL,
  `mobile_number` varchar(191) NOT NULL,
  `mobile_name` varchar(191) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_call_logs_business_id_index` (`business_id`),
  KEY `crm_call_logs_user_id_index` (`user_id`),
  KEY `crm_call_logs_contact_id_index` (`contact_id`),
  KEY `crm_call_logs_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_call_logs` WRITE;
/*!40000 ALTER TABLE `crm_call_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_call_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_campaigns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_campaigns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `campaign_type` enum('sms','email') NOT NULL DEFAULT 'email',
  `subject` varchar(191) DEFAULT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `sent_on` datetime DEFAULT NULL,
  `contact_ids` text NOT NULL,
  `additional_info` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_campaigns_business_id_foreign` (`business_id`),
  KEY `crm_campaigns_created_by_index` (`created_by`),
  CONSTRAINT `crm_campaigns_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_campaigns` WRITE;
/*!40000 ALTER TABLE `crm_campaigns` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_campaigns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_contact_person_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_contact_person_commissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_person_id` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `commission_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_contact_person_commissions` WRITE;
/*!40000 ALTER TABLE `crm_contact_person_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_contact_person_commissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_followup_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_followup_invoices` (
  `follow_up_id` int(11) NOT NULL,
  `transaction_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_followup_invoices` WRITE;
/*!40000 ALTER TABLE `crm_followup_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_followup_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_lead_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_lead_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_lead_users_user_id_index` (`user_id`),
  KEY `crm_lead_users_contact_id_index` (`contact_id`),
  CONSTRAINT `crm_lead_users_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_lead_users` WRITE;
/*!40000 ALTER TABLE `crm_lead_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_lead_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_marketplaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_marketplaces` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `marketplace` varchar(191) DEFAULT NULL,
  `site_key` varchar(191) DEFAULT NULL,
  `site_id` varchar(191) DEFAULT NULL,
  `assigned_users` text DEFAULT NULL,
  `crm_source_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_marketplaces` WRITE;
/*!40000 ALTER TABLE `crm_marketplaces` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_marketplaces` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_proposal_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_proposal_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_proposal_templates_business_id_foreign` (`business_id`),
  KEY `crm_proposal_templates_created_by_index` (`created_by`),
  CONSTRAINT `crm_proposal_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_proposal_templates` WRITE;
/*!40000 ALTER TABLE `crm_proposal_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_proposal_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_proposals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_proposals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `sent_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_proposals_business_id_foreign` (`business_id`),
  KEY `crm_proposals_contact_id_foreign` (`contact_id`),
  KEY `crm_proposals_sent_by_index` (`sent_by`),
  CONSTRAINT `crm_proposals_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `crm_proposals_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_proposals` WRITE;
/*!40000 ALTER TABLE `crm_proposals` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_proposals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedule_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_schedule_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) unsigned NOT NULL,
  `log_type` enum('call','sms','meeting','email') NOT NULL DEFAULT 'email',
  `start_datetime` datetime NOT NULL,
  `end_datetime` datetime NOT NULL,
  `subject` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedule_logs_schedule_id_foreign` (`schedule_id`),
  KEY `crm_schedule_logs_created_by_index` (`created_by`),
  CONSTRAINT `crm_schedule_logs_schedule_id_foreign` FOREIGN KEY (`schedule_id`) REFERENCES `crm_schedules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedule_logs` WRITE;
/*!40000 ALTER TABLE `crm_schedule_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedule_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedule_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_schedule_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedule_users_schedule_id_foreign` (`schedule_id`),
  KEY `crm_schedule_users_user_id_index` (`user_id`),
  CONSTRAINT `crm_schedule_users_schedule_id_foreign` FOREIGN KEY (`schedule_id`) REFERENCES `crm_schedules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedule_users` WRITE;
/*!40000 ALTER TABLE `crm_schedule_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedule_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crm_schedules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `status` varchar(191) DEFAULT NULL,
  `start_datetime` datetime DEFAULT NULL,
  `end_datetime` datetime DEFAULT NULL,
  `description` text DEFAULT NULL,
  `schedule_type` enum('call','sms','meeting','email') NOT NULL DEFAULT 'email',
  `followup_category_id` int(11) DEFAULT NULL,
  `allow_notification` tinyint(1) NOT NULL DEFAULT 1,
  `notify_via` text DEFAULT NULL,
  `notify_before` int(11) DEFAULT NULL,
  `notify_type` enum('minute','hour','day') NOT NULL DEFAULT 'hour',
  `created_by` int(11) NOT NULL,
  `is_recursive` tinyint(1) NOT NULL DEFAULT 0,
  `recursion_days` int(11) DEFAULT NULL,
  `followup_additional_info` text DEFAULT NULL,
  `follow_up_by` varchar(191) DEFAULT NULL,
  `follow_up_by_value` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedules_created_by_index` (`created_by`),
  KEY `crm_schedules_business_id_index` (`business_id`),
  KEY `crm_schedules_contact_id_index` (`contact_id`),
  KEY `crm_schedules_schedule_type_index` (`schedule_type`),
  KEY `crm_schedules_notify_type_index` (`notify_type`),
  CONSTRAINT `crm_schedules_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedules` WRITE;
/*!40000 ALTER TABLE `crm_schedules` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `code` varchar(25) NOT NULL,
  `symbol` varchar(25) NOT NULL,
  `thousand_separator` varchar(10) NOT NULL,
  `decimal_separator` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `color` varchar(191) NOT NULL,
  `configuration` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `spg` varchar(100) DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
INSERT INTO `discounts` VALUES (1,'10% Discount',1,NULL,8,7,1,'percentage',10.0000,'2025-01-07 14:12:00','2031-11-26 14:12:00',1,NULL,1,'2025-01-07 14:13:07','2025-01-07 14:13:07');
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) NOT NULL,
  `heading` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_allowances_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_allowances_and_deductions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `description` varchar(191) NOT NULL,
  `type` enum('allowance','deduction') NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `amount_type` enum('fixed','percent') NOT NULL,
  `applicable_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_allowances_and_deductions_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_allowances_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `clock_in_time` datetime DEFAULT NULL,
  `clock_out_time` datetime DEFAULT NULL,
  `essentials_shift_id` int(11) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `clock_in_note` text DEFAULT NULL,
  `clock_out_note` text DEFAULT NULL,
  `clock_in_location` text DEFAULT NULL,
  `clock_out_location` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_attendances_user_id_index` (`user_id`),
  KEY `essentials_attendances_business_id_index` (`business_id`),
  KEY `essentials_attendances_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_attendances` WRITE;
/*!40000 ALTER TABLE `essentials_attendances` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_attendances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_document_shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_document_shares` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(11) NOT NULL,
  `value_type` enum('user','role') NOT NULL,
  `value` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_document_shares_document_id_index` (`document_id`),
  KEY `essentials_document_shares_value_type_index` (`value_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_document_shares` WRITE;
/*!40000 ALTER TABLE `essentials_document_shares` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_document_shares` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type` varchar(191) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_documents` WRITE;
/*!40000 ALTER TABLE `essentials_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_documents` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_holidays_business_id_index` (`business_id`),
  KEY `essentials_holidays_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_holidays` WRITE;
/*!40000 ALTER TABLE `essentials_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_holidays` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_kb` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` bigint(20) unsigned NOT NULL,
  `title` varchar(191) NOT NULL,
  `content` longtext DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `kb_type` varchar(191) NOT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL COMMENT 'id from essentials_kb table',
  `share_with` varchar(191) DEFAULT NULL COMMENT 'public, private, only_with',
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_business_id_index` (`business_id`),
  KEY `essentials_kb_parent_id_index` (`parent_id`),
  KEY `essentials_kb_created_by_index` (`created_by`),
  CONSTRAINT `essentials_kb_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `essentials_kb` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb` WRITE;
/*!40000 ALTER TABLE `essentials_kb` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_kb_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `kb_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_users_kb_id_index` (`kb_id`),
  KEY `essentials_kb_users_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb_users` WRITE;
/*!40000 ALTER TABLE `essentials_kb_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leave_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_leave_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leave_type` varchar(191) NOT NULL,
  `max_leave_count` int(11) DEFAULT NULL,
  `leave_count_interval` enum('month','year') DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leave_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leave_types` WRITE;
/*!40000 ALTER TABLE `essentials_leave_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leave_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_leaves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `essentials_leave_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `ref_no` varchar(191) DEFAULT NULL,
  `status` enum('pending','approved','cancelled') DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `status_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leaves_essentials_leave_type_id_index` (`essentials_leave_type_id`),
  KEY `essentials_leaves_business_id_index` (`business_id`),
  KEY `essentials_leaves_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leaves` WRITE;
/*!40000 ALTER TABLE `essentials_leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leaves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_messages_business_id_index` (`business_id`),
  KEY `essentials_messages_user_id_index` (`user_id`),
  KEY `essentials_messages_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_messages` WRITE;
/*!40000 ALTER TABLE `essentials_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_messages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_group_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_payroll_group_transactions` (
  `payroll_group_id` bigint(20) unsigned NOT NULL,
  `transaction_id` int(11) NOT NULL,
  KEY `essentials_payroll_group_transactions_payroll_group_id_foreign` (`payroll_group_id`),
  CONSTRAINT `essentials_payroll_group_transactions_payroll_group_id_foreign` FOREIGN KEY (`payroll_group_id`) REFERENCES `essentials_payroll_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_group_transactions` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_payroll_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL COMMENT 'payroll for work location',
  `name` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `payment_status` varchar(191) NOT NULL DEFAULT 'due',
  `gross_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_groups` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_reminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `end_time` time DEFAULT NULL,
  `repeat` enum('one_time','every_day','every_week','every_month') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_reminders_business_id_index` (`business_id`),
  KEY `essentials_reminders_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_reminders` WRITE;
/*!40000 ALTER TABLE `essentials_reminders` DISABLE KEYS */;
INSERT INTO `essentials_reminders` VALUES (1,1,1,'rahul call','2024-09-05','04:12:00','16:13:00','one_time','2024-09-05 16:09:15','2024-09-05 16:09:15'),(2,1,1,'call to sumit','2024-09-05','16:15:00','16:16:00','one_time','2024-09-05 16:11:06','2024-09-05 16:11:06');
/*!40000 ALTER TABLE `essentials_reminders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `type` enum('fixed_shift','flexible_shift') NOT NULL DEFAULT 'fixed_shift',
  `business_id` int(11) NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `is_allowed_auto_clockout` tinyint(1) NOT NULL DEFAULT 0,
  `auto_clockout_time` time DEFAULT NULL,
  `holidays` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_shifts_type_index` (`type`),
  KEY `essentials_shifts_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_to_dos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_to_dos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `task` text NOT NULL,
  `date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `task_id` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `estimated_hours` varchar(191) DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_to_dos_status_index` (`status`),
  KEY `essentials_to_dos_priority_index` (`priority`),
  KEY `essentials_to_dos_created_by_index` (`created_by`),
  KEY `essentials_to_dos_business_id_index` (`business_id`),
  KEY `essentials_to_dos_task_id_index` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_to_dos` WRITE;
/*!40000 ALTER TABLE `essentials_to_dos` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_to_dos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todo_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_todo_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment` text NOT NULL,
  `task_id` int(11) NOT NULL,
  `comment_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_todo_comments_task_id_index` (`task_id`),
  KEY `essentials_todo_comments_comment_by_index` (`comment_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todo_comments` WRITE;
/*!40000 ALTER TABLE `essentials_todo_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todo_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todos_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_todos_users` (
  `todo_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todos_users` WRITE;
/*!40000 ALTER TABLE `essentials_todos_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todos_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_allowance_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_user_allowance_and_deductions` (
  `user_id` int(11) NOT NULL,
  `allowance_deduction_id` int(11) NOT NULL,
  KEY `essentials_user_allowance_and_deductions_user_id_index` (`user_id`),
  KEY `allow_deduct_index` (`allowance_deduction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_allowance_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_sales_targets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_user_sales_targets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `target_start` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `target_end` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `commission_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_sales_targets` WRITE;
/*!40000 ALTER TABLE `essentials_user_sales_targets` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_sales_targets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `essentials_user_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `essentials_shift_id` int(11) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_user_shifts_user_id_index` (`user_id`),
  KEY `essentials_user_shifts_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_user_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `header_text` text DEFAULT NULL,
  `invoice_no_prefix` varchar(191) DEFAULT NULL,
  `quotation_no_prefix` varchar(191) DEFAULT NULL,
  `invoice_heading` varchar(191) DEFAULT NULL,
  `sub_heading_line1` varchar(191) DEFAULT NULL,
  `sub_heading_line2` varchar(191) DEFAULT NULL,
  `sub_heading_line3` varchar(191) DEFAULT NULL,
  `sub_heading_line4` varchar(191) DEFAULT NULL,
  `sub_heading_line5` varchar(191) DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) DEFAULT NULL,
  `invoice_heading_paid` varchar(191) DEFAULT NULL,
  `quotation_heading` varchar(191) DEFAULT NULL,
  `sub_total_label` varchar(191) DEFAULT NULL,
  `discount_label` varchar(191) DEFAULT NULL,
  `tax_label` varchar(191) DEFAULT NULL,
  `total_label` varchar(191) DEFAULT NULL,
  `round_off_label` varchar(191) DEFAULT NULL,
  `total_due_label` varchar(191) DEFAULT NULL,
  `paid_label` varchar(191) DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) DEFAULT NULL,
  `client_tax_label` varchar(191) DEFAULT NULL,
  `date_label` varchar(191) DEFAULT NULL,
  `date_time_format` varchar(191) DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_image` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) DEFAULT NULL,
  `table_qty_label` varchar(191) DEFAULT NULL,
  `table_unit_price_label` varchar(191) DEFAULT NULL,
  `table_subtotal_label` varchar(191) DEFAULT NULL,
  `cat_code_label` varchar(191) DEFAULT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) DEFAULT NULL,
  `commission_agent_label` varchar(191) DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT 0,
  `show_reward_point` tinyint(1) NOT NULL DEFAULT 0,
  `highlight_color` varchar(10) DEFAULT NULL,
  `footer_text` text DEFAULT NULL,
  `module_info` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `show_letter_head` tinyint(1) NOT NULL DEFAULT 0,
  `letter_head` varchar(191) DEFAULT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT 0,
  `qr_code_fields` text DEFAULT NULL,
  `design` varchar(190) DEFAULT 'classic',
  `cn_heading` varchar(191) DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) DEFAULT NULL,
  `cn_amount_label` varchar(191) DEFAULT NULL,
  `table_tax_headings` text DEFAULT NULL,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT 0,
  `prev_bal_label` varchar(191) DEFAULT NULL,
  `change_return_label` varchar(191) DEFAULT NULL,
  `product_custom_fields` text DEFAULT NULL,
  `contact_custom_fields` text DEFAULT NULL,
  `location_custom_fields` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,1,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,2,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(3,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,3,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(4,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,4,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(5,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,5,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(6,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,6,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(7,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,7,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(8,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,8,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(9,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,9,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(10,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,10,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(11,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,11,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(12,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,12,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-22 17:18:54','2025-02-22 17:18:54');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `scheme_type` enum('blank','year') NOT NULL,
  `number_type` varchar(100) NOT NULL DEFAULT 'sequential',
  `prefix` varchar(191) DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  KEY `invoice_schemes_number_type_index` (`number_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','sequential','',1,34,4,1,'2024-08-23 19:47:28','2025-02-24 11:49:31'),(2,2,'Default','blank','sequential','',1,0,4,1,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(3,3,'Default','blank','sequential','',1,0,4,1,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(4,4,'Default','blank','sequential','',1,0,4,1,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(5,5,'Default','blank','sequential','',1,0,4,1,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(6,6,'Default','blank','sequential','',1,0,4,1,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(7,7,'Default','blank','sequential','',1,0,4,1,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(8,8,'Default','blank','sequential','',1,0,4,1,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(9,9,'Default','blank','sequential','',1,0,4,1,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(10,1,'Car Rental','year','sequential',NULL,0,0,4,0,'2025-01-27 12:55:10','2025-01-27 12:55:10'),(11,10,'Default','blank','sequential','',1,0,4,1,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(12,11,'Default','blank','sequential','',1,0,4,1,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(13,1,'HPMC 200 S 25kG','blank','random',NULL,0,0,5,0,'2025-02-18 18:25:03','2025-02-18 18:25:03'),(14,12,'Default','blank','sequential','',1,0,4,1,'2025-02-22 17:18:54','2025-02-22 17:18:54');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) NOT NULL,
  `woocommerce_media_id` int(11) DEFAULT NULL,
  `model_media_type` varchar(191) DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`),
  KEY `media_woocommerce_media_id_index` (`woocommerce_media_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
INSERT INTO `media` VALUES (1,1,'1724506097_1755495781_Kixx.G1-SP-20W-50-1L (1).png',NULL,1,'App\\Product',NULL,NULL,3,'2024-08-24 18:58:17','2025-02-07 16:31:34'),(2,1,'1724510034_2094543658_1528727849_macbookair.jpg',NULL,1,'App\\Product',NULL,NULL,7,'2024-08-24 20:03:54','2025-02-07 16:31:34'),(3,1,'1724930663_689053019_1528727999_lipton_tea.jpg',NULL,1,'App\\Variation',NULL,NULL,16,'2024-08-29 16:54:23','2025-02-07 16:31:34');
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_ingredient_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mfg_ingredient_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_ingredient_groups` WRITE;
/*!40000 ALTER TABLE `mfg_ingredient_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_ingredient_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_recipe_ingredients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mfg_recipe_ingredients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mfg_recipe_id` int(10) unsigned NOT NULL,
  `variation_id` int(11) NOT NULL,
  `mfg_ingredient_group_id` int(11) DEFAULT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `waste_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `sub_unit_id` int(11) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mfg_recipe_ingredients_mfg_recipe_id_index` (`mfg_recipe_id`),
  KEY `mfg_recipe_ingredients_variation_id_index` (`variation_id`),
  KEY `mfg_recipe_ingredients_sub_unit_id_index` (`sub_unit_id`),
  CONSTRAINT `mfg_recipe_ingredients_mfg_recipe_id_foreign` FOREIGN KEY (`mfg_recipe_id`) REFERENCES `mfg_recipes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_recipe_ingredients` WRITE;
/*!40000 ALTER TABLE `mfg_recipe_ingredients` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_recipe_ingredients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_recipes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mfg_recipes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  `instructions` text DEFAULT NULL,
  `waste_percent` decimal(10,2) NOT NULL DEFAULT 0.00,
  `ingredients_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `extra_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `production_cost_type` varchar(191) DEFAULT 'percentage',
  `total_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `final_price` decimal(22,4) NOT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mfg_recipes_product_id_index` (`product_id`),
  KEY `mfg_recipes_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_recipes` WRITE;
/*!40000 ALTER TABLE `mfg_recipes` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_recipes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=455 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),(279,'2022_04_21_083327_create_cash_denominations_table',1),(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1),(283,'2022_07_13_114307_create_purchase_requisition_related_columns',1),(284,'2022_08_25_132707_add_service_staff_timer_fields_to_products_and_users_table',1),(285,'2023_01_28_114255_add_letter_head_column_to_invoice_layouts_table',1),(286,'2023_02_11_161510_add_event_column_to_activity_log_table',1),(287,'2023_02_11_161511_add_batch_uuid_column_to_activity_log_table',1),(288,'2023_03_02_170312_add_provider_to_oauth_clients_table',1),(289,'2023_03_21_122731_add_sale_invoice_scheme_id_business_table',1),(290,'2023_03_21_170446_add_number_type_to_invoice_scheme',1),(291,'2023_04_17_155216_add_custom_fields_to_products',1),(292,'2023_04_28_130247_add_price_type_to_group_price_table',1),(293,'2023_06_21_033923_add_delivery_person_in_transactions',1),(294,'2023_09_13_153555_add_service_staff_pin_columns_in_users',1),(295,'2023_09_15_154404_add_is_kitchen_order_in_transactions',1),(296,'2023_12_06_152840_add_contact_type_in_contacts',1),(297,'2020_08_18_123107_add_connector_module_version_to_system_table',2),(298,'2019_03_07_155813_make_repair_statuses_table',3),(299,'2019_03_08_120634_add_repair_columns_to_transactions_table',3),(300,'2019_03_14_182704_add_repair_permissions',3),(301,'2019_03_29_110241_add_repair_version_column_to_system_table',3),(302,'2019_04_12_113901_add_repair_settings_column_to_business_table',3),(303,'2020_05_05_125008_create_device_models_table',3),(304,'2020_05_06_103135_add_repair_model_id_column_to_products_table',3),(305,'2020_07_11_120308_add_columns_to_repair_statuses_table',3),(306,'2020_07_31_130737_create_job_sheets_table',3),(307,'2020_08_07_124241_add_job_sheet_id_to_transactions_table',3),(308,'2020_08_22_104640_add_email_template_field_to_repair_status_table',3),(309,'2020_10_19_131934_add_job_sheet_custom_fields_to_repair_job_sheets_table',3),(310,'2020_11_25_111050_add_parts_column_to_repair_job_sheets_table',3),(311,'2020_12_30_101842_add_use_for_repair_column_to_brands_table',3),(312,'2021_02_16_190423_add_repair_module_indexing',3),(313,'2022_12_23_162847_add_repair_jobsheet_settings_column_to_business_table',3),(314,'2022_08_04_143146_create_cms_pages_table',4),(315,'2022_09_10_161849_add_layout_column_to_cms_pages_table',4),(316,'2022_09_10_163209_create_cms_site_details_table',4),(317,'2022_09_15_122547_create_cms_page_metas_table',4),(318,'2022_09_16_130337_create_default_data_for_cms',4),(319,'2019_11_12_163135_create_projects_table',5),(320,'2019_11_12_164431_create_project_members_table',5),(321,'2019_11_14_112230_create_project_tasks_table',5),(322,'2019_11_14_112258_create_project_task_members_table',5),(323,'2019_11_18_154617_create_project_task_comments_table',5),(324,'2019_11_19_134807_create_project_time_logs_table',5),(325,'2019_12_11_102549_add_more_fields_in_transactions_table',5),(326,'2019_12_11_102735_create_invoice_lines_table',5),(327,'2020_01_07_172852_add_project_permissions',5),(328,'2020_01_08_115422_add_project_module_version_to_system_table',5),(329,'2020_07_10_114514_set_location_id_on_existing_invoice',5),(330,'2023_11_14_125332_prj_setting_in_business',5),(331,'2023_11_14_170736_add_custom_columns_pjt_projects',5),(332,'2019_07_15_114211_add_manufacturing_module_version_to_system_table',6),(333,'2019_07_15_114403_create_mfg_recipes_table',6),(334,'2019_07_18_180217_add_production_columns_to_transactions_table',6),(335,'2019_07_26_110753_add_manufacturing_settings_column_to_business_table',6),(336,'2019_07_26_170450_add_manufacturing_permissions',6),(337,'2019_08_08_110035_create_mfg_recipe_ingredients_table',6),(338,'2019_08_08_172837_add_recipe_add_edit_permissions',6),(339,'2019_08_12_114610_add_ingredient_waste_percent_columns',6),(340,'2019_11_05_115136_create_ingredient_groups_table',6),(341,'2020_02_22_120303_add_column_to_mfg_recipe_ingredients_table',6),(342,'2020_08_19_103831_add_production_cost_type_to_recipe_and_transaction_table',6),(343,'2021_02_16_190302_add_manufacturing_module_indexing',6),(344,'2021_04_07_154331_add_mfg_ingredient_group_id_to_transaction_sell_lines_table',6),(345,'2022_10_31_115725_create_accounting_account_types_table',7),(346,'2022_11_01_104108_create_accounting_accounts_table',7),(347,'2022_11_10_135427_create_accounts_transactions_table',7),(348,'2022_11_14_171948_create_accounting_acc_trans_mapping',7),(349,'2022_12_02_133536_create_accounting_budgets_table',7),(350,'2022_12_19_124743_add_accounting_settings_column_to_business_table',7),(351,'2022_12_26_182821_AddAccountingModuleVersionToSystemTable',7),(352,'2023_05_25_131005_add_default_map_transactions_fields',7),(353,'2020_09_29_184909_add_product_catalogue_version',8),(354,'2020_08_19_175842_add_asset_management_module_version_to_system_table',9),(355,'2020_08_20_114339_create_assets_table',9),(356,'2020_08_20_173031_create_asset_transactions_table',9),(357,'2020_08_21_180138_add_asset_settings_column_to_business_table',9),(358,'2021_10_29_110841_create_asset_warranties_table',9),(359,'2022_03_26_062215_create_asset_maintenances_table',9),(360,'2022_05_11_070711_add_maintenance_note_column_to_asset_maintenances_table',9),(361,'2018_10_01_151252_create_documents_table',10),(362,'2018_10_02_151803_create_document_shares_table',10),(363,'2018_10_09_134558_create_reminders_table',10),(364,'2018_11_16_170756_create_to_dos_table',10),(365,'2019_02_22_120329_essentials_messages',10),(366,'2019_02_22_161513_add_message_permissions',10),(367,'2019_03_29_164339_add_essentials_version_to_system_table',10),(368,'2019_05_17_153306_create_essentials_leave_types_table',10),(369,'2019_05_17_175921_create_essentials_leaves_table',10),(370,'2019_05_21_154517_add_essentials_settings_columns_to_business_table',10),(371,'2019_05_21_181653_create_table_essentials_attendance',10),(372,'2019_05_30_110049_create_essentials_payrolls_table',10),(373,'2019_06_04_105723_create_essentials_holidays_table',10),(374,'2019_06_28_134217_add_payroll_columns_to_transactions_table',10),(375,'2019_08_26_103520_add_approve_leave_permission',10),(376,'2019_08_27_103724_create_essentials_allowance_and_deduction_table',10),(377,'2019_08_27_105236_create_essentials_user_allowances_and_deductions',10),(378,'2019_09_20_115906_add_more_columns_to_essentials_to_dos_table',10),(379,'2019_09_23_120439_create_essentials_todo_comments_table',10),(380,'2019_12_05_170724_add_hrm_columns_to_users_table',10),(381,'2019_12_09_105809_add_allowance_and_deductions_permission',10),(382,'2020_03_28_152838_create_essentials_shift_table',10),(383,'2020_03_30_162029_create_user_shifts_table',10),(384,'2020_03_31_134558_add_shift_id_to_attendance_table',10),(385,'2020_11_05_105157_modify_todos_date_column_type',10),(386,'2020_11_11_174852_add_end_time_column_to_essentials_reminders_table',10),(387,'2020_11_26_170527_create_essentials_kb_table',10),(388,'2020_11_30_112615_create_essentials_kb_users_table',10),(389,'2021_02_12_185514_add_clock_in_location_to_essentials_attendances_table',10),(390,'2021_02_16_190203_add_essentials_module_indexing',10),(391,'2021_02_27_133448_add_columns_to_users_table',10),(392,'2021_03_04_174857_create_payroll_groups_table',10),(393,'2021_03_04_175025_create_payroll_group_transactions_table',10),(394,'2021_03_09_123914_add_auto_clockout_to_essentials_shifts',10),(395,'2021_06_17_121451_add_location_id_to_table',10),(396,'2021_09_28_091541_create_essentials_user_sales_targets_table',10),(397,'2020_03_19_130231_add_contact_id_to_users_table',11),(398,'2020_03_27_133605_create_schedules_table',11),(399,'2020_03_27_133628_create_schedule_users_table',11),(400,'2020_03_30_112834_create_schedule_logs_table',11),(401,'2020_04_02_182331_add_crm_module_version_to_system_table',11),(402,'2020_04_08_153231_modify_cloumn_in_contacts_table',11),(403,'2020_04_09_101052_create_lead_users_table',11),(404,'2020_04_16_114747_create_crm_campaigns_table',11),(405,'2021_01_07_155757_add_followup_additional_info_column_to_crm_schedules_table',11),(406,'2021_02_02_140021_add_additional_info_to_crm_campaigns_table',11),(407,'2021_02_02_173651_add_new_columns_to_contacts_table',11),(408,'2021_02_04_120439_create_call_logs_table',11),(409,'2021_02_08_172047_add_mobile_name_column_to_crm_call_logs_table',11),(410,'2021_02_16_190038_add_crm_module_indexing',11),(411,'2021_02_19_120846_create_crm_followup_invoices',11),(412,'2021_02_22_132125_add_follow_up_by_to_crm_schedules_table',11),(413,'2021_03_24_160736_add_department_and_designation_to_users_table',11),(414,'2021_06_15_152924_create_proposal_templates_table',11),(415,'2021_06_16_114448_add_recursive_fields_to_crm_schedules_table',11),(416,'2021_06_16_125740_create_proposals_table',11),(417,'2021_09_24_065738_add_crm_settings_column_to_business_table',11),(418,'2022_02_09_055012_create_crm_marketplaces_table',11),(419,'2022_02_17_113045_add_source_id_to_marketplace',11),(420,'2022_03_02_180929_add_followup_category_id',11),(421,'2022_05_26_061553_create_crm_contact_person_commissions_table',11),(422,'2022_06_06_073006_add_cc_and_bcc_columns_to_crm_proposals_table',11),(423,'2023_02_17_140135_AddVersionForAiAssistance',12),(424,'2023_02_21_182321_create_aiassistance_generation_table',12),(425,'2018_06_27_185405_create_packages_table',13),(426,'2018_06_28_182803_create_subscriptions_table',13),(427,'2018_07_17_182021_add_rows_to_system_table',13),(428,'2018_07_19_131721_add_options_to_packages_table',13),(429,'2018_08_17_155534_add_min_termination_alert_days',13),(430,'2018_08_28_105945_add_business_based_username_settings_to_system_table',13),(431,'2018_08_30_105906_add_superadmin_communicator_logs_table',13),(432,'2018_11_02_130636_add_custom_permissions_to_packages_table',13),(433,'2018_11_05_161848_add_more_fields_to_packages_table',13),(434,'2018_12_10_124621_modify_system_table_values_null_default',13),(435,'2019_05_10_135434_add_missing_database_column_indexes',13),(436,'2019_08_16_115300_create_superadmin_frontend_pages_table',13),(437,'2023_06_10_132121_create_coupons_table',13),(438,'2023_06_16_141928_add_column_in_subscriptions',13),(439,'2023_06_29_183442_add_mark_package_as_popular',13),(440,'2023_07_04_151432_add_column_business',13),(441,'2023_07_13_191306_add_businesses_column_in_coupons',13),(442,'2018_10_10_110400_add_module_version_to_system_table',14),(443,'2018_10_10_122845_add_woocommerce_api_settings_to_business_table',14),(444,'2018_10_10_162041_add_woocommerce_category_id_to_categories_table',14),(445,'2018_10_11_173839_create_woocommerce_sync_logs_table',14),(446,'2018_10_16_123522_add_woocommerce_tax_rate_id_column_to_tax_rates_table',14),(447,'2018_10_23_111555_add_woocommerce_attr_id_column_to_variation_templates_table',14),(448,'2018_12_03_163945_add_woocommerce_permissions',14),(449,'2019_02_18_154414_change_woocommerce_sync_logs_table',14),(450,'2019_04_19_174129_add_disable_woocommerce_sync_column_to_products_table',14),(451,'2019_06_08_132440_add_woocommerce_wh_oc_secret_column_to_business_table',14),(452,'2019_10_01_171828_add_woocommerce_media_id_columns',14),(453,'2020_09_07_124952_add_woocommerce_skipped_orders_fields_to_business_table',14),(454,'2021_02_16_190608_add_woocommerce_module_indexing',14);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES (80,'App\\User',1),(80,'App\\User',4),(111,'App\\User',9);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(2,'App\\User',4),(2,'App\\User',9),(4,'App\\User',2),(6,'App\\User',3),(8,'App\\User',5),(10,'App\\User',6),(12,'App\\User',7),(14,'App\\User',8),(16,'App\\User',10),(18,'App\\User',11),(20,'App\\User',12),(22,'App\\User',13),(24,'App\\User',14);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) NOT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `whatsapp_text` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `cc` varchar(191) DEFAULT NULL,
  `bcc` varchar(191) DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(11,2,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(12,2,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(13,2,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(14,2,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(15,2,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(16,2,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(17,2,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(18,2,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(19,2,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(20,2,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(21,3,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(22,3,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(23,3,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(24,3,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(25,3,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(26,3,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(27,3,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(28,3,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(29,3,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(30,3,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(31,4,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(32,4,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(33,4,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(34,4,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(35,4,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(36,4,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(37,4,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(38,4,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(39,4,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(40,4,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(41,5,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(42,5,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(43,5,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(44,5,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(45,5,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(46,5,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(47,5,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(48,5,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(49,5,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(50,5,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(51,6,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(52,6,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(53,6,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(54,6,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(55,6,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(56,6,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(57,6,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(58,6,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(59,6,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(60,6,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(61,7,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(62,7,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(63,7,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(64,7,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(65,7,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(66,7,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(67,7,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(68,7,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(69,7,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(70,7,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(71,8,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(72,8,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(73,8,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(74,8,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(75,8,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(76,8,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(77,8,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(78,8,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(79,8,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(80,8,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(81,9,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(82,9,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(83,9,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(84,9,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(85,9,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(86,9,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(87,9,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(88,9,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(89,9,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(90,9,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(91,10,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(92,10,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(93,10,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(94,10,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(95,10,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(96,10,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(97,10,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(98,10,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(99,10,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(100,10,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(101,11,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(102,11,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(103,11,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(104,11,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(105,11,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(106,11,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(107,11,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(108,11,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(109,11,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(110,11,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(111,12,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(112,12,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(113,12,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(114,12,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(115,12,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(116,12,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(117,12,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(118,12,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(119,12,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(120,12,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
INSERT INTO `notifications` VALUES ('cf5def58-5360-456d-9c3e-d3ce1567b6c4','Modules\\Project\\Notifications\\NewProjectAssignedNotification','App\\User',4,'{\"project_id\":1}',NULL,'2024-09-05 15:14:52','2024-09-05 15:14:52');
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
INSERT INTO `oauth_access_tokens` VALUES ('094bcd59ec1d503e13966f18f6b9cca66ac2106ec1d6595f60b4777051e94b4710801d4e6be623f7',1,3,NULL,'[]',0,'2024-12-07 14:43:47','2024-12-07 14:43:47','2025-12-07 14:43:47'),('1f951bf9847373f32d92e738776e1b4f9c37bf8696d6e4399cbe026480a7b599a5a6323f0b3d45b9',1,3,NULL,'[]',0,'2024-08-26 18:35:36','2024-08-26 18:35:36','2025-08-26 18:35:36'),('2c7dcb0278cb10cff9c7808b4456820bb69d5788faefb86e00c0a7a4f570b170713e48bf767df76d',1,3,NULL,'[]',0,'2025-01-11 22:01:46','2025-01-11 22:01:46','2026-01-11 22:01:46'),('507b9807ae576606f8e70daafc697a9ac6fa89077139fb4cfbb5cace361bce817a4dfab305f1545d',1,3,NULL,'[]',0,'2024-09-24 19:16:38','2024-09-24 19:16:38','2025-09-24 19:16:38'),('5261985150c1c92082429c84b734d80aab00281df26234c5645da399dcb19185307f0fd63e89ed2b',1,3,NULL,'[]',0,'2024-08-23 19:56:23','2024-08-23 19:56:23','2025-08-23 19:56:23'),('54f0d7777c4cce032707595b3cb35bb142939e29688c9a1545234bb5979fb0d96b20c19f4d9a5a13',1,3,NULL,'[]',0,'2024-09-24 19:04:59','2024-09-24 19:04:59','2025-09-24 19:04:59'),('5ebcaade66163355430344437b92e86fa5311fc8066f536d8e4002c911a328a0cbae6f46655e0880',1,3,NULL,'[]',0,'2024-09-24 18:09:06','2024-09-24 18:09:06','2025-09-24 18:09:06'),('670893602d8ea2a2e4cfdc8a5ee19e58419d23f5b123b8fe0c7ff504f7ae767dec411f1f2b2f4776',1,3,NULL,'[]',0,'2024-08-24 20:11:22','2024-08-24 20:11:22','2025-08-24 20:11:22'),('736e432d3f48e5bbf01bb6049cdafaa12e5b4c3ee003979cdbf34f81720581e12b639d93b0bf6774',1,3,NULL,'[]',0,'2024-08-26 17:59:42','2024-08-26 17:59:42','2025-08-26 17:59:42'),('7fe99f98e6e53cbf8875460ebc65d8161dbec23670796f72d49061b28e365586d17c77a2588412aa',1,3,NULL,'[]',0,'2024-08-26 18:10:27','2024-08-26 18:10:27','2025-08-26 18:10:27'),('851487ea9f17f012240c1fce4b5638e2be387b89c0786b9c2a231bbb9497c8d13c917a10380f3236',1,3,NULL,'[]',0,'2024-10-02 18:36:51','2024-10-02 18:36:51','2025-10-02 18:36:51'),('87c0c091373b0d182f0f50ef4dfdb210d21fb6b966b86b5a6e57ff4899a8aa100611b2572e53a877',1,3,NULL,'[]',0,'2024-09-18 14:27:13','2024-09-18 14:27:13','2025-09-18 14:27:13'),('895119f9a48cab2102746ab9216ccc060fd14bed13dcf17000bc962bade723d30dd14d4fae979426',9,3,NULL,'[]',0,'2024-12-07 15:40:13','2024-12-07 15:40:13','2025-12-07 15:40:13'),('8af60e4e35c2cf0f98ff51f4a15bf631121cc9219b6c80f02a454bcf2c2c92fa95dfca2e25854afb',1,3,NULL,'[]',0,'2024-11-09 15:56:27','2024-11-09 15:56:27','2025-11-09 15:56:27'),('8c97edabf7d338ff8120f311f90146b2ea99d44f58b45879eb85779572619be8f73d83d5feafadef',1,3,NULL,'[]',0,'2024-09-24 18:04:30','2024-09-24 18:04:30','2025-09-24 18:04:30'),('91c09238ce4caeb06ebc52832b5f71a092661c04fbca722883c900672e61461d177fc1e1ffd95f5e',1,3,NULL,'[]',0,'2025-01-07 18:14:25','2025-01-07 18:14:25','2026-01-07 18:14:25'),('91d7eba09f32f171f96467fc34320414d28f119476b6f0802abdb1a498fce4a6ba652df3e71c041a',1,3,NULL,'[]',0,'2024-08-26 20:01:05','2024-08-26 20:01:05','2025-08-26 20:01:05'),('94f3564fe855db14b0276a40ab52e5b2b0672080cb05259548975404918ee13b1982cee18b315216',1,3,NULL,'[]',0,'2024-11-29 12:14:57','2024-11-29 12:14:57','2025-11-29 12:14:57'),('9696848d1301c38468e484c9d95dbb40fb19388c456c2af994986a47e5a0e5134d7f795d9d74e25c',1,3,NULL,'[]',0,'2024-09-24 00:10:35','2024-09-24 00:10:35','2025-09-24 00:10:35'),('96bc50051aea35058059d111df4037ef21a3b0e1b132c6447236c2d6dd0d71331bdc82f5df89a4c9',1,3,NULL,'[]',0,'2024-08-26 18:38:15','2024-08-26 18:38:15','2025-08-26 18:38:15'),('9868ab4d001299ab746a71b8964e5a006d3edd8bff4497026d633a747bf2a576cc266565af5c0226',1,3,NULL,'[]',0,'2024-11-29 12:40:51','2024-11-29 12:40:51','2025-11-29 12:40:51'),('ab41e2ccd5e7e328e4a0d9dbacb5cf69e3b9f2f645ec8a639d06cbcdc634cc17f65c58612e5eace6',1,3,NULL,'[]',0,'2024-11-15 14:44:53','2024-11-15 14:44:53','2025-11-15 14:44:53'),('ab5797290a9754fe1720089493aef1a1cc6b78a0f1fc8c204fda561b60e5b5f23bb81ff4cee633dc',1,3,NULL,'[]',0,'2024-08-30 14:08:05','2024-08-30 14:08:05','2025-08-30 14:08:05'),('c49c9cf7f0592d8dc4e2b447eebaa87414ba96d957a1cb381dacba50c0d658e5a8352a49515c24b6',1,3,NULL,'[]',0,'2024-08-26 20:11:24','2024-08-26 20:11:24','2025-08-26 20:11:24'),('c535e3e5d93fbfe7f9206f2e4dae84ccc46c7fbd3b3d73654295579a89e74b26ad835531c85ad303',1,3,NULL,'[]',0,'2024-08-26 19:10:38','2024-08-26 19:10:38','2025-08-26 19:10:38'),('c6c3abcc1c02a8b2dc1b84d574f8b13a39c4ad720b2c8925bfb47b6417c2bdb477e7766bed59bdbd',1,3,NULL,'[]',0,'2024-09-24 09:21:38','2024-09-24 09:21:38','2025-09-24 09:21:38'),('d30f6f09c41f411c515e2ad46b4681c7ec3350947487607b704955a7be1424bd5112c93dd4f199ff',1,3,NULL,'[]',0,'2024-09-07 20:25:55','2024-09-07 20:25:55','2025-09-07 20:25:55'),('ed6b921aa793199bfa77bd8823fa4ffc5e53160d223f04f525710609b14f4f57a2974b54282c5e55',1,3,NULL,'[]',0,'2024-11-09 13:43:40','2024-11-09 13:43:40','2025-11-09 13:43:40'),('f2bcb66af4eacf072dfb8fd88470a5f7efdcdf562feaa7e0082e727dd9e3f14086c8c1b3dbc76a58',1,3,NULL,'[]',0,'2024-12-12 23:21:12','2024-12-12 23:21:12','2025-12-12 23:21:12'),('f41e7719b0ce5c1800b9de3ac941dd0ead82fe4bca2f864d517bfa0215635baa3829da3b4f123bbe',1,3,NULL,'[]',0,'2024-08-27 20:03:46','2024-08-27 20:03:46','2025-08-27 20:03:46');
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `secret` varchar(100) NOT NULL,
  `provider` varchar(191) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES (1,NULL,'erp Personal Access Client','mGC7KLLTNE8q1yyKu65aWV0v2MuKRRQlvqdUzVvv',NULL,'http://localhost',1,0,0,'2024-08-23 19:48:32','2024-08-23 19:48:32'),(2,NULL,'erp Password Grant Client','kXKj1rz3lkmgxjXgh7uAdueZ0c3KU8dmnzpg6VQ0','users','http://localhost',0,1,0,'2024-08-23 19:48:32','2024-08-23 19:48:32'),(3,1,'test_client','A6pT1uNECWJKS9SGBHPTxNowKK24R40DBvAx6NhM',NULL,'http://localhost',0,1,0,'2024-08-23 19:51:18','2024-08-23 19:51:18'),(4,NULL,'erp Personal Access Client','EWr7XEvy8EB3FQm8s04hHXiSQoCrGijzFdvwerfx',NULL,'http://localhost',1,0,0,'2024-09-05 00:02:44','2024-09-05 00:02:44'),(5,NULL,'erp Password Grant Client','6XwYa2J72rEEnYsqotY68OXIfaveMzgJyXx8exoU','users','http://localhost',0,1,0,'2024-09-05 00:02:44','2024-09-05 00:02:44'),(6,NULL,'erp Personal Access Client','X3WW6tSqR0XVHH6vrsUTln2ScKQicLLTPp97YQVP',NULL,'http://localhost',1,0,0,'2024-09-05 00:02:51','2024-09-05 00:02:51'),(7,NULL,'erp Password Grant Client','mGNvSujC6eUprvzctHEEVDg83CaAI8CSmq4wzmL1','users','http://localhost',0,1,0,'2024-09-05 00:02:51','2024-09-05 00:02:51'),(8,NULL,'erp Personal Access Client','Pdtpy0Tyn6khZpi0rSb4ureKx01xggMUT6o65iKc',NULL,'http://localhost',1,0,0,'2024-11-16 21:47:55','2024-11-16 21:47:55'),(9,NULL,'erp Password Grant Client','Rc38hzmEDLgJNzAdzZltZWTPXoiGobX31fGIfc62','users','http://localhost',0,1,0,'2024-11-16 21:47:55','2024-11-16 21:47:55'),(10,NULL,'erp Personal Access Client','7qcrto9qBnf9n2HeJV9RuXIcGRCFfmEsyh9kgljs',NULL,'http://localhost',1,0,0,'2025-01-27 13:18:52','2025-01-27 13:18:52'),(11,NULL,'erp Password Grant Client','rinA3YfeIWyrhJgfKuFDpQ7hZBUzh3aJAElccSJM','users','http://localhost',0,1,0,'2025-01-27 13:18:52','2025-01-27 13:18:52');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES (1,1,'2024-08-23 19:48:32','2024-08-23 19:48:32'),(2,4,'2024-09-05 00:02:44','2024-09-05 00:02:44'),(3,6,'2024-09-05 00:02:51','2024-09-05 00:02:51'),(4,8,'2024-11-16 21:47:55','2024-11-16 21:47:55'),(5,10,'2025-01-27 13:18:52','2025-01-27 13:18:52');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
INSERT INTO `oauth_refresh_tokens` VALUES ('01e602a9d279f2b9d31a7bb6f96fd628666bd1b9b6f3e1a8ede6e082748d45c1e81a3db967ba60dd','c535e3e5d93fbfe7f9206f2e4dae84ccc46c7fbd3b3d73654295579a89e74b26ad835531c85ad303',0,'2025-08-26 19:10:38'),('08fe8ac4701f605ece4633dedb4de80d286edab3cd572b2466e3aa21742f72b38fcc93043bc47f2d','54f0d7777c4cce032707595b3cb35bb142939e29688c9a1545234bb5979fb0d96b20c19f4d9a5a13',0,'2025-09-24 19:04:59'),('0e0ad1925b8bc3fa00db898e62d1ed01f0b0802b9adcce22c3fc789a2247ab90f8644fa8b314cf06','94f3564fe855db14b0276a40ab52e5b2b0672080cb05259548975404918ee13b1982cee18b315216',0,'2025-11-29 12:14:57'),('1420d4252b35f681f715124136ed61965f82975969a17efbf5f646a9218b8321b0a4667934c773ba','7fe99f98e6e53cbf8875460ebc65d8161dbec23670796f72d49061b28e365586d17c77a2588412aa',0,'2025-08-26 18:10:27'),('17f4a1bc0eee44315e0c62a686bc0e3999729ce6065da1816a4a165effd6066f8adbd4c0bc1b75eb','9868ab4d001299ab746a71b8964e5a006d3edd8bff4497026d633a747bf2a576cc266565af5c0226',0,'2025-11-29 12:40:51'),('21cc1bc64ad3faec26e644771e05353e6d1de4b1c9ed1295fe54d7666766f2497ab8751fa67093de','851487ea9f17f012240c1fce4b5638e2be387b89c0786b9c2a231bbb9497c8d13c917a10380f3236',0,'2025-10-02 18:36:51'),('2b95ecc5361c5d53f568b161818dd4ba4b0e828d0d4083e4db76db7a616a86ec2187cbac520d8486','ab41e2ccd5e7e328e4a0d9dbacb5cf69e3b9f2f645ec8a639d06cbcdc634cc17f65c58612e5eace6',0,'2025-11-15 14:44:53'),('2f8646ee9244cc08c37138b36e6e2d019c5c2a3193c3c49230b4f7632127f8bd25503cbe379591c1','895119f9a48cab2102746ab9216ccc060fd14bed13dcf17000bc962bade723d30dd14d4fae979426',0,'2025-12-07 15:40:13'),('3bbebefb32d9a8e9394d33c32a32f735261ac4f399e34a4b729dda94f7f642c705bbbb832c69006a','c6c3abcc1c02a8b2dc1b84d574f8b13a39c4ad720b2c8925bfb47b6417c2bdb477e7766bed59bdbd',0,'2025-09-24 09:21:38'),('483cdc7eb2d515b2b9f424d2e17567bf054b674f7932d7e89bf9548abb64fbf8a0af1b59f3d790c0','5ebcaade66163355430344437b92e86fa5311fc8066f536d8e4002c911a328a0cbae6f46655e0880',0,'2025-09-24 18:09:06'),('4b4530235ac8918985ff3ffdd25db69b911276f7fc47a8fecfc75c17042057d94b1bd8614da01c96','91c09238ce4caeb06ebc52832b5f71a092661c04fbca722883c900672e61461d177fc1e1ffd95f5e',0,'2026-01-07 18:14:25'),('5aed56ff900950567f025162c6e723e2e0dc09dd1dac481b1e4c09de84ba4cbe3bfd811a077a171c','2c7dcb0278cb10cff9c7808b4456820bb69d5788faefb86e00c0a7a4f570b170713e48bf767df76d',0,'2026-01-11 22:01:46'),('5b80e3f84d15c4207a9d1b6da98b1d9a8a66430a9ff72e90d04ad3ac4b51a147b7dc027600ccd5ea','8c97edabf7d338ff8120f311f90146b2ea99d44f58b45879eb85779572619be8f73d83d5feafadef',0,'2025-09-24 18:04:31'),('5d5dc3137fb155557a1e1381f423986ca2c5336a41960a20f49c4e918907abdd8c6ec50fa8816a85','f41e7719b0ce5c1800b9de3ac941dd0ead82fe4bca2f864d517bfa0215635baa3829da3b4f123bbe',0,'2025-08-27 20:03:46'),('6a8505a8ec7440da8c487c39be6918ccc7add2c61bc66112814b597064073b12ba2762b3b40bd672','507b9807ae576606f8e70daafc697a9ac6fa89077139fb4cfbb5cace361bce817a4dfab305f1545d',0,'2025-09-24 19:16:39'),('6d9fcaf3ec60b6d38075ca2b203605c1bcf61e723306dde3fc1417f6a2529ea3d1494c2f62bd150d','91d7eba09f32f171f96467fc34320414d28f119476b6f0802abdb1a498fce4a6ba652df3e71c041a',0,'2025-08-26 20:01:05'),('7073f4895173c6a9f61c7a991b3e983dc527a2014e8dada1f8b0971bfbea5d986de88cab3047ef70','8af60e4e35c2cf0f98ff51f4a15bf631121cc9219b6c80f02a454bcf2c2c92fa95dfca2e25854afb',0,'2025-11-09 15:56:27'),('8412ffc626d1f38b4d75a6b3db512b023ebde3d9ad70a346645b3e94db5cec2873c22a8b29dafa51','1f951bf9847373f32d92e738776e1b4f9c37bf8696d6e4399cbe026480a7b599a5a6323f0b3d45b9',0,'2025-08-26 18:35:36'),('95fcb0326a328a7ea3190e10477498a291b8a17e69d5228594917ae66c56d0102d95b5a896cfdfd0','736e432d3f48e5bbf01bb6049cdafaa12e5b4c3ee003979cdbf34f81720581e12b639d93b0bf6774',0,'2025-08-26 17:59:42'),('9ad168fc31b6d6c3d34541289a554a9a745f72ea3b608b42c46266b89733f271f3ac1d49f4f9bdf7','d30f6f09c41f411c515e2ad46b4681c7ec3350947487607b704955a7be1424bd5112c93dd4f199ff',0,'2025-09-07 20:25:55'),('aa8640971666878dce09753c47cdbf2e9eea1fc50803b4c71571cba7e9f437be52764fc4914a3c09','094bcd59ec1d503e13966f18f6b9cca66ac2106ec1d6595f60b4777051e94b4710801d4e6be623f7',0,'2025-12-07 14:43:47'),('b6569f6a4a0aaef8feb0201d798e03a45b5295c2d387ca670afa53a2411d5fb58033207579a7e1d5','96bc50051aea35058059d111df4037ef21a3b0e1b132c6447236c2d6dd0d71331bdc82f5df89a4c9',0,'2025-08-26 18:38:15'),('c1242d4906dc7dc822e22884959539629efb22929d080e8a75db40276c082df3a0985880b93cb961','670893602d8ea2a2e4cfdc8a5ee19e58419d23f5b123b8fe0c7ff504f7ae767dec411f1f2b2f4776',0,'2025-08-24 20:11:22'),('c22cbdec1696c250508a5a8366d1de9d543d162dbbaaad8d4e145fbd1109db3d6a0fa5b931eb70e2','ed6b921aa793199bfa77bd8823fa4ffc5e53160d223f04f525710609b14f4f57a2974b54282c5e55',0,'2025-11-09 13:43:40'),('d6ce4abbfc669826734404edeb99a9a893bdaf3149728d1a148316b66d8e41f79dfd57381f7e453d','ab5797290a9754fe1720089493aef1a1cc6b78a0f1fc8c204fda561b60e5b5f23bb81ff4cee633dc',0,'2025-08-30 14:08:05'),('dcf3630a5aa52496300a3beb834ecb39ffc9b46c77462690e9882688ffd81388dd96b019a8408f03','87c0c091373b0d182f0f50ef4dfdb210d21fb6b966b86b5a6e57ff4899a8aa100611b2572e53a877',0,'2025-09-18 14:27:13'),('e6c0ae8fa387ca5b76bd6ba2fe070124143fde5ee38d38f910ede8361ab7658100d4efea883fee65','c49c9cf7f0592d8dc4e2b447eebaa87414ba96d957a1cb381dacba50c0d658e5a8352a49515c24b6',0,'2025-08-26 20:11:24'),('e9f8dff9b25c504b0664342d24f6eaac648476a1e06465c8bc7e380cbb6dfc01018d637d4f5d285e','9696848d1301c38468e484c9d95dbb40fb19388c456c2af994986a47e5a0e5134d7f795d9d74e25c',0,'2025-09-24 00:10:35'),('ec8abf3db5047b2c0a5577186495d1dc6980f51f2968d435a2180f4984339bc07890681897b23219','5261985150c1c92082429c84b734d80aab00281df26234c5645da399dcb19185307f0fd63e89ed2b',0,'2025-08-23 19:56:23'),('fd7e6bb9dd4754454e1af6461b12f15d46ef13cd25275c716f5578319701815589d3024f50431c32','f2bcb66af4eacf072dfb8fd88470a5f7efdcdf562feaa7e0082e727dd9e3f14086c8c1b3dbc76a58',0,'2025-12-12 23:21:12');
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text NOT NULL,
  `location_count` int(11) NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int(11) NOT NULL,
  `product_count` int(11) NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable tables',
  `invoice_count` int(11) NOT NULL,
  `interval` enum('days','months','years') NOT NULL,
  `interval_count` int(11) NOT NULL,
  `trial_days` int(11) NOT NULL,
  `price` decimal(22,4) NOT NULL,
  `custom_permissions` longtext NOT NULL,
  `created_by` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL,
  `mark_package_as_popular` tinyint(1) NOT NULL,
  `businesses` longtext DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `is_one_time` tinyint(1) NOT NULL DEFAULT 0,
  `enable_custom_link` tinyint(1) NOT NULL DEFAULT 0,
  `custom_link` varchar(191) DEFAULT NULL,
  `custom_link_text` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (1,'test','test',0,0,0,0,0,0,0,0,'years',100,360,0.0000,'{\"accounting_module\":\"1\",\"aiassistance_module\":\"1\",\"aiassistance_max_token\":null,\"assetmanagement_module\":\"1\",\"connector_module\":\"1\",\"crm_module\":\"1\",\"essentials_module\":\"1\",\"manufacturing_module\":\"1\",\"productcatalogue_module\":\"1\",\"project_module\":\"1\",\"repair_module\":\"1\",\"woocommerce_module\":\"1\"}',1,1,1,1,NULL,1,0,0,'','',NULL,'2024-08-23 19:56:24','2024-08-23 19:57:59'),(2,'tessst','Adidas',5,0,0,0,0,0,0,0,'years',1,7,50.0000,'{\"accounting_module\":\"1\",\"aiassistance_max_token\":null,\"connector_module\":\"1\",\"crm_module\":\"1\",\"essentials_module\":\"1\",\"manufacturing_module\":\"1\",\"project_module\":\"1\",\"repair_module\":\"1\",\"woocommerce_module\":\"1\"}',1,1,1,1,NULL,0,0,1,NULL,NULL,NULL,'2025-02-22 17:16:38','2025-02-22 17:16:38');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
INSERT INTO `password_resets` VALUES ('m0165557155@gmail.com','$2y$10$lBvgxo16eUBNFSTnAD03FuGTdxD09utsS21s69RFFYndtGt4tgatu','2024-12-12 22:11:36');
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2024-08-23 19:46:33',NULL),(2,'direct_sell.access','web','2024-08-23 19:46:33',NULL),(3,'product.opening_stock','web','2024-08-23 19:46:34','2024-08-23 19:46:34'),(4,'crud_all_bookings','web','2024-08-23 19:46:35','2024-08-23 19:46:35'),(5,'crud_own_bookings','web','2024-08-23 19:46:35','2024-08-23 19:46:35'),(6,'access_default_selling_price','web','2024-08-23 19:46:35','2024-08-23 19:46:35'),(7,'purchase.payments','web','2024-08-23 19:46:36','2024-08-23 19:46:36'),(8,'sell.payments','web','2024-08-23 19:46:36','2024-08-23 19:46:36'),(9,'edit_product_price_from_sale_screen','web','2024-08-23 19:46:36','2024-08-23 19:46:36'),(10,'edit_product_discount_from_sale_screen','web','2024-08-23 19:46:36','2024-08-23 19:46:36'),(11,'roles.view','web','2024-08-23 19:46:36','2024-08-23 19:46:36'),(12,'roles.create','web','2024-08-23 19:46:36','2024-08-23 19:46:36'),(13,'roles.update','web','2024-08-23 19:46:36','2024-08-23 19:46:36'),(14,'roles.delete','web','2024-08-23 19:46:36','2024-08-23 19:46:36'),(15,'account.access','web','2024-08-23 19:46:36','2024-08-23 19:46:36'),(16,'discount.access','web','2024-08-23 19:46:36','2024-08-23 19:46:36'),(17,'view_purchase_price','web','2024-08-23 19:46:37','2024-08-23 19:46:37'),(18,'view_own_sell_only','web','2024-08-23 19:46:37','2024-08-23 19:46:37'),(19,'edit_product_discount_from_pos_screen','web','2024-08-23 19:46:37','2024-08-23 19:46:37'),(20,'edit_product_price_from_pos_screen','web','2024-08-23 19:46:37','2024-08-23 19:46:37'),(21,'access_shipping','web','2024-08-23 19:46:37','2024-08-23 19:46:37'),(22,'purchase.update_status','web','2024-08-23 19:46:38','2024-08-23 19:46:38'),(23,'list_drafts','web','2024-08-23 19:46:38','2024-08-23 19:46:38'),(24,'list_quotations','web','2024-08-23 19:46:38','2024-08-23 19:46:38'),(25,'view_cash_register','web','2024-08-23 19:46:39','2024-08-23 19:46:39'),(26,'close_cash_register','web','2024-08-23 19:46:39','2024-08-23 19:46:39'),(27,'print_invoice','web','2024-08-23 19:46:40','2024-08-23 19:46:40'),(28,'user.view','web','2024-08-23 19:46:42',NULL),(29,'user.create','web','2024-08-23 19:46:42',NULL),(30,'user.update','web','2024-08-23 19:46:42',NULL),(31,'user.delete','web','2024-08-23 19:46:42',NULL),(32,'supplier.view','web','2024-08-23 19:46:42',NULL),(33,'supplier.create','web','2024-08-23 19:46:42',NULL),(34,'supplier.update','web','2024-08-23 19:46:42',NULL),(35,'supplier.delete','web','2024-08-23 19:46:42',NULL),(36,'customer.view','web','2024-08-23 19:46:42',NULL),(37,'customer.create','web','2024-08-23 19:46:42',NULL),(38,'customer.update','web','2024-08-23 19:46:42',NULL),(39,'customer.delete','web','2024-08-23 19:46:42',NULL),(40,'product.view','web','2024-08-23 19:46:42',NULL),(41,'product.create','web','2024-08-23 19:46:42',NULL),(42,'product.update','web','2024-08-23 19:46:42',NULL),(43,'product.delete','web','2024-08-23 19:46:42',NULL),(44,'purchase.view','web','2024-08-23 19:46:42',NULL),(45,'purchase.create','web','2024-08-23 19:46:42',NULL),(46,'purchase.update','web','2024-08-23 19:46:42',NULL),(47,'purchase.delete','web','2024-08-23 19:46:42',NULL),(48,'sell.view','web','2024-08-23 19:46:42',NULL),(49,'sell.create','web','2024-08-23 19:46:42',NULL),(50,'sell.update','web','2024-08-23 19:46:42',NULL),(51,'sell.delete','web','2024-08-23 19:46:42',NULL),(52,'purchase_n_sell_report.view','web','2024-08-23 19:46:42',NULL),(53,'contacts_report.view','web','2024-08-23 19:46:42',NULL),(54,'stock_report.view','web','2024-08-23 19:46:42',NULL),(55,'tax_report.view','web','2024-08-23 19:46:42',NULL),(56,'trending_product_report.view','web','2024-08-23 19:46:42',NULL),(57,'register_report.view','web','2024-08-23 19:46:42',NULL),(58,'sales_representative.view','web','2024-08-23 19:46:42',NULL),(59,'expense_report.view','web','2024-08-23 19:46:42',NULL),(60,'business_settings.access','web','2024-08-23 19:46:42',NULL),(61,'barcode_settings.access','web','2024-08-23 19:46:42',NULL),(62,'invoice_settings.access','web','2024-08-23 19:46:42',NULL),(63,'brand.view','web','2024-08-23 19:46:42',NULL),(64,'brand.create','web','2024-08-23 19:46:42',NULL),(65,'brand.update','web','2024-08-23 19:46:42',NULL),(66,'brand.delete','web','2024-08-23 19:46:42',NULL),(67,'tax_rate.view','web','2024-08-23 19:46:42',NULL),(68,'tax_rate.create','web','2024-08-23 19:46:42',NULL),(69,'tax_rate.update','web','2024-08-23 19:46:42',NULL),(70,'tax_rate.delete','web','2024-08-23 19:46:42',NULL),(71,'unit.view','web','2024-08-23 19:46:42',NULL),(72,'unit.create','web','2024-08-23 19:46:42',NULL),(73,'unit.update','web','2024-08-23 19:46:42',NULL),(74,'unit.delete','web','2024-08-23 19:46:42',NULL),(75,'category.view','web','2024-08-23 19:46:42',NULL),(76,'category.create','web','2024-08-23 19:46:42',NULL),(77,'category.update','web','2024-08-23 19:46:42',NULL),(78,'category.delete','web','2024-08-23 19:46:42',NULL),(79,'expense.access','web','2024-08-23 19:46:42',NULL),(80,'access_all_locations','web','2024-08-23 19:46:42',NULL),(81,'dashboard.data','web','2024-08-23 19:46:42',NULL),(82,'location.1','web','2024-08-23 19:47:28','2024-08-23 19:47:28'),(83,'repair.create','web','2024-08-23 19:50:11','2024-08-23 19:50:11'),(84,'repair.update','web','2024-08-23 19:50:11','2024-08-23 19:50:11'),(85,'repair.view','web','2024-08-23 19:50:11','2024-08-23 19:50:11'),(86,'repair.delete','web','2024-08-23 19:50:11','2024-08-23 19:50:11'),(87,'repair_status.update','web','2024-08-23 19:50:11','2024-08-23 19:50:11'),(88,'repair_status.access','web','2024-08-23 19:50:11','2024-08-23 19:50:11'),(89,'project.create_project','web','2024-08-23 19:51:00','2024-08-23 19:51:00'),(90,'project.edit_project','web','2024-08-23 19:51:00','2024-08-23 19:51:00'),(91,'project.delete_project','web','2024-08-23 19:51:00','2024-08-23 19:51:00'),(92,'manufacturing.access_recipe','web','2024-08-23 19:51:25','2024-08-23 19:51:25'),(93,'manufacturing.access_production','web','2024-08-23 19:51:25','2024-08-23 19:51:25'),(94,'manufacturing.add_recipe','web','2024-08-23 19:51:25','2024-08-23 19:51:25'),(95,'manufacturing.edit_recipe','web','2024-08-23 19:51:25','2024-08-23 19:51:25'),(96,'essentials.create_message','web','2024-08-23 19:53:17','2024-08-23 19:53:17'),(97,'essentials.view_message','web','2024-08-23 19:53:17','2024-08-23 19:53:17'),(98,'essentials.approve_leave','web','2024-08-23 19:53:17','2024-08-23 19:53:17'),(99,'essentials.assign_todos','web','2024-08-23 19:53:17','2024-08-23 19:53:17'),(100,'essentials.add_allowance_and_deduction','web','2024-08-23 19:53:17','2024-08-23 19:53:17'),(101,'woocommerce.syc_categories','web','2024-08-23 19:55:02','2024-08-23 19:55:02'),(102,'woocommerce.sync_products','web','2024-08-23 19:55:02','2024-08-23 19:55:02'),(103,'woocommerce.sync_orders','web','2024-08-23 19:55:02','2024-08-23 19:55:02'),(104,'woocommerce.map_tax_rates','web','2024-08-23 19:55:02','2024-08-23 19:55:02'),(105,'woocommerce.access_woocommerce_api_settings','web','2024-08-23 19:55:02','2024-08-23 19:55:02'),(106,'location.2','web','2024-08-24 17:22:22','2024-08-24 17:22:22'),(107,'location.3','web','2024-09-02 17:19:13','2024-09-02 17:19:13'),(108,'location.4','web','2024-09-03 22:51:53','2024-09-03 22:51:53'),(109,'location.5','web','2024-09-14 13:01:21','2024-09-14 13:01:21'),(110,'location.6','web','2024-09-14 15:57:41','2024-09-14 15:57:41'),(111,'location.7','web','2024-09-25 20:56:18','2024-09-25 20:56:18'),(112,'location.8','web','2024-09-25 20:58:01','2024-09-25 20:58:01'),(113,'location.9','web','2024-11-15 14:38:29','2024-11-15 14:38:29'),(114,'location.10','web','2024-12-02 16:39:47','2024-12-02 16:39:47'),(115,'location.11','web','2024-12-12 22:13:26','2024-12-12 22:13:26'),(116,'location.12','web','2024-12-12 22:15:12','2024-12-12 22:15:12'),(117,'location.13','web','2025-02-15 11:39:44','2025-02-15 11:39:44'),(118,'location.14','web','2025-02-15 11:41:01','2025-02-15 11:41:01'),(119,'location.15','web','2025-02-22 17:18:55','2025-02-22 17:18:55'),(120,'location.16','web','2025-02-22 17:20:38','2025-02-22 17:20:38');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_invoice_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pjt_invoice_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `task` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `rate` decimal(22,4) NOT NULL,
  `tax_rate_id` int(11) DEFAULT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `total` decimal(22,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_invoice_lines_transaction_id_foreign` (`transaction_id`),
  KEY `pjt_invoice_lines_tax_rate_id_index` (`tax_rate_id`),
  CONSTRAINT `pjt_invoice_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_invoice_lines` WRITE;
/*!40000 ALTER TABLE `pjt_invoice_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `pjt_invoice_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_project_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pjt_project_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int(10) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_project_members_project_id_foreign` (`project_id`),
  KEY `pjt_project_members_user_id_index` (`user_id`),
  CONSTRAINT `pjt_project_members_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `pjt_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_project_members` WRITE;
/*!40000 ALTER TABLE `pjt_project_members` DISABLE KEYS */;
INSERT INTO `pjt_project_members` VALUES (1,1,4),(2,1,1);
/*!40000 ALTER TABLE `pjt_project_members` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_project_task_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pjt_project_task_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_task_id` int(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `commented_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_project_task_comments_project_task_id_foreign` (`project_task_id`),
  CONSTRAINT `pjt_project_task_comments_project_task_id_foreign` FOREIGN KEY (`project_task_id`) REFERENCES `pjt_project_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_project_task_comments` WRITE;
/*!40000 ALTER TABLE `pjt_project_task_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `pjt_project_task_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_project_task_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pjt_project_task_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_task_id` int(10) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_project_task_members_project_task_id_foreign` (`project_task_id`),
  KEY `pjt_project_task_members_user_id_index` (`user_id`),
  CONSTRAINT `pjt_project_task_members_project_task_id_foreign` FOREIGN KEY (`project_task_id`) REFERENCES `pjt_project_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_project_task_members` WRITE;
/*!40000 ALTER TABLE `pjt_project_task_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `pjt_project_task_members` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_project_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pjt_project_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `project_id` int(10) unsigned NOT NULL,
  `task_id` varchar(191) NOT NULL,
  `subject` varchar(191) NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `due_date` datetime DEFAULT NULL,
  `priority` enum('low','medium','high','urgent') NOT NULL DEFAULT 'low',
  `description` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `status` enum('completed','not_started','in_progress','on_hold','cancelled') NOT NULL DEFAULT 'not_started',
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_project_tasks_project_id_foreign` (`project_id`),
  KEY `pjt_project_tasks_business_id_index` (`business_id`),
  KEY `pjt_project_tasks_created_by_index` (`created_by`),
  CONSTRAINT `pjt_project_tasks_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `pjt_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_project_tasks` WRITE;
/*!40000 ALTER TABLE `pjt_project_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `pjt_project_tasks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_project_time_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pjt_project_time_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int(10) unsigned NOT NULL,
  `project_task_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `start_datetime` datetime NOT NULL,
  `end_datetime` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_project_time_logs_project_id_foreign` (`project_id`),
  KEY `pjt_project_time_logs_project_task_id_foreign` (`project_task_id`),
  KEY `pjt_project_time_logs_user_id_index` (`user_id`),
  KEY `pjt_project_time_logs_created_by_index` (`created_by`),
  CONSTRAINT `pjt_project_time_logs_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `pjt_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pjt_project_time_logs_project_task_id_foreign` FOREIGN KEY (`project_task_id`) REFERENCES `pjt_project_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_project_time_logs` WRITE;
/*!40000 ALTER TABLE `pjt_project_time_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pjt_project_time_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pjt_projects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `status` enum('not_started','in_progress','on_hold','cancelled','completed') NOT NULL,
  `lead_id` int(11) NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `settings` text DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_projects_business_id_index` (`business_id`),
  KEY `pjt_projects_contact_id_index` (`contact_id`),
  KEY `pjt_projects_lead_id_index` (`lead_id`),
  KEY `pjt_projects_created_by_index` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_projects` WRITE;
/*!40000 ALTER TABLE `pjt_projects` DISABLE KEYS */;
INSERT INTO `pjt_projects` VALUES (1,1,'sddsd',2,'not_started',1,'2024-09-18 00:00:00','2024-09-17 00:00:00','<p>sdsdsds</p>',1,'{\"enable_timelog\":1,\"enable_invoice\":1,\"enable_notes_documents\":1,\"members_crud_task\":0,\"members_crud_note\":0,\"members_crud_timelog\":0,\"task_view\":\"list_view\",\"task_id_prefix\":\"#\"}',NULL,NULL,NULL,NULL,'2024-09-05 15:14:52','2024-12-20 11:36:11');
/*!40000 ALTER TABLE `pjt_projects` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `connection_type` enum('network','windows','linux') NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `port` varchar(191) DEFAULT NULL,
  `path` varchar(191) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,1),(2,1),(4,1),(5,1),(6,1),(6,2),(7,1),(9,1),(10,1),(12,1),(14,1),(15,1),(16,1),(19,7),(17,7),(17,8),(20,7),(20,8),(21,7),(21,8),(22,7),(22,8);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) DEFAULT NULL,
  `row` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2024-08-24 17:07:22','2024-08-24 17:07:22'),(2,NULL,'DUMMY',2,1,'2024-08-24 17:08:04','2024-08-24 17:08:04'),(3,NULL,'DUMMY',3,1,'2024-08-24 18:58:17','2024-08-24 18:58:17'),(4,NULL,'DUMMY',4,1,'2024-08-24 19:23:58','2024-08-24 19:23:58'),(5,NULL,'DUMMY',5,1,'2024-08-24 19:26:33','2024-08-24 19:26:33'),(6,NULL,'DUMMY',6,1,'2024-08-24 20:01:48','2024-08-24 20:01:48'),(7,NULL,'DUMMY',7,1,'2024-08-24 20:03:54','2024-08-24 20:03:54'),(9,NULL,'DUMMY',9,1,'2024-08-24 20:05:45','2024-08-24 20:05:45'),(10,NULL,'DUMMY',10,1,'2024-08-24 20:09:10','2024-08-24 20:09:10'),(11,NULL,'DUMMY',11,1,'2024-08-24 20:10:28','2024-08-24 20:10:28'),(12,NULL,'DUMMY',12,1,'2024-08-24 20:10:54','2024-08-24 20:10:54'),(13,NULL,'DUMMY',13,1,'2024-08-29 16:46:12','2024-08-29 16:46:12'),(14,NULL,'DUMMY',14,1,'2024-08-29 16:46:47','2024-08-29 16:46:47'),(15,NULL,'DUMMY',15,1,'2024-08-29 16:49:19','2024-08-29 16:49:19'),(16,NULL,'DUMMY',16,1,'2024-08-29 16:54:23','2024-08-29 16:54:23'),(17,NULL,'DUMMY',17,1,'2024-08-29 16:57:55','2024-08-29 16:57:55'),(18,NULL,'DUMMY',18,1,'2024-09-24 09:20:16','2024-09-24 09:20:16'),(19,NULL,'DUMMY',19,1,'2024-09-26 17:45:58','2024-09-26 17:45:58'),(20,NULL,'DUMMY',20,1,'2024-12-10 23:20:06','2024-12-10 23:20:06'),(21,NULL,'DUMMY',21,1,'2024-12-10 23:58:31','2024-12-10 23:58:31'),(22,NULL,'DUMMY',22,1,'2024-12-12 00:57:26','2024-12-12 00:57:26'),(23,NULL,'DUMMY',23,1,'2025-01-27 12:52:55','2025-01-27 12:52:55'),(24,NULL,'DUMMY',24,1,'2025-01-27 13:01:15','2025-01-27 13:01:15'),(25,NULL,'DUMMY',25,1,'2025-01-27 13:14:36','2025-01-27 13:14:36'),(26,NULL,'DUMMY',26,1,'2025-01-27 13:25:34','2025-01-27 13:25:34'),(27,NULL,'DUMMY',27,1,'2025-01-27 13:38:02','2025-01-27 13:38:02');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) DEFAULT NULL,
  `product_custom_field1` varchar(191) DEFAULT NULL,
  `product_custom_field2` varchar(191) DEFAULT NULL,
  `product_custom_field3` varchar(191) DEFAULT NULL,
  `product_custom_field4` varchar(191) DEFAULT NULL,
  `product_custom_field5` varchar(191) DEFAULT NULL,
  `product_custom_field6` varchar(191) DEFAULT NULL,
  `product_custom_field7` varchar(191) DEFAULT NULL,
  `product_custom_field8` varchar(191) DEFAULT NULL,
  `product_custom_field9` varchar(191) DEFAULT NULL,
  `product_custom_field10` varchar(191) DEFAULT NULL,
  `product_custom_field11` varchar(191) DEFAULT NULL,
  `product_custom_field12` varchar(191) DEFAULT NULL,
  `product_custom_field13` varchar(191) DEFAULT NULL,
  `product_custom_field14` varchar(191) DEFAULT NULL,
  `product_custom_field15` varchar(191) DEFAULT NULL,
  `product_custom_field16` varchar(191) DEFAULT NULL,
  `product_custom_field17` varchar(191) DEFAULT NULL,
  `product_custom_field18` varchar(191) DEFAULT NULL,
  `product_custom_field19` varchar(191) DEFAULT NULL,
  `product_custom_field20` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `woocommerce_media_id` int(11) DEFAULT NULL,
  `product_description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_product_id` int(11) DEFAULT NULL,
  `woocommerce_disable_sync` tinyint(1) NOT NULL DEFAULT 0,
  `preparation_time_in_minutes` int(11) DEFAULT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT 0,
  `repair_model_id` int(10) unsigned DEFAULT NULL,
  `not_for_selling` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  KEY `products_repair_model_id_index` (`repair_model_id`),
  KEY `products_woocommerce_product_id_index` (`woocommerce_product_id`),
  KEY `products_woocommerce_media_id_index` (`woocommerce_media_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_repair_model_id_foreign` FOREIGN KEY (`repair_model_id`) REFERENCES `repair_device_models` (`id`),
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'Atl 1L',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0001','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 17:07:22','2025-02-07 16:31:34'),(2,'Atl 700 ML',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0002','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 17:08:04','2025-02-07 16:31:34'),(3,'Kix Oil',1,'single',1,NULL,NULL,1,NULL,NULL,NULL,'exclusive',1,NULL,'0003','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 18:58:17','2025-02-07 16:31:34'),(4,'Acer Aspire E 15 - Color-Black',1,'single',1,NULL,NULL,2,NULL,NULL,NULL,'inclusive',1,NULL,'0004','C128',NULL,NULL,0,'1500g',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1724507638_1528727793_acerE15.jpg',NULL,'<p>Acer Aspire E 15 - Color-Black</p>',1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 19:23:58','2025-02-07 16:31:34'),(5,'Apple - Fuji',1,'single',3,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'Apple - Fuji','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','1724507852_1528780234_apples.jpg',NULL,'<p>Apple - Fuji</p>',1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 19:26:33','2025-02-07 16:31:34'),(6,'Apple iPhone 8',1,'single',1,NULL,NULL,4,9,NULL,NULL,'exclusive',1,10.0000,'0006','C128',NULL,NULL,1,'150g',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1724509908_1528727817_iphone8.jpg',NULL,'<p>Apple iPhone 8</p>',1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 20:01:48','2025-02-07 16:31:34'),(7,'Apple MacBook Air',1,'single',1,NULL,NULL,4,8,NULL,NULL,'exclusive',1,NULL,'0007','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1724510034_1528727849_macbookair.jpg',NULL,'<div class=\"modal-header\">\r\n<h4 id=\"modalTitle\" class=\"modal-title\">Apple MacBook Air</h4>\r\n</div>\r\n<div class=\"modal-body\">\r\n<div class=\"row\">\r\n<div class=\"col-sm-9\">&nbsp;</div>\r\n</div>\r\n</div>',1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 20:03:54','2025-02-07 16:31:34'),(9,'Bananna',1,'single',1,NULL,NULL,NULL,10,NULL,NULL,'exclusive',1,10.0000,'0009','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','1724510254_1528780092_banana.jpg',NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 20:05:45','2025-02-07 16:31:34'),(10,'Barilla Pasta',1,'single',1,NULL,NULL,NULL,10,NULL,NULL,'exclusive',1,10.0000,'0010','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 20:09:10','2025-02-07 16:31:34'),(11,'Butter Cookies',1,'single',1,NULL,NULL,NULL,10,NULL,NULL,'exclusive',1,NULL,'0011','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<div class=\"modal-header\">\r\n<h4 id=\"modalTitle\" class=\"modal-title\">Butter Cookies</h4>\r\n</div>\r\n<div class=\"modal-body\">\r\n<div class=\"row\">\r\n<div class=\"col-sm-9\">&nbsp;</div>\r\n</div>\r\n</div>',1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 20:10:28','2025-02-07 16:31:34'),(12,'Butter Cookies',1,'single',1,NULL,NULL,8,10,NULL,NULL,'exclusive',1,NULL,'0012','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<div class=\"modal-header\">\r\n<h4 id=\"modalTitle\" class=\"modal-title\">Butter Cookies</h4>\r\n</div>\r\n<div class=\"modal-body\">\r\n<div class=\"row\">\r\n<div class=\"col-sm-9\">&nbsp;</div>\r\n</div>\r\n</div>',1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-24 20:10:54','2025-02-07 16:31:34'),(13,'Barilla Pasta',1,'single',1,NULL,NULL,12,10,NULL,NULL,'exclusive',1,50.0000,'0013','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1724930172_1528727865_barilla_pasta.jpeg',NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-29 16:46:12','2025-02-07 16:31:34'),(14,'Barilla Pasta',1,'single',1,NULL,NULL,NULL,10,NULL,NULL,'exclusive',1,50.0000,'0014','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1724930207_1528727865_barilla_pasta.jpeg',NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-29 16:46:47','2025-02-07 16:31:34'),(15,'Levis Men\'s Slimmy Fit Jeans',1,'single',1,NULL,NULL,5,11,NULL,NULL,'exclusive',1,NULL,'0015','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','1724930399_1528727964_levis_jeans.jpg',NULL,'<p>Levis Men\'s Slimmy Fit Jeans</p>',1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-29 16:49:19','2025-02-07 16:31:34'),(16,'Lipton Black Tea Bags',1,'single',4,NULL,NULL,6,10,NULL,NULL,'exclusive',1,50.0000,'0016','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1724930663_1528727999_lipton_tea.jpg',NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2024-08-29 16:54:23','2025-02-07 16:31:34'),(17,'Oreo Cookies',1,'single',4,NULL,NULL,8,10,NULL,NULL,'exclusive',1,500.0000,'AS0026','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','1724930875_1528728111_oreo.jpg',NULL,NULL,1,2261,0,NULL,NULL,0,NULL,0,'2024-08-29 16:57:55','2025-02-07 16:44:23'),(18,'700 ml',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'inclusive',0,0.0000,'0018','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,1,NULL,NULL,0,NULL,0,'2024-09-24 09:20:16','2025-02-07 16:31:34'),(19,'Test Product',1,'single',3,NULL,NULL,NULL,10,NULL,NULL,'inclusive',1,10.0000,'0019','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,2260,0,NULL,NULL,0,NULL,0,'2024-09-26 17:45:58','2025-02-07 16:44:23'),(20,'1956515 Dunlop R1 indonesia',1,'single',1,NULL,NULL,14,8,NULL,NULL,'exclusive',1,NULL,'0020','C128',NULL,NULL,1,NULL,'195','65','15','R1','Dunlop','','','','','','','','','','','','','','','',NULL,NULL,NULL,1,2262,0,NULL,NULL,0,NULL,0,'2024-12-10 23:20:06','2025-02-07 16:44:23'),(21,'2155516 yoko',1,'single',1,NULL,NULL,14,9,NULL,NULL,'exclusive',1,4.0000,'0021','C128',NULL,NULL,0,NULL,'215','55','16','Es32','Japan','2024-12-10','240',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,2263,0,NULL,NULL,0,NULL,0,'2024-12-10 23:58:31','2025-02-07 16:44:23'),(22,'205',1,'single',1,NULL,NULL,3,2,3,NULL,'exclusive',1,NULL,'0022','C128',40.00,'months',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,2264,0,NULL,NULL,0,NULL,0,'2024-12-12 00:57:26','2025-02-07 16:44:23'),(23,'Toyota Auris',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'SKU00001','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2025-01-27 12:52:55','2025-02-07 16:31:34'),(24,'Car Rental',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0024','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2025-01-27 13:01:15','2025-02-07 16:31:34'),(25,'Car Rental',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,0.0000,'000186','EAN8',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,1,NULL,NULL,0,NULL,0,'2025-01-27 13:14:36','2025-02-07 16:31:34'),(26,'Car Rental',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'00158','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,'Audi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2025-01-27 13:25:34','2025-02-07 16:31:34'),(27,'Toyota Auris',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',0,0.0000,'00021','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','1737965358_Toyota_Auris_1.6_Sol_rear_20100919.jpg',NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2025-01-27 13:38:02','2025-02-07 16:31:34');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `purchase_requisition_line_id` int(11) DEFAULT NULL,
  `purchase_order_line_id` int(11) DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `po_quantity_purchased` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `purchase_lines_lot_number_index` (`lot_number`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,1,2,2,100.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,NULL,19.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 17:08:12','2024-09-24 18:11:00'),(2,2,1,1,100.0000,0.0000,100.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,NULL,27.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 17:08:30','2024-12-06 03:04:40'),(3,4,1,1,10.0000,0.0000,0.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(4,4,2,2,10.0000,0.0000,0.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(5,5,4,4,250.0000,0.0000,10.0000,0.00,10.0000,10.0000,0.0000,NULL,NULL,NULL,23.0000,10.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 19:24:17','2024-12-07 15:50:30'),(6,6,5,5,150.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,15.0000,100.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 19:27:41','2024-12-07 15:28:24'),(7,7,6,6,150.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 20:02:12','2024-12-07 14:45:50'),(8,8,6,6,150.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 20:02:12','2024-08-24 20:02:12'),(9,9,7,7,250.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 20:04:00','2024-11-17 06:16:51'),(10,10,9,9,150.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,143.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 20:05:51','2025-01-07 14:15:24'),(11,11,10,10,150.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 20:09:20','2024-12-06 03:04:40'),(12,12,12,12,2500.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,279.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-24 20:11:02','2025-01-07 14:15:24'),(13,20,14,14,200.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-29 16:47:06','2024-09-14 12:57:26'),(14,21,15,15,450.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-29 16:49:29','2024-12-06 03:04:40'),(16,23,16,16,50.0000,0.0000,100.0000,0.00,100.0000,100.0000,0.0000,NULL,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-29 16:55:11','2024-12-06 03:04:40'),(17,24,17,17,500.0000,0.0000,20.0000,0.00,20.0000,20.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-08-29 16:58:25','2024-09-14 12:57:26'),(18,43,19,19,50000.0000,0.0000,150.0000,0.00,150.0000,150.0000,0.0000,NULL,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-09-26 17:47:09','2025-02-10 19:54:58'),(19,50,17,17,99.0000,0.0000,20.0000,0.00,20.0000,20.0000,0.0000,NULL,NULL,NULL,98.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-11-15 15:03:02','2025-02-24 11:49:31'),(20,51,17,17,99.0000,0.0000,20.0000,0.00,20.0000,20.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2024-11-15 15:03:02','2025-01-07 14:16:27'),(21,66,20,20,111.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,'40-24',NULL,'2024-12-10 23:23:01','2024-12-10 23:44:01'),(22,68,20,20,11.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,'40-24',NULL,'2024-12-10 23:44:01','2024-12-10 23:44:01'),(23,69,20,20,40.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,'2024-12-11','2024-12-11','01-24',NULL,'2024-12-12 00:12:48','2024-12-12 00:12:48'),(24,69,20,20,20.0000,0.0000,0.0000,0.00,0.0000,0.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,'2024-12-11','2024-12-11','01-24',NULL,'2024-12-12 00:12:48','2024-12-12 00:12:48'),(25,74,25,25,1.0000,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-27 13:14:36','2025-01-27 13:14:36'),(26,75,25,25,1.0000,0.0000,300.0000,0.00,300.0000,300.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-01-27 13:14:36','2025-01-27 13:14:36');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reference_counts_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',14,1,'2024-08-23 19:47:28','2025-01-27 13:24:15'),(2,'business_location',4,1,'2024-08-23 19:47:28','2024-09-25 20:58:01'),(3,'stock_transfer',2,1,'2024-08-24 17:23:30','2024-12-10 23:44:01'),(4,'stock_adjustment',4,1,'2024-08-24 19:01:14','2024-09-03 11:52:30'),(5,'sell_payment',83,1,'2024-08-26 18:15:52','2025-02-24 11:49:31'),(6,'contacts',1,2,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(7,'business_location',1,2,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(8,'contacts',1,3,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(9,'business_location',1,3,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(10,'contacts',1,4,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(11,'business_location',1,4,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(12,'contacts',1,5,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(13,'business_location',1,5,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(14,'sell_return',1,1,'2024-10-25 19:52:47','2024-10-25 19:52:47'),(15,'contacts',1,6,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(16,'business_location',1,6,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(17,'draft',4,1,'2024-11-17 06:20:54','2025-01-27 13:25:51'),(18,'contacts',1,7,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(19,'business_location',1,7,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(20,'expense',1,1,'2024-12-06 03:06:06','2024-12-06 03:06:06'),(21,'purchase',2,1,'2024-12-10 23:23:01','2024-12-12 00:12:48'),(22,'contacts',1,8,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(23,'business_location',1,8,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(24,'contacts',1,9,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(25,'business_location',1,9,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(26,'accounting_transfer',1,1,'2024-12-20 00:25:16','2024-12-20 00:25:16'),(27,'contacts',1,10,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(28,'business_location',1,10,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(29,'contacts',1,11,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(30,'business_location',1,11,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(31,'contacts',1,12,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(32,'business_location',2,12,'2025-02-22 17:18:54','2025-02-22 17:20:38');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `repair_device_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `repair_device_models` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `repair_checklist` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `device_id` int(10) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `repair_device_models_business_id_index` (`business_id`),
  KEY `repair_device_models_brand_id_index` (`brand_id`),
  KEY `repair_device_models_device_id_index` (`device_id`),
  KEY `repair_device_models_created_by_index` (`created_by`),
  CONSTRAINT `repair_device_models_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`),
  CONSTRAINT `repair_device_models_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `repair_device_models_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `repair_device_models_device_id_foreign` FOREIGN KEY (`device_id`) REFERENCES `categories` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `repair_device_models` WRITE;
/*!40000 ALTER TABLE `repair_device_models` DISABLE KEYS */;
/*!40000 ALTER TABLE `repair_device_models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `repair_job_sheets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `repair_job_sheets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `job_sheet_no` varchar(191) NOT NULL,
  `service_type` enum('carry_in','pick_up','on_site') NOT NULL,
  `pick_up_on_site_addr` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `device_id` int(10) unsigned DEFAULT NULL,
  `device_model_id` int(10) unsigned DEFAULT NULL,
  `checklist` text DEFAULT NULL,
  `security_pwd` varchar(191) DEFAULT NULL,
  `security_pattern` varchar(191) DEFAULT NULL,
  `serial_no` varchar(191) NOT NULL,
  `status_id` int(11) NOT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `product_configuration` text DEFAULT NULL,
  `defects` text DEFAULT NULL,
  `product_condition` text DEFAULT NULL,
  `service_staff` int(10) unsigned DEFAULT NULL,
  `comment_by_ss` text DEFAULT NULL COMMENT 'comment made by technician',
  `estimated_cost` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `parts` text DEFAULT NULL,
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `custom_field_5` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `repair_job_sheets_business_id_index` (`business_id`),
  KEY `repair_job_sheets_location_id_index` (`location_id`),
  KEY `repair_job_sheets_contact_id_index` (`contact_id`),
  KEY `repair_job_sheets_brand_id_index` (`brand_id`),
  KEY `repair_job_sheets_device_id_index` (`device_id`),
  KEY `repair_job_sheets_device_model_id_index` (`device_model_id`),
  KEY `repair_job_sheets_status_id_index` (`status_id`),
  KEY `repair_job_sheets_service_staff_index` (`service_staff`),
  KEY `repair_job_sheets_created_by_index` (`created_by`),
  CONSTRAINT `repair_job_sheets_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`),
  CONSTRAINT `repair_job_sheets_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `repair_job_sheets_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `repair_job_sheets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `repair_job_sheets_device_id_foreign` FOREIGN KEY (`device_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `repair_job_sheets_device_model_id_foreign` FOREIGN KEY (`device_model_id`) REFERENCES `repair_device_models` (`id`),
  CONSTRAINT `repair_job_sheets_service_staff_foreign` FOREIGN KEY (`service_staff`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `repair_job_sheets` WRITE;
/*!40000 ALTER TABLE `repair_job_sheets` DISABLE KEYS */;
/*!40000 ALTER TABLE `repair_job_sheets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `repair_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `repair_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `color` varchar(191) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `is_completed_status` tinyint(1) NOT NULL DEFAULT 0,
  `sms_template` text DEFAULT NULL,
  `email_subject` text DEFAULT NULL,
  `email_body` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `repair_statuses` WRITE;
/*!40000 ALTER TABLE `repair_statuses` DISABLE KEYS */;
/*!40000 ALTER TABLE `repair_statuses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (6,3),(25,2),(25,5),(25,7),(25,9),(25,11),(25,13),(25,15),(25,17),(25,19),(25,21),(25,23),(25,25),(26,2),(26,5),(26,7),(26,9),(26,11),(26,13),(26,15),(26,17),(26,19),(26,21),(26,23),(26,25),(48,2),(48,5),(48,7),(48,9),(48,11),(48,13),(48,15),(48,17),(48,19),(48,21),(48,23),(48,25),(49,2),(49,5),(49,7),(49,9),(49,11),(49,13),(49,15),(49,17),(49,19),(49,21),(49,23),(49,25),(50,2),(50,5),(50,7),(50,9),(50,11),(50,13),(50,15),(50,17),(50,19),(50,21),(50,23),(50,25),(51,2),(51,5),(51,7),(51,9),(51,11),(51,13),(51,15),(51,17),(51,19),(51,21),(51,23),(51,25),(80,5),(80,7),(80,9),(80,11),(80,13),(80,15),(80,17),(80,19),(80,21),(80,23),(80,25),(81,3);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_service_staff` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(2,'Cashier#1','web',1,0,0,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(3,'Salesperson#1','web',1,0,0,'2024-08-24 17:31:44','2024-08-24 17:31:44'),(4,'Admin#2','web',2,1,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(5,'Cashier#2','web',2,0,0,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(6,'Admin#3','web',3,1,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(7,'Cashier#3','web',3,0,0,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(8,'Admin#4','web',4,1,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(9,'Cashier#4','web',4,0,0,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(10,'Admin#5','web',5,1,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(11,'Cashier#5','web',5,0,0,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(12,'Admin#6','web',6,1,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(13,'Cashier#6','web',6,0,0,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(14,'Admin#7','web',7,1,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(15,'Cashier#7','web',7,0,0,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(16,'Admin#8','web',8,1,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(17,'Cashier#8','web',8,0,0,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(18,'Admin#9','web',9,1,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(19,'Cashier#9','web',9,0,0,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(20,'Admin#10','web',10,1,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(21,'Cashier#10','web',10,0,0,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(22,'Admin#11','web',11,1,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(23,'Cashier#11','web',11,0,0,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(24,'Admin#12','web',12,1,0,'2025-02-22 17:18:54','2025-02-22 17:18:54'),(25,'Cashier#12','web',12,0,0,'2025-02-22 17:18:54','2025-02-22 17:18:54');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sell_line_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sell_line_warranties` (
  `sell_line_id` int(11) NOT NULL,
  `warranty_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sell_line_warranties` WRITE;
/*!40000 ALTER TABLE `sell_line_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `sell_line_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  KEY `stock_adjustment_lines_lot_no_line_id_index` (`lot_no_line_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
INSERT INTO `stock_adjustment_lines` VALUES (1,26,4,4,10.0000,0.0000,2000.0000,NULL,NULL,'2024-09-03 11:50:48','2024-09-03 11:50:48'),(2,27,5,5,100.0000,0.0000,150.0000,NULL,NULL,'2024-09-03 11:52:30','2024-09-03 11:52:30');
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `package_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `trial_end_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `package_price` decimal(22,4) NOT NULL,
  `original_price` decimal(22,4) DEFAULT NULL,
  `coupon_code` varchar(191) DEFAULT NULL,
  `package_details` longtext NOT NULL,
  `created_id` int(10) unsigned NOT NULL,
  `paid_via` varchar(191) DEFAULT NULL,
  `payment_transaction_id` varchar(191) DEFAULT NULL,
  `status` enum('approved','waiting','declined') NOT NULL DEFAULT 'waiting',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subscriptions_business_id_foreign` (`business_id`),
  KEY `subscriptions_package_id_index` (`package_id`),
  KEY `subscriptions_created_id_index` (`created_id`),
  CONSTRAINT `subscriptions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` VALUES (1,1,1,'2024-08-23','2125-08-18','2124-08-23',0.0000,0.0000,NULL,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"test\",\"accounting_module\":\"1\",\"aiassistance_module\":\"1\",\"aiassistance_max_token\":null,\"assetmanagement_module\":\"1\",\"connector_module\":\"1\",\"crm_module\":\"1\",\"essentials_module\":\"1\",\"manufacturing_module\":\"1\",\"productcatalogue_module\":\"1\",\"project_module\":\"1\",\"repair_module\":\"1\",\"woocommerce_module\":\"1\"}',1,'offline','34543534','approved',NULL,'2024-08-23 19:58:41','2024-08-23 19:58:41'),(2,5,1,'2024-09-14','2125-09-09','2124-09-14',0.0000,0.0000,NULL,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"test\",\"accounting_module\":\"1\",\"aiassistance_module\":\"1\",\"aiassistance_max_token\":null,\"assetmanagement_module\":\"1\",\"connector_module\":\"1\",\"crm_module\":\"1\",\"essentials_module\":\"1\",\"manufacturing_module\":\"1\",\"productcatalogue_module\":\"1\",\"project_module\":\"1\",\"repair_module\":\"1\",\"woocommerce_module\":\"1\"}',1,'offline','01111','approved',NULL,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(3,12,2,'2025-02-22','2026-03-01','2026-02-22',50.0000,50.0000,NULL,'{\"location_count\":5,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"tessst\",\"accounting_module\":\"1\",\"aiassistance_max_token\":null,\"connector_module\":\"1\",\"crm_module\":\"1\",\"essentials_module\":\"1\",\"manufacturing_module\":\"1\",\"project_module\":\"1\",\"repair_module\":\"1\",\"woocommerce_module\":\"1\"}',1,'offline','0111111','approved',NULL,'2025-02-22 17:18:55','2025-02-22 17:18:55');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_communicator_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `superadmin_communicator_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_ids` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_communicator_logs` WRITE;
/*!40000 ALTER TABLE `superadmin_communicator_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_communicator_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `superadmin_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_code` varchar(191) NOT NULL,
  `discount_type` varchar(191) NOT NULL,
  `discount` decimal(8,2) NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `applied_on_packages` varchar(191) DEFAULT NULL,
  `applied_on_business` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_coupons` WRITE;
/*!40000 ALTER TABLE `superadmin_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_coupons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_frontend_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `superadmin_frontend_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) DEFAULT NULL,
  `slug` varchar(191) NOT NULL,
  `content` longtext NOT NULL,
  `is_shown` tinyint(1) NOT NULL,
  `menu_order` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_frontend_pages` WRITE;
/*!40000 ALTER TABLE `superadmin_frontend_pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_frontend_pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) NOT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','6.0'),(2,'default_business_active_status','1'),(3,'connector_version','3.0'),(4,'repair_version','3.0'),(5,'cms_version','2.0'),(6,'project_version','3.0'),(7,'manufacturing_version','4.0'),(8,'accounting_version','1.0'),(9,'productcatalogue_version','1.0'),(10,'assetmanagement_version','3.0'),(11,'essentials_version','5.0'),(12,'crm_version','3.0'),(13,'aiassistance_version','2.0'),(14,'superadmin_version','6.0'),(15,'app_currency_id','2'),(16,'invoice_business_name','erp'),(17,'invoice_business_landmark','Landmark'),(18,'invoice_business_zip','Zip'),(19,'invoice_business_state','State'),(20,'invoice_business_city','City'),(21,'invoice_business_country','Country'),(22,'email','superadmin@example.com'),(23,'package_expiry_alert_days','5'),(24,'enable_business_based_username','0'),(25,'woocommerce_version','5.1'),(26,'superadmin_register_tc',NULL),(27,'welcome_email_subject',NULL),(28,'welcome_email_body',NULL),(29,'additional_js',NULL),(30,'additional_css',NULL),(31,'offline_payment_details',NULL),(32,'superadmin_enable_register_tc','0'),(33,'allow_email_settings_to_businesses','0'),(34,'enable_new_business_registration_notification','0'),(35,'enable_new_subscription_notification','0'),(36,'enable_welcome_email','0'),(37,'enable_offline_payment','1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(22,4) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT 0,
  `for_tax_group` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_tax_rate_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  KEY `tax_rates_woocommerce_tax_rate_id_index` (`woocommerce_tax_rate_id`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
INSERT INTO `tax_rates` VALUES (1,1,'VAT',20.0000,0,0,1,NULL,NULL,'2024-09-25 21:33:56','2024-09-25 21:33:56');
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Used during sales to return the change',
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `method` varchar(191) DEFAULT NULL,
  `payment_type` varchar(191) DEFAULT NULL,
  `transaction_no` varchar(191) DEFAULT NULL,
  `card_transaction_number` varchar(191) DEFAULT NULL,
  `card_number` varchar(191) DEFAULT NULL,
  `card_type` varchar(191) DEFAULT NULL,
  `card_holder_name` varchar(191) DEFAULT NULL,
  `card_month` varchar(191) DEFAULT NULL,
  `card_year` varchar(191) DEFAULT NULL,
  `card_security` varchar(5) DEFAULT NULL,
  `cheque_number` varchar(191) DEFAULT NULL,
  `bank_account_number` varchar(191) DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `paid_through_link` tinyint(1) NOT NULL DEFAULT 0,
  `gateway` varchar(191) DEFAULT NULL,
  `is_advance` tinyint(1) NOT NULL DEFAULT 0,
  `payment_for` int(11) DEFAULT NULL COMMENT 'stores the contact id',
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) DEFAULT NULL,
  `document` varchar(191) DEFAULT NULL,
  `payment_ref_no` varchar(191) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  KEY `transaction_payments_parent_id_index` (`parent_id`),
  KEY `transaction_payments_payment_type_index` (`payment_type`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (1,13,1,0,12.5000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-26 18:15:52',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0001',NULL,'2024-08-26 18:15:52','2024-08-26 18:15:52'),(2,14,1,0,125.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-26 18:37:10',1,0,NULL,0,2,NULL,NULL,NULL,'SP2024/0002',NULL,'2024-08-26 18:37:10','2024-08-26 19:48:39'),(3,15,1,0,1262.5000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-26 18:43:25',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0003',NULL,'2024-08-26 18:43:25','2024-08-26 18:43:25'),(4,16,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-26 19:12:13',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0004',NULL,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(5,17,1,0,200.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-26 20:06:32',1,0,NULL,0,2,NULL,NULL,NULL,'SP2024/0005',NULL,'2024-08-26 20:06:32','2024-08-26 20:06:32'),(6,NULL,1,0,100.0000,'cash','credit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-26 06:43:14',1,0,NULL,1,2,NULL,NULL,NULL,'SP2024/0006',NULL,'2024-08-26 20:10:33','2024-08-26 20:10:33'),(7,17,1,0,100.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-26 06:43:14',1,0,NULL,0,2,6,NULL,NULL,'SP2024/0007',NULL,'2024-08-26 20:10:33','2024-08-26 20:10:33'),(8,18,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-26 20:20:26',1,0,NULL,0,2,NULL,NULL,NULL,'SP2024/0008',NULL,'2024-08-26 20:20:26','2024-08-26 20:20:26'),(9,19,1,0,12.5000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-27 19:56:38',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0009',NULL,'2024-08-27 19:56:38','2024-08-27 19:56:38'),(10,NULL,1,0,125.0000,'cash','credit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-27 07:42:26',1,0,NULL,1,2,NULL,NULL,NULL,'SP2024/0010',NULL,'2024-08-27 20:12:29','2024-08-27 20:12:29'),(11,17,1,0,75.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-27 07:42:26',1,0,NULL,0,2,10,NULL,NULL,'SP2024/0011',NULL,'2024-08-27 20:12:29','2024-08-27 20:12:29'),(12,18,1,0,50.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-27 07:42:26',1,0,NULL,0,2,10,NULL,NULL,'SP2024/0012',NULL,'2024-08-27 20:12:29','2024-08-27 20:12:29'),(13,25,1,0,387.5000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-30 14:10:38',1,0,NULL,0,2,NULL,NULL,NULL,'SP2024/0013',NULL,'2024-08-30 14:10:38','2024-08-30 14:10:38'),(14,28,1,0,712.5000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-12 16:14:53',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0014',NULL,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(15,28,1,0,500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-12 16:14:53',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0015',NULL,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(16,28,1,0,-500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-12 16:14:53',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0016',NULL,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(17,29,1,0,50.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-12 16:15:15',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0017',NULL,'2024-09-12 16:15:15','2024-09-12 16:15:15'),(18,30,1,0,100.0000,'card',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-12 16:16:04',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0018',NULL,'2024-09-12 16:16:04','2024-09-12 16:16:04'),(19,31,1,0,425.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 12:57:26',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0019',NULL,'2024-09-14 12:57:26','2024-09-14 12:57:26'),(21,33,1,0,12.5000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 16:56:00',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0021',NULL,'2024-09-14 16:56:00','2024-09-14 16:56:00'),(22,34,1,0,375.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 20:55:46',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0022',NULL,'2024-09-14 20:55:46','2024-09-14 20:55:46'),(23,34,1,0,375.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 20:55:46',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0023',NULL,'2024-09-14 20:55:46','2024-09-14 20:55:46'),(24,34,1,1,375.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 20:55:46',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0024',NULL,'2024-09-14 20:55:46','2024-09-14 20:55:46'),(25,35,1,0,400.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:31:43',1,0,NULL,0,2,NULL,NULL,NULL,'SP2024/0025',NULL,'2024-09-24 09:31:43','2024-09-24 09:31:43'),(26,35,1,0,300.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:31:43',1,0,NULL,0,2,NULL,NULL,NULL,'SP2024/0026',NULL,'2024-09-24 09:31:43','2024-09-24 09:31:43'),(27,35,1,1,300.0000,'cash',NULL,NULL,'','','','','',NULL,'','','','2024-09-24 09:31:43',1,0,NULL,0,2,NULL,'',NULL,'SP2024/0027',NULL,'2024-09-24 09:31:43','2024-09-24 09:31:43'),(28,36,1,0,20.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:33:13',1,0,NULL,0,2,NULL,NULL,NULL,'SP2024/0028',NULL,'2024-09-24 09:33:13','2024-09-24 09:33:13'),(29,37,1,0,50.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:34:42',1,0,NULL,0,2,NULL,NULL,NULL,'SP2024/0029',NULL,'2024-09-24 09:34:42','2024-09-24 09:34:42'),(30,NULL,1,0,200.0000,'cash','credit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:59:03',1,0,NULL,1,2,NULL,NULL,NULL,'SP2024/0030',NULL,'2024-09-24 10:29:07','2024-09-24 10:29:07'),(31,36,1,0,200.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:59:03',1,0,NULL,0,2,30,NULL,NULL,'SP2024/0031',NULL,'2024-09-24 10:29:07','2024-09-24 10:29:07'),(32,NULL,1,0,200.0000,'cash','credit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:58:57',1,0,NULL,1,2,NULL,NULL,NULL,'SP2024/0032',NULL,'2024-09-24 10:29:09','2024-09-24 10:29:09'),(33,36,1,0,180.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:58:57',1,0,NULL,0,2,32,NULL,NULL,'SP2024/0033',NULL,'2024-09-24 10:29:09','2024-09-24 10:29:09'),(34,37,1,0,20.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:58:57',1,0,NULL,0,2,32,NULL,NULL,'SP2024/0034',NULL,'2024-09-24 10:29:09','2024-09-24 10:29:09'),(35,NULL,1,0,10.0000,'cash','credit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 10:01:12',1,0,NULL,1,2,NULL,NULL,NULL,'SP2024/0035',NULL,'2024-09-24 10:31:13','2024-09-24 10:31:13'),(36,37,1,0,10.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 10:01:12',1,0,NULL,0,2,35,NULL,NULL,'SP2024/0036',NULL,'2024-09-24 10:31:14','2024-09-24 10:31:14'),(37,NULL,1,0,7.5000,'cash','credit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 10:01:58',1,0,NULL,1,2,NULL,NULL,NULL,'SP2024/0037',NULL,'2024-09-24 10:32:05','2024-09-24 10:32:05'),(38,37,1,0,7.5000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 10:01:58',1,0,NULL,0,2,37,NULL,NULL,'SP2024/0038',NULL,'2024-09-24 10:32:05','2024-09-24 10:32:05'),(39,38,1,0,175.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 10:32:24',1,0,NULL,0,2,NULL,NULL,NULL,'SP2024/0039',NULL,'2024-09-24 10:32:24','2024-09-24 10:32:24'),(40,NULL,1,0,43.0000,'cash','credit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 01:31:29',1,0,NULL,1,2,NULL,NULL,NULL,'SP2024/0040',NULL,'2024-09-24 14:01:30','2024-09-24 14:01:30'),(41,37,1,0,43.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 01:31:29',1,0,NULL,0,2,40,NULL,NULL,'SP2024/0041',NULL,'2024-09-24 14:01:30','2024-09-24 14:01:30'),(42,39,1,0,50.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 18:11:00',1,0,NULL,0,3,NULL,'50 is due',NULL,'SP2024/0042',NULL,'2024-09-24 18:11:00','2024-09-24 18:11:00'),(43,NULL,1,0,50.0000,'card','credit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 05:47:57',1,0,NULL,1,3,NULL,NULL,NULL,'SP2024/0043',NULL,'2024-09-24 18:18:00','2024-09-24 18:18:00'),(44,39,1,0,50.0000,'card',NULL,'card',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 05:47:57',1,0,NULL,0,3,43,NULL,NULL,'SP2024/0044',NULL,'2024-09-24 18:18:00','2024-09-24 18:18:00'),(45,40,1,0,402.5000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 18:44:58',1,0,NULL,0,3,NULL,NULL,NULL,'SP2024/0045',NULL,'2024-09-24 18:44:58','2024-09-24 18:44:58'),(46,NULL,1,0,160.0000,'cash','credit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 06:15:42',1,0,NULL,1,3,NULL,NULL,NULL,'SP2024/0046',NULL,'2024-09-24 18:45:44','2024-09-24 18:45:44'),(47,40,1,0,160.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 06:15:42',1,0,NULL,0,3,46,NULL,NULL,'SP2024/0047',NULL,'2024-09-24 18:45:44','2024-09-24 18:45:44'),(48,41,1,0,57.5000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 19:08:48',1,0,NULL,0,2,NULL,NULL,NULL,'SP2024/0048',NULL,'2024-09-24 19:08:48','2024-09-24 19:08:48'),(49,42,1,0,187.5000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-24 19:17:48',1,0,NULL,0,4,NULL,NULL,NULL,'SP2024/0049',NULL,'2024-09-24 19:17:48','2024-09-24 19:17:48'),(50,44,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-26 17:47:00',1,0,NULL,0,3,NULL,'test',NULL,'SP2024/0050',NULL,'2024-09-26 17:50:45','2024-09-26 17:51:51'),(51,46,1,0,200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-25 19:52:17',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0051',NULL,'2024-10-25 19:52:17','2024-10-25 19:52:17'),(52,48,1,0,375.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-07 18:21:40',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0052',NULL,'2024-11-07 18:21:40','2024-11-07 18:21:40'),(53,49,1,0,750.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-15 14:47:01',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0053',NULL,'2024-11-15 14:47:01','2024-11-15 14:47:01'),(54,52,1,0,25.0000,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-15 15:03:57',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0054',NULL,'2024-11-15 15:03:57','2024-11-15 15:03:57'),(55,53,1,0,362.5000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-17 06:15:38',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0055',NULL,'2024-11-17 06:15:38','2024-11-17 06:15:38'),(56,54,1,0,937.5000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-17 06:16:51',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0056',NULL,'2024-11-17 06:16:51','2024-11-17 06:16:51'),(57,55,1,0,15.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-17 06:19:29',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0057',NULL,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(58,55,1,0,10.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-17 06:19:29',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0058',NULL,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(59,55,1,0,10.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-17 06:19:29',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0059',NULL,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(60,55,1,1,10.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-17 06:19:29',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0060',NULL,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(61,58,1,0,8450.0000,'card',NULL,NULL,'12323','32324234234234','master','erwerwe','12',NULL,'233',NULL,NULL,'2024-11-29 14:08:36',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0061',NULL,'2024-11-29 14:08:36','2024-11-29 14:08:36'),(62,59,1,0,250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-02 12:51:01',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0062',NULL,'2024-12-02 12:51:01','2024-12-02 12:51:01'),(63,60,1,0,1175.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-06 03:04:40',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0063',NULL,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(64,61,1,0,5.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-06 03:05:00',1,0,NULL,0,NULL,NULL,NULL,NULL,'SP2024/0064',NULL,'2024-12-06 03:06:06','2024-12-06 03:06:06'),(65,63,1,0,387.5000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-07 14:45:50',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0065',NULL,'2024-12-07 14:45:50','2024-12-07 14:45:50'),(66,64,1,0,750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-07 15:28:24',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0066',NULL,'2024-12-07 15:28:24','2024-12-07 15:28:24'),(67,65,1,0,12.5000,'card',NULL,NULL,NULL,NULL,'visa',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-07 15:50:30',1,0,NULL,0,1,NULL,NULL,NULL,'SP2024/0067',NULL,'2024-12-07 15:50:30','2024-12-07 15:50:30'),(68,70,1,0,50000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-07 14:15:24',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0068',NULL,'2025-01-07 14:15:24','2025-01-07 14:15:24'),(69,70,1,0,12775.0000,'cheque',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,'121',NULL,'2025-01-07 14:15:24',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0069',NULL,'2025-01-07 14:15:24','2025-01-07 14:15:24'),(70,71,1,0,25.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-07 14:16:27',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0070',NULL,'2025-01-07 14:16:27','2025-01-07 14:16:27'),(71,73,1,0,25.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-07 18:01:20',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0071',NULL,'2025-01-07 18:01:20','2025-01-07 18:01:20'),(72,NULL,1,0,200.0000,'cash','credit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-07 03:45:35',1,0,NULL,1,2,NULL,NULL,NULL,'SP2025/0072',NULL,'2025-01-07 18:15:37','2025-01-07 18:15:37'),(73,37,1,0,57.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-07 03:45:35',1,0,NULL,0,2,72,NULL,NULL,'SP2025/0073',NULL,'2025-01-07 18:15:37','2025-01-07 18:15:37'),(74,38,1,0,143.0000,'cash',NULL,'cash',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-07 03:45:35',1,0,NULL,0,2,72,NULL,NULL,'SP2025/0074',NULL,'2025-01-07 18:15:37','2025-01-07 18:15:37'),(75,78,1,0,450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-10 19:54:57',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0075',NULL,'2025-02-10 19:54:57','2025-02-10 19:54:57'),(76,79,1,0,450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-21 12:23:43',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0076',NULL,'2025-02-21 12:23:43','2025-02-21 12:23:43'),(77,80,1,0,350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-21 12:26:31',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0077',NULL,'2025-02-21 12:26:31','2025-02-21 12:26:31'),(78,81,1,0,250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-21 12:45:02',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0078',NULL,'2025-02-21 12:45:02','2025-02-21 12:45:02'),(79,82,1,0,25.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-22 16:07:35',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0079',NULL,'2025-02-22 16:07:35','2025-02-22 16:07:35'),(80,83,1,0,25.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-22 16:11:20',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0080',NULL,'2025-02-22 16:11:20','2025-02-22 16:11:20'),(81,84,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-24 04:53:25',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0081',NULL,'2025-02-24 04:53:25','2025-02-24 04:53:25'),(82,85,1,0,125.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-24 10:30:38',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0082',NULL,'2025-02-24 10:30:38','2025-02-24 10:30:38'),(83,86,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-24 11:49:31',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0083',NULL,'2025-02-24 11:49:31','2025-02-24 11:49:31');
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_waste_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_ingredient_group_id` int(11) DEFAULT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT 0.0000,
  `unit_price_before_discount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Sell price excluding tax',
  `line_discount_type` enum('fixed','percentage') DEFAULT NULL,
  `line_discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `sell_line_note` text DEFAULT NULL,
  `woocommerce_line_items_id` int(11) DEFAULT NULL,
  `so_line_id` int(11) DEFAULT NULL,
  `so_quantity_invoiced` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `res_service_staff_id` int(11) DEFAULT NULL,
  `res_line_order_status` varchar(191) DEFAULT NULL,
  `parent_sell_line_id` int(11) DEFAULT NULL,
  `children_type` varchar(191) NOT NULL DEFAULT '' COMMENT 'Type of children for the parent, like modifier or combo',
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  KEY `transaction_sell_lines_children_type_index` (`children_type`),
  KEY `transaction_sell_lines_parent_sell_line_id_index` (`parent_sell_line_id`),
  KEY `transaction_sell_lines_line_discount_type_index` (`line_discount_type`),
  KEY `transaction_sell_lines_discount_id_index` (`discount_id`),
  KEY `transaction_sell_lines_lot_no_line_id_index` (`lot_no_line_id`),
  KEY `transaction_sell_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `transaction_sell_lines_woocommerce_line_items_id_index` (`woocommerce_line_items_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES (1,3,1,1,10.0000,0.0000,NULL,0.0000,0.0000,100.0000,100.0000,NULL,0.0000,100.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(2,3,2,2,10.0000,0.0000,NULL,0.0000,0.0000,50.0000,50.0000,NULL,0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(3,13,4,4,1.0000,0.0000,NULL,0.0000,0.0000,12.5000,12.5000,'fixed',0.0000,12.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 18:15:52','2024-08-26 18:15:52'),(5,15,2,2,1.0000,0.0000,NULL,0.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 18:43:24','2024-08-26 18:43:24'),(6,15,1,1,2.0000,0.0000,NULL,0.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 18:43:24','2024-08-26 18:43:24'),(7,15,5,5,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 18:43:24','2024-08-26 18:43:24'),(8,15,6,6,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 18:43:24','2024-08-26 18:43:24'),(9,15,7,7,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 18:43:24','2024-08-26 18:43:24'),(10,15,9,9,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 18:43:24','2024-08-26 18:43:24'),(11,15,10,10,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 18:43:24','2024-08-26 18:43:24'),(12,16,1,1,1.0000,0.0000,NULL,0.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(13,16,4,4,1.0000,0.0000,NULL,0.0000,0.0000,12.5000,12.5000,'fixed',0.0000,12.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(14,16,5,5,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(15,16,6,6,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(16,16,7,7,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(17,14,1,1,1.0000,0.0000,NULL,0.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 19:48:39','2024-08-26 19:48:39'),(18,17,1,1,3.0000,0.0000,NULL,0.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 20:06:32','2024-08-26 20:06:32'),(19,18,2,2,2.0000,0.0000,NULL,0.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-26 20:20:26','2024-08-26 20:20:26'),(20,19,4,4,1.0000,0.0000,NULL,0.0000,0.0000,12.5000,12.5000,'fixed',0.0000,12.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-27 19:56:38','2024-08-27 19:56:38'),(21,25,1,1,1.0000,0.0000,NULL,0.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-30 14:10:38','2024-08-30 14:10:38'),(22,25,2,2,1.0000,0.0000,NULL,0.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-30 14:10:38','2024-08-30 14:10:38'),(23,25,7,7,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-08-30 14:10:38','2024-08-30 14:10:38'),(24,28,7,7,3.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(25,28,16,16,3.0000,0.0000,NULL,0.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(26,29,16,16,1.0000,0.0000,NULL,0.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-12 16:15:15','2024-09-12 16:15:15'),(27,30,16,16,2.0000,0.0000,NULL,0.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-12 16:16:04','2024-09-12 16:16:04'),(28,31,17,17,2.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-14 12:57:26','2024-09-14 12:57:26'),(29,31,14,14,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-14 12:57:26','2024-09-14 12:57:26'),(30,31,12,12,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-14 12:57:26','2024-09-14 12:57:26'),(32,33,4,4,1.0000,0.0000,NULL,0.0000,0.0000,12.5000,12.5000,'fixed',0.0000,12.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-14 16:56:00','2024-09-14 16:56:00'),(33,34,12,12,2.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-14 20:55:46','2024-09-14 20:55:46'),(34,35,2,2,2.0000,0.0000,NULL,0.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 09:31:43','2024-09-24 09:31:43'),(35,35,1,1,2.0000,0.0000,NULL,0.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 09:31:43','2024-09-24 09:31:43'),(36,36,1,1,2.0000,0.0000,NULL,0.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 09:33:13','2024-09-24 09:33:13'),(37,36,2,2,2.0000,0.0000,NULL,0.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 09:33:13','2024-09-24 09:33:13'),(38,37,6,6,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 09:34:42','2024-09-24 09:34:42'),(39,38,5,5,2.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 10:32:24','2024-09-24 10:32:24'),(40,39,1,1,1.0000,0.0000,NULL,0.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 18:11:00','2024-09-24 18:11:00'),(41,39,2,2,1.0000,0.0000,NULL,0.0000,0.0000,75.0000,75.0000,'fixed',0.0000,75.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 18:11:00','2024-09-24 18:11:00'),(42,40,7,7,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 18:44:58','2024-09-24 18:44:58'),(43,40,10,10,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 18:44:58','2024-09-24 18:44:58'),(44,40,9,9,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 18:44:58','2024-09-24 18:44:58'),(45,41,6,6,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 19:08:48','2024-09-24 19:08:48'),(46,42,5,5,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-24 19:17:48','2024-09-24 19:17:48'),(47,44,19,19,5.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-09-26 17:50:45','2024-09-26 17:51:51'),(49,45,19,19,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-10-18 15:29:29','2024-10-18 15:29:29'),(50,46,4,4,1.0000,0.0000,NULL,0.0000,1.0000,12.5000,12.5000,'fixed',0.0000,12.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-10-25 19:52:17','2024-10-25 19:52:47'),(51,46,5,5,1.0000,0.0000,NULL,0.0000,1.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-10-25 19:52:17','2024-10-25 19:52:47'),(52,48,19,19,2.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-07 18:21:40','2024-11-07 18:21:40'),(53,49,19,19,4.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-15 14:47:01','2024-11-15 14:47:01'),(54,52,17,17,1.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-15 15:03:57','2024-11-15 15:03:57'),(55,53,1,1,1.0000,0.0000,NULL,0.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-17 06:15:38','2024-11-17 06:15:38'),(56,53,5,5,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-17 06:15:38','2024-11-17 06:15:38'),(57,53,16,16,1.0000,0.0000,NULL,0.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-17 06:15:38','2024-11-17 06:15:38'),(58,54,7,7,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,'cooked',NULL,'',NULL,'2024-11-17 06:16:51','2024-12-06 16:35:55'),(59,54,5,5,3.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,'cooked',NULL,'',NULL,'2024-11-17 06:16:51','2024-12-06 16:35:55'),(60,54,9,9,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,'cooked',NULL,'',NULL,'2024-11-17 06:16:51','2024-12-06 16:35:55'),(61,55,17,17,1.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(62,56,17,17,2.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-17 06:20:54','2024-11-17 06:20:54'),(63,57,17,17,1.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-17 06:25:07','2024-11-17 06:25:07'),(64,58,15,15,2.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-29 14:08:36','2024-11-29 14:08:36'),(65,58,4,4,16.0000,0.0000,NULL,0.0000,0.0000,12.5000,12.5000,'fixed',0.0000,12.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-29 14:08:36','2024-11-29 14:08:36'),(66,58,9,9,42.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-11-29 14:08:36','2024-11-29 14:08:36'),(67,59,4,4,1.0000,0.0000,NULL,0.0000,0.0000,12.5000,12.5000,'fixed',0.0000,12.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-02 12:51:01','2024-12-02 12:51:01'),(68,59,9,9,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-02 12:51:01','2024-12-02 12:51:01'),(69,59,16,16,1.0000,0.0000,NULL,0.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-02 12:51:01','2024-12-02 12:51:01'),(70,60,1,1,3.0000,0.0000,NULL,0.0000,0.0000,125.0000,125.0000,'fixed',0.0000,125.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(71,60,9,9,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(72,60,15,15,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(73,60,16,16,1.0000,0.0000,NULL,0.0000,0.0000,50.0000,50.0000,'fixed',0.0000,50.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(74,60,10,10,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(75,60,5,5,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(76,62,17,17,1.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-06 04:13:29','2024-12-06 04:13:29'),(77,62,19,19,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-06 04:13:29','2024-12-06 04:13:29'),(78,63,4,4,1.0000,0.0000,NULL,0.0000,0.0000,12.5000,12.5000,'fixed',0.0000,12.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-07 14:45:50','2024-12-07 14:45:50'),(79,63,5,5,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-07 14:45:50','2024-12-07 14:45:50'),(80,63,6,6,1.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-07 14:45:50','2024-12-07 14:45:50'),(81,64,5,5,4.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-07 15:28:24','2024-12-07 15:28:24'),(82,65,4,4,1.0000,0.0000,NULL,0.0000,0.0000,12.5000,12.5000,'fixed',0.0000,12.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-07 15:50:30','2024-12-07 15:50:30'),(83,67,20,20,11.0000,0.0000,NULL,0.0000,0.0000,0.0000,0.0000,NULL,0.0000,0.0000,0.0000,NULL,NULL,21,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2024-12-10 23:44:01','2024-12-10 23:44:01'),(84,70,9,9,96.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',11,'2025-01-07 14:15:24','2025-01-07 14:15:24'),(85,70,12,12,276.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',11,'2025-01-07 14:15:24','2025-01-07 14:15:24'),(86,71,17,17,1.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-01-07 14:16:27','2025-01-07 14:16:27'),(87,72,17,17,4.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-01-07 14:17:29','2025-01-07 14:17:29'),(88,73,17,17,1.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-01-07 18:01:20','2025-01-07 18:01:20'),(89,76,25,25,1.0000,0.0000,NULL,0.0000,0.0000,300.0000,300.0000,'fixed',0.0000,300.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-01-27 13:16:20','2025-01-27 13:16:20'),(90,77,26,26,1.0000,0.0000,NULL,0.0000,0.0000,350.0000,350.0000,'fixed',0.0000,350.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-01-27 13:25:51','2025-01-27 13:25:51'),(91,78,17,17,3.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-10 19:54:57','2025-02-10 19:54:57'),(92,78,19,19,2.0000,0.0000,NULL,0.0000,0.0000,187.5000,187.5000,'fixed',0.0000,187.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-10 19:54:57','2025-02-10 19:54:57'),(93,79,17,17,8.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-21 12:23:43','2025-02-21 12:23:43'),(94,79,17,17,10.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-21 12:23:43','2025-02-21 12:23:43'),(95,80,17,17,7.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-21 12:26:31','2025-02-21 12:26:31'),(96,80,17,17,7.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-21 12:26:31','2025-02-21 12:26:31'),(97,81,17,17,10.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-21 12:45:02','2025-02-21 12:45:02'),(98,82,17,17,1.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-22 16:07:35','2025-02-22 16:07:35'),(99,83,17,17,1.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-22 16:11:20','2025-02-22 16:11:20'),(100,84,17,17,4.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-24 04:53:25','2025-02-24 04:53:25'),(101,85,17,17,5.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-24 10:30:38','2025-02-24 10:30:38'),(102,86,17,17,40.0000,0.0000,NULL,0.0000,0.0000,25.0000,25.0000,'fixed',0.0000,25.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-02-24 11:49:31','2025-02-24 11:49:31');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(22,4) NOT NULL,
  `qty_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sell_line_id` (`sell_line_id`),
  KEY `stock_adjustment_line_id` (`stock_adjustment_line_id`),
  KEY `purchase_line_id` (`purchase_line_id`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines_purchase_lines` VALUES (1,1,NULL,2,10.0000,0.0000,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(2,2,NULL,1,10.0000,0.0000,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(3,3,NULL,5,1.0000,0.0000,'2024-08-26 18:15:53','2024-08-26 18:15:53'),(5,5,NULL,1,1.0000,0.0000,'2024-08-26 18:43:25','2024-08-26 18:43:25'),(6,6,NULL,2,2.0000,0.0000,'2024-08-26 18:43:25','2024-08-26 18:43:25'),(7,7,NULL,6,1.0000,0.0000,'2024-08-26 18:43:25','2024-08-26 18:43:25'),(8,8,NULL,7,1.0000,0.0000,'2024-08-26 18:43:25','2024-08-26 18:43:25'),(9,9,NULL,9,1.0000,0.0000,'2024-08-26 18:43:25','2024-08-26 18:43:25'),(10,10,NULL,10,1.0000,0.0000,'2024-08-26 18:43:25','2024-08-26 18:43:25'),(11,11,NULL,11,1.0000,0.0000,'2024-08-26 18:43:25','2024-08-26 18:43:25'),(12,12,NULL,2,1.0000,0.0000,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(13,13,NULL,5,1.0000,0.0000,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(14,14,NULL,6,1.0000,0.0000,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(15,15,NULL,7,1.0000,0.0000,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(16,16,NULL,9,1.0000,0.0000,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(17,17,NULL,2,1.0000,0.0000,'2024-08-26 19:48:39','2024-08-26 19:48:39'),(18,18,NULL,2,3.0000,0.0000,'2024-08-26 20:06:32','2024-08-26 20:06:32'),(19,19,NULL,1,2.0000,0.0000,'2024-08-26 20:20:26','2024-08-26 20:20:26'),(20,20,NULL,5,1.0000,0.0000,'2024-08-27 19:56:38','2024-08-27 19:56:38'),(21,21,NULL,2,1.0000,0.0000,'2024-08-30 14:10:38','2024-08-30 14:10:38'),(22,22,NULL,1,1.0000,0.0000,'2024-08-30 14:10:38','2024-08-30 14:10:38'),(23,23,NULL,9,1.0000,0.0000,'2024-08-30 14:10:38','2024-08-30 14:10:38'),(24,NULL,1,5,10.0000,0.0000,'2024-09-03 11:50:48','2024-09-03 11:50:48'),(25,NULL,2,6,100.0000,0.0000,'2024-09-03 11:52:30','2024-09-03 11:52:30'),(26,24,NULL,9,3.0000,0.0000,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(27,25,NULL,16,3.0000,0.0000,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(28,26,NULL,16,1.0000,0.0000,'2024-09-12 16:15:15','2024-09-12 16:15:15'),(29,27,NULL,16,2.0000,0.0000,'2024-09-12 16:16:04','2024-09-12 16:16:04'),(30,28,NULL,17,2.0000,0.0000,'2024-09-14 12:57:26','2024-09-14 12:57:26'),(31,29,NULL,13,1.0000,0.0000,'2024-09-14 12:57:26','2024-09-14 12:57:26'),(32,30,NULL,12,1.0000,0.0000,'2024-09-14 12:57:26','2024-09-14 12:57:26'),(34,32,NULL,5,1.0000,0.0000,'2024-09-14 16:56:00','2024-09-14 16:56:00'),(35,33,NULL,12,2.0000,0.0000,'2024-09-14 20:55:46','2024-09-14 20:55:46'),(36,34,NULL,1,2.0000,0.0000,'2024-09-24 09:31:43','2024-09-24 09:31:43'),(37,35,NULL,2,2.0000,0.0000,'2024-09-24 09:31:43','2024-09-24 09:31:43'),(38,36,NULL,2,2.0000,0.0000,'2024-09-24 09:33:13','2024-09-24 09:33:13'),(39,37,NULL,1,2.0000,0.0000,'2024-09-24 09:33:13','2024-09-24 09:33:13'),(40,38,NULL,7,1.0000,0.0000,'2024-09-24 09:34:42','2024-09-24 09:34:42'),(41,39,NULL,6,2.0000,0.0000,'2024-09-24 10:32:24','2024-09-24 10:32:24'),(42,40,NULL,2,1.0000,0.0000,'2024-09-24 18:11:00','2024-09-24 18:11:00'),(43,41,NULL,1,1.0000,0.0000,'2024-09-24 18:11:00','2024-09-24 18:11:00'),(44,42,NULL,9,1.0000,0.0000,'2024-09-24 18:44:58','2024-09-24 18:44:58'),(45,43,NULL,11,1.0000,0.0000,'2024-09-24 18:44:58','2024-09-24 18:44:58'),(46,44,NULL,10,1.0000,0.0000,'2024-09-24 18:44:58','2024-09-24 18:44:58'),(47,45,NULL,7,1.0000,0.0000,'2024-09-24 19:08:48','2024-09-24 19:08:48'),(48,46,NULL,6,1.0000,0.0000,'2024-09-24 19:17:48','2024-09-24 19:17:48'),(49,47,NULL,18,5.0000,0.0000,'2024-09-26 17:50:45','2024-09-26 17:50:45'),(50,49,NULL,18,1.0000,0.0000,'2024-10-18 15:29:29','2024-10-18 15:29:29'),(51,50,NULL,5,1.0000,1.0000,'2024-10-25 19:52:17','2024-10-25 19:52:47'),(52,51,NULL,6,1.0000,1.0000,'2024-10-25 19:52:17','2024-10-25 19:52:47'),(53,52,NULL,18,2.0000,0.0000,'2024-11-07 18:21:40','2024-11-07 18:21:40'),(54,53,NULL,18,4.0000,0.0000,'2024-11-15 14:47:01','2024-11-15 14:47:01'),(55,54,NULL,19,1.0000,0.0000,'2024-11-15 15:03:57','2024-11-15 15:03:57'),(56,55,NULL,2,1.0000,0.0000,'2024-11-17 06:15:38','2024-11-17 06:15:38'),(57,56,NULL,6,1.0000,0.0000,'2024-11-17 06:15:38','2024-11-17 06:15:38'),(58,57,NULL,16,1.0000,0.0000,'2024-11-17 06:15:38','2024-11-17 06:15:38'),(59,58,NULL,9,1.0000,0.0000,'2024-11-17 06:16:51','2024-11-17 06:16:51'),(60,59,NULL,6,3.0000,0.0000,'2024-11-17 06:16:51','2024-11-17 06:16:51'),(61,60,NULL,10,1.0000,0.0000,'2024-11-17 06:16:51','2024-11-17 06:16:51'),(62,61,NULL,20,1.0000,0.0000,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(63,63,NULL,20,1.0000,0.0000,'2024-11-17 06:25:07','2024-11-17 06:25:07'),(64,64,NULL,14,2.0000,0.0000,'2024-11-29 14:08:36','2024-11-29 14:08:36'),(65,65,NULL,5,16.0000,0.0000,'2024-11-29 14:08:36','2024-11-29 14:08:36'),(66,66,NULL,10,42.0000,0.0000,'2024-11-29 14:08:36','2024-11-29 14:08:36'),(67,67,NULL,5,1.0000,0.0000,'2024-12-02 12:51:01','2024-12-02 12:51:01'),(68,68,NULL,10,1.0000,0.0000,'2024-12-02 12:51:01','2024-12-02 12:51:01'),(69,69,NULL,16,1.0000,0.0000,'2024-12-02 12:51:01','2024-12-02 12:51:01'),(70,70,NULL,2,3.0000,0.0000,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(71,71,NULL,10,1.0000,0.0000,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(72,72,NULL,14,1.0000,0.0000,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(73,73,NULL,16,1.0000,0.0000,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(74,74,NULL,11,1.0000,0.0000,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(75,75,NULL,6,1.0000,0.0000,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(76,78,NULL,5,1.0000,0.0000,'2024-12-07 14:45:50','2024-12-07 14:45:50'),(77,79,NULL,6,1.0000,0.0000,'2024-12-07 14:45:50','2024-12-07 14:45:50'),(78,80,NULL,7,1.0000,0.0000,'2024-12-07 14:45:50','2024-12-07 14:45:50'),(79,81,NULL,6,4.0000,0.0000,'2024-12-07 15:28:24','2024-12-07 15:28:24'),(80,82,NULL,5,1.0000,0.0000,'2024-12-07 15:50:30','2024-12-07 15:50:30'),(81,83,NULL,21,11.0000,0.0000,'2024-12-10 23:44:01','2024-12-10 23:44:01'),(82,84,NULL,10,96.0000,0.0000,'2025-01-07 14:15:24','2025-01-07 14:15:24'),(83,85,NULL,12,276.0000,0.0000,'2025-01-07 14:15:24','2025-01-07 14:15:24'),(84,86,NULL,20,1.0000,0.0000,'2025-01-07 14:16:27','2025-01-07 14:16:27'),(85,88,NULL,19,1.0000,0.0000,'2025-01-07 18:01:20','2025-01-07 18:01:20'),(86,91,NULL,19,3.0000,0.0000,'2025-02-10 19:54:58','2025-02-10 19:54:58'),(87,92,NULL,18,2.0000,0.0000,'2025-02-10 19:54:58','2025-02-10 19:54:58'),(88,93,NULL,19,8.0000,0.0000,'2025-02-21 12:23:43','2025-02-21 12:23:43'),(89,94,NULL,19,10.0000,0.0000,'2025-02-21 12:23:43','2025-02-21 12:23:43'),(90,95,NULL,19,7.0000,0.0000,'2025-02-21 12:26:31','2025-02-21 12:26:31'),(91,96,NULL,19,7.0000,0.0000,'2025-02-21 12:26:31','2025-02-21 12:26:31'),(92,97,NULL,19,10.0000,0.0000,'2025-02-21 12:45:02','2025-02-21 12:45:02'),(93,98,NULL,19,1.0000,0.0000,'2025-02-22 16:07:35','2025-02-22 16:07:35'),(94,99,NULL,19,1.0000,0.0000,'2025-02-22 16:11:20','2025-02-22 16:11:20'),(95,100,NULL,19,4.0000,0.0000,'2025-02-24 04:53:25','2025-02-24 04:53:25'),(96,101,NULL,19,5.0000,0.0000,'2025-02-24 10:30:38','2025-02-24 10:30:38'),(97,102,NULL,19,40.0000,0.0000,'2025-02-24 11:49:31','2025-02-24 11:49:31');
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `is_kitchen_order` tinyint(1) NOT NULL DEFAULT 0,
  `res_table_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') DEFAULT NULL,
  `type` varchar(191) DEFAULT NULL,
  `sub_type` varchar(20) DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `sub_status` varchar(191) DEFAULT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT 0,
  `payment_status` enum('paid','due','partial') DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) DEFAULT NULL,
  `ref_no` varchar(191) DEFAULT NULL,
  `source` varchar(191) DEFAULT NULL,
  `subscription_no` varchar(191) DEFAULT NULL,
  `subscription_repeat_on` varchar(191) DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Total before the purchase/invoice tax, this includeds the indivisual product tax',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `discount_type` enum('fixed','percentage') DEFAULT NULL,
  `discount_amount` decimal(22,4) DEFAULT 0.0000,
  `rp_redeemed` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_redeemed_amount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'rp is the short form of reward points',
  `shipping_details` varchar(191) DEFAULT NULL,
  `shipping_address` text DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `shipping_status` varchar(191) DEFAULT NULL,
  `delivered_to` varchar(191) DEFAULT NULL,
  `delivery_person` bigint(20) DEFAULT NULL,
  `shipping_charges` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `shipping_custom_field_1` varchar(191) DEFAULT NULL,
  `shipping_custom_field_2` varchar(191) DEFAULT NULL,
  `shipping_custom_field_3` varchar(191) DEFAULT NULL,
  `shipping_custom_field_4` varchar(191) DEFAULT NULL,
  `shipping_custom_field_5` varchar(191) DEFAULT NULL,
  `additional_notes` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_fields_info` longtext DEFAULT NULL,
  `round_off_amount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Difference of rounded total and actual total',
  `additional_expense_key_1` varchar(191) DEFAULT NULL,
  `additional_expense_value_1` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_2` varchar(191) DEFAULT NULL,
  `additional_expense_value_2` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_3` varchar(191) DEFAULT NULL,
  `additional_expense_value_3` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_4` varchar(191) DEFAULT NULL,
  `additional_expense_value_4` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `final_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_sub_category_id` int(11) DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT 0,
  `is_suspend` tinyint(1) NOT NULL DEFAULT 0,
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `total_amount_recovered` decimal(22,4) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `return_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_order_id` int(11) DEFAULT NULL,
  `crm_is_order_request` tinyint(1) NOT NULL DEFAULT 0,
  `essentials_duration` decimal(8,2) NOT NULL,
  `essentials_duration_unit` varchar(20) DEFAULT NULL,
  `essentials_amount_per_unit_duration` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `essentials_allowances` text DEFAULT NULL,
  `essentials_deductions` text DEFAULT NULL,
  `mfg_parent_production_purchase_id` int(11) DEFAULT NULL,
  `mfg_wasted_units` decimal(22,4) DEFAULT NULL,
  `mfg_production_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_production_cost_type` varchar(191) DEFAULT 'percentage',
  `mfg_is_final` tinyint(1) NOT NULL DEFAULT 0,
  `repair_completed_on` datetime DEFAULT NULL,
  `repair_warranty_id` int(11) DEFAULT NULL,
  `repair_brand_id` int(11) DEFAULT NULL,
  `repair_status_id` int(11) DEFAULT NULL,
  `repair_model_id` int(11) DEFAULT NULL,
  `repair_job_sheet_id` int(10) unsigned DEFAULT NULL,
  `repair_defects` text DEFAULT NULL,
  `repair_serial_no` varchar(191) DEFAULT NULL,
  `repair_checklist` text DEFAULT NULL,
  `repair_security_pwd` varchar(191) DEFAULT NULL,
  `repair_security_pattern` varchar(191) DEFAULT NULL,
  `repair_due_date` datetime DEFAULT NULL,
  `repair_device_id` int(11) DEFAULT NULL,
  `repair_updates_notif` tinyint(1) NOT NULL DEFAULT 0,
  `purchase_requisition_ids` text DEFAULT NULL,
  `prefer_payment_method` varchar(191) DEFAULT NULL,
  `prefer_payment_account` int(11) DEFAULT NULL,
  `sales_order_ids` text DEFAULT NULL,
  `purchase_order_ids` text DEFAULT NULL,
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `import_batch` int(11) DEFAULT NULL,
  `import_time` datetime DEFAULT NULL,
  `types_of_service_id` int(11) DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') DEFAULT NULL,
  `service_custom_field_1` text DEFAULT NULL,
  `service_custom_field_2` text DEFAULT NULL,
  `service_custom_field_3` text DEFAULT NULL,
  `service_custom_field_4` text DEFAULT NULL,
  `service_custom_field_5` text DEFAULT NULL,
  `service_custom_field_6` text DEFAULT NULL,
  `is_created_from_api` tinyint(1) NOT NULL DEFAULT 0,
  `rp_earned` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `order_addresses` text DEFAULT NULL,
  `is_recurring` tinyint(1) NOT NULL DEFAULT 0,
  `recur_interval` double(22,4) DEFAULT NULL,
  `recur_interval_type` enum('days','months','years') DEFAULT NULL,
  `recur_repetitions` int(11) DEFAULT NULL,
  `recur_stopped_on` datetime DEFAULT NULL,
  `recur_parent_id` int(11) DEFAULT NULL,
  `invoice_token` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `pjt_project_id` int(10) unsigned DEFAULT NULL,
  `pjt_title` varchar(191) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  KEY `transactions_sub_type_index` (`sub_type`),
  KEY `transactions_return_parent_id_index` (`return_parent_id`),
  KEY `type` (`type`),
  KEY `transactions_status_index` (`status`),
  KEY `transactions_sub_status_index` (`sub_status`),
  KEY `transactions_res_table_id_index` (`res_table_id`),
  KEY `transactions_res_waiter_id_index` (`res_waiter_id`),
  KEY `transactions_res_order_status_index` (`res_order_status`),
  KEY `transactions_payment_status_index` (`payment_status`),
  KEY `transactions_discount_type_index` (`discount_type`),
  KEY `transactions_commission_agent_index` (`commission_agent`),
  KEY `transactions_transfer_parent_id_index` (`transfer_parent_id`),
  KEY `transactions_types_of_service_id_index` (`types_of_service_id`),
  KEY `transactions_packing_charge_type_index` (`packing_charge_type`),
  KEY `transactions_recur_parent_id_index` (`recur_parent_id`),
  KEY `transactions_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `transactions_delivery_date_index` (`delivery_date`),
  KEY `transactions_delivery_person_index` (`delivery_person`),
  KEY `transactions_repair_model_id_index` (`repair_model_id`),
  KEY `transactions_repair_warranty_id_index` (`repair_warranty_id`),
  KEY `transactions_repair_brand_id_index` (`repair_brand_id`),
  KEY `transactions_repair_status_id_index` (`repair_status_id`),
  KEY `transactions_repair_device_id_index` (`repair_device_id`),
  KEY `transactions_repair_job_sheet_id_index` (`repair_job_sheet_id`),
  KEY `transactions_pjt_project_id_foreign` (`pjt_project_id`),
  KEY `transactions_mfg_parent_production_purchase_id_index` (`mfg_parent_production_purchase_id`),
  KEY `transactions_woocommerce_order_id_index` (`woocommerce_order_id`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_pjt_project_id_foreign` FOREIGN KEY (`pjt_project_id`) REFERENCES `pjt_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_repair_job_sheet_id_foreign` FOREIGN KEY (`repair_job_sheet_id`) REFERENCES `repair_job_sheets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (1,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 17:08:12',50.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,2,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 17:08:12','2024-08-24 17:08:12'),(2,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 17:08:30',100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,10000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,1,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 17:08:30','2024-08-24 17:08:30'),(3,1,1,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2024/0001',NULL,NULL,NULL,'2024-08-24 17:22:00',1500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(4,1,2,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2024/0001',NULL,NULL,NULL,'2024-08-24 17:22:00',1500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,3,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(5,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 19:24:00',10.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'jj',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,4,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 19:24:17','2024-08-24 19:24:17'),(6,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 19:27:41',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,22500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,5,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 19:27:41','2024-08-24 19:27:41'),(7,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 20:02:12',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,22500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,6,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 20:02:12','2024-08-24 20:02:12'),(8,1,2,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 20:02:12',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,22500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,6,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 20:02:12','2024-08-24 20:02:12'),(9,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 20:04:00',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,37500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,7,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 20:04:00','2024-08-24 20:04:00'),(10,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 20:05:51',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,22500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,9,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 20:05:51','2024-08-24 20:05:51'),(11,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 20:09:20',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,22500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,10,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 20:09:20','2024-08-24 20:09:20'),(12,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 20:11:02',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,375000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,12,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-24 20:11:02','2024-08-24 20:11:02'),(13,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0001','',NULL,NULL,NULL,'2024-08-26 18:15:52',12.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,12.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'2ba12bd2a0ff1a823f45c3497e4c8463',NULL,NULL,NULL,NULL,0,'2024-08-26 18:15:52','2024-08-27 15:23:58'),(14,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'1_2024826187','',NULL,NULL,NULL,'2024-08-26 19:18:32',125.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,125.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'8238f45e1803e66261264b5112a70754',NULL,NULL,NULL,NULL,NULL,'2024-08-26 18:37:10','2024-08-26 19:48:39'),(15,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'1_20248262313','',NULL,NULL,NULL,'2024-08-26 23:13:10',1262.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1262.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'7b1db4f5ec40928d442ad6d4a55e1ba6',NULL,NULL,NULL,NULL,NULL,'2024-08-26 18:43:24','2024-08-26 18:43:25'),(16,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'1_20248261842','',NULL,NULL,NULL,'2024-08-26 18:42:01',700.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,700.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'8e0260c9d6d462ec9e1e0ec652bfb86f',NULL,NULL,NULL,NULL,NULL,'2024-08-26 19:12:13','2024-08-26 19:12:13'),(17,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'1_20248261839','',NULL,NULL,NULL,'2024-08-26 18:38:04',375.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,375.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'fc4f8acd2ba10f148266d61e125d508e',NULL,NULL,NULL,NULL,NULL,'2024-08-26 20:06:32','2024-08-27 20:12:29'),(18,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'1_20248261853','',NULL,NULL,NULL,'2024-08-26 18:52:42',150.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,150.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'5e438d61ff5d4c27abacbc0153ab53db',NULL,NULL,NULL,NULL,NULL,'2024-08-26 20:20:26','2024-08-27 20:12:29'),(19,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'1_20248271926','',NULL,NULL,NULL,'2024-08-27 19:26:33',12.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,12.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'d01a6abd60c9c4d9c075233ab6760ae9',NULL,NULL,NULL,NULL,NULL,'2024-08-27 19:56:38','2024-08-27 19:56:38'),(20,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 16:47:06',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,30000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,14,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-29 16:47:06','2024-08-29 16:47:06'),(21,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 16:49:29',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,67500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,15,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-29 16:49:29','2024-08-29 16:49:29'),(23,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 16:55:11',100.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,5000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,16,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-29 16:55:11','2024-08-29 16:55:11'),(24,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-29 16:52:00',20.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,10000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,17,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-29 16:58:25','2024-08-29 16:58:25'),(25,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'1_20248301410','',NULL,NULL,NULL,'2024-08-30 14:10:26',387.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,387.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'a544b226d45c1b9b6eba2840c0fd48c4',NULL,NULL,NULL,NULL,NULL,'2024-08-30 14:10:38','2024-08-30 14:10:38'),(26,1,1,0,NULL,NULL,NULL,'stock_adjustment',NULL,'',NULL,0,NULL,'normal',NULL,NULL,NULL,'test',NULL,NULL,NULL,'2024-09-03 11:50:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,20000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,0.0000,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-03 11:50:48','2024-09-03 11:50:48'),(27,1,1,0,NULL,NULL,NULL,'stock_adjustment',NULL,'',NULL,0,NULL,'normal',NULL,NULL,NULL,'test 2',NULL,NULL,NULL,'2024-09-03 11:52:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,15000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,0.0000,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-03 11:52:30','2024-09-03 11:52:30'),(28,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0002','',NULL,NULL,NULL,'2024-09-12 16:14:53',712.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,712.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-09-12 16:14:53','2024-09-12 16:14:53'),(29,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0003','',NULL,NULL,NULL,'2024-09-12 16:15:15',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'41b0b17b15ea01d53500217b47e5ec18',NULL,NULL,NULL,NULL,0,'2024-09-12 16:15:15','2024-09-24 18:19:48'),(30,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0004','',NULL,NULL,NULL,'2024-09-12 16:16:04',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'67eae80719bf304870157ca04e07b37a',NULL,NULL,NULL,NULL,0,'2024-09-12 16:16:04','2024-09-24 18:19:48'),(31,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0005','',NULL,NULL,NULL,'2024-09-14 12:57:26',425.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,425.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'b1086b441f8ba088e0cb5a25d4e41a40',NULL,NULL,NULL,NULL,0,'2024-09-14 12:57:26','2024-09-24 18:19:48'),(33,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0007','',NULL,NULL,NULL,'2024-09-14 16:56:00',12.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,12.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'f8a1aaa06a8ef2b2235f4c22fc9993d3',NULL,NULL,NULL,NULL,0,'2024-09-14 16:56:00','2024-09-24 18:19:48'),(34,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0008','',NULL,NULL,NULL,'2024-09-14 20:55:46',375.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,375.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'cbd085b558c57db4631215506ee7db4c',NULL,NULL,NULL,NULL,0,'2024-09-14 20:55:46','2024-09-24 18:19:48'),(35,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'1_202492491','',NULL,NULL,NULL,'2024-09-24 09:00:47',400.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'dd1d7022d029194a49a6102455797a37',NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:31:43','2024-09-24 09:31:43'),(36,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'1_202492493','',NULL,NULL,NULL,'2024-09-24 09:02:51',400.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,400.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'323a255275c60bfcd49ab4f07b74e407',NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:33:13','2024-09-24 10:29:09'),(37,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,2,NULL,'1_202492494','',NULL,NULL,NULL,'2024-09-24 09:04:02',187.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,187.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'0785732b1048bd85a20ffd2eee4118c4',NULL,NULL,NULL,NULL,NULL,'2024-09-24 09:34:42','2025-01-07 18:15:37'),(38,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'partial',NULL,2,NULL,'1_202492495','',NULL,NULL,NULL,'2024-09-24 09:05:22',375.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,375.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'1faa462fb2c4ef411d9a2eb7fb3f8aaf',NULL,NULL,NULL,NULL,NULL,'2024-09-24 10:32:24','2024-09-24 10:32:24'),(39,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,3,NULL,'1_20249241740','',NULL,NULL,NULL,'2024-09-24 17:40:11',200.0000,NULL,0.0000,'percentage',50.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'32b07414d4e0a9f766ff7d31a263c9a6',NULL,NULL,NULL,NULL,NULL,'2024-09-24 18:11:00','2024-09-24 18:18:00'),(40,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,3,NULL,'1_20249241814','',NULL,NULL,NULL,'2024-09-24 18:14:31',562.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,562.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'bf2590e20bdf5331d9ec42679a9ecd8d',NULL,NULL,NULL,NULL,NULL,'2024-09-24 18:44:58','2024-09-24 18:45:44'),(41,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'partial',NULL,2,NULL,'1_20249241838','',NULL,NULL,NULL,'2024-09-24 18:38:23',187.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,187.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'6ee0d8fb18094758b7b2b3b421f1ed3f',NULL,NULL,NULL,NULL,NULL,'2024-09-24 19:08:48','2024-09-24 19:08:48'),(42,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,4,NULL,'1_20249241847','',NULL,NULL,NULL,'2024-09-24 18:47:39',187.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,187.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'ab8488c20aa32a4cf7acd736d017fefc',NULL,NULL,NULL,NULL,NULL,'2024-09-24 19:17:48','2024-09-24 19:17:48'),(43,1,7,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-26 17:47:00',150.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,'k',NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,7500000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,19,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-26 17:47:09','2024-09-26 17:47:09'),(44,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'partial',NULL,3,NULL,'0009','',NULL,NULL,NULL,'2024-09-26 17:47:00',937.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,937.5000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,NULL,0,NULL,NULL,'9b86387f7b5af93bc7f9a9f3b2512dcf',NULL,NULL,NULL,NULL,NULL,'2024-09-26 17:50:45','2024-12-07 15:40:38'),(45,1,7,0,NULL,NULL,NULL,'sell',NULL,'final','quotation',0,'due',NULL,3,NULL,'1_2024102610','',NULL,NULL,NULL,'2024-10-18 02:58:45',187.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,'Ghana',NULL,NULL,NULL,NULL,NULL,10.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,197.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'ff49f49a36a000b8277b9b069c0189f4',NULL,NULL,NULL,NULL,NULL,'2024-10-02 18:40:21','2024-10-18 15:29:29'),(46,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0011','',NULL,NULL,NULL,'2024-10-25 19:52:17',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-10-25 19:52:17','2024-10-25 19:52:17'),(47,1,1,0,NULL,NULL,NULL,'sell_return',NULL,'final',NULL,0,'due',NULL,1,NULL,'CN2024/0001',NULL,NULL,NULL,NULL,'2024-10-25 19:52:00',200.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,200.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,46,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-10-25 19:52:47','2024-10-25 19:52:47'),(48,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0012','',NULL,NULL,NULL,'2024-11-07 18:21:40',375.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,375.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'946108e596b897b9ea8c2eb4ece59f06',NULL,NULL,NULL,NULL,0,'2024-11-07 18:21:40','2024-12-07 15:40:38'),(49,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'1_202411151716','',NULL,NULL,NULL,'2024-11-15 17:16:52',750.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,750.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'769ae2262c3515ce0aa7eab93719323f',NULL,NULL,NULL,NULL,NULL,'2024-11-15 14:47:01','2024-11-15 14:47:01'),(50,1,7,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 15:03:02',20.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1980.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,17,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-15 15:03:02','2024-11-15 15:03:02'),(51,1,8,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-01-01 15:03:02',20.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1980.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,17,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-15 15:03:02','2024-11-15 15:03:02'),(52,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'1_202411151733','',NULL,NULL,NULL,'2024-11-15 17:33:48',25.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'ac2dad1af92357834627b7793593386c',NULL,NULL,NULL,NULL,NULL,'2024-11-15 15:03:57','2024-11-15 15:03:57'),(53,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0013','',NULL,NULL,NULL,'2024-11-17 06:15:38',362.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,362.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-11-17 06:15:38','2024-11-17 06:15:38'),(54,1,1,1,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0014','',NULL,NULL,NULL,'2024-11-17 06:16:51',937.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,937.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-11-17 06:16:51','2024-11-17 06:16:51'),(55,1,8,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0015','',NULL,NULL,NULL,'2024-11-17 06:19:29',25.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-11-17 06:19:29','2024-11-17 06:19:29'),(56,1,8,0,NULL,NULL,NULL,'sell',NULL,'draft','quotation',1,NULL,NULL,1,NULL,'2024/0001','',NULL,NULL,NULL,'2024-11-17 06:20:54',50.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,50.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-11-17 06:20:54','2024-11-17 06:20:54'),(57,1,8,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'due',NULL,16,NULL,'0016','',NULL,NULL,NULL,'2024-11-17 06:25:07',25.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-11-17 06:25:07','2024-11-17 06:25:07'),(58,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0017','',NULL,NULL,NULL,'2024-11-29 14:08:36',8450.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,8450.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-11-29 14:08:36','2024-11-29 14:08:36'),(59,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0018','',NULL,NULL,NULL,'2024-12-02 12:51:01',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-12-02 12:51:01','2024-12-02 12:51:01'),(60,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0019','',NULL,NULL,NULL,'2024-12-06 03:04:40',1175.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1175.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-12-06 03:04:40','2024-12-06 03:04:40'),(61,1,8,0,NULL,NULL,NULL,'expense',NULL,'final',NULL,0,'partial',NULL,NULL,NULL,NULL,'EP2024/0001',NULL,NULL,NULL,'2024-12-06 03:05:00',30.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,30.0000,NULL,NULL,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-06 03:06:06','2024-12-06 03:06:06'),(62,1,7,0,NULL,NULL,NULL,'sell',NULL,'draft','quotation',1,NULL,NULL,1,NULL,'1_2024126143','',NULL,NULL,NULL,'2024-12-06 01:42:09',212.5000,1,42.5000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,255.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,NULL,0,1.0000,NULL,0,NULL,NULL,'d7154266937414fc990a3c1a305a8d47',NULL,NULL,NULL,NULL,NULL,'2024-12-06 04:13:29','2024-12-06 04:13:29'),(63,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0020','',NULL,NULL,NULL,'2024-12-07 14:45:50',387.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,387.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-12-07 14:45:50','2024-12-07 14:45:50'),(64,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0021','',NULL,NULL,NULL,'2024-12-07 15:28:24',750.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,750.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-12-07 15:28:24','2024-12-07 15:28:24'),(65,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0022','',NULL,NULL,NULL,'2024-12-07 15:50:30',12.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,12.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2024-12-07 15:50:30','2024-12-07 15:50:30'),(66,1,7,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'due',NULL,18,NULL,NULL,'PO2024/0001',NULL,NULL,NULL,'2024-12-10 23:21:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-10 23:23:01','2024-12-10 23:41:04'),(67,1,7,0,NULL,NULL,NULL,'sell_transfer',NULL,'final',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2024/0002',NULL,NULL,NULL,'2024-12-10 23:43:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-10 23:44:01','2024-12-10 23:44:01'),(68,1,8,0,NULL,NULL,NULL,'purchase_transfer',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,'ST2024/0002',NULL,NULL,NULL,'2024-12-10 23:43:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,67,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-10 23:44:01','2024-12-10 23:44:01'),(69,1,7,0,NULL,NULL,NULL,'purchase',NULL,'received',NULL,0,'paid',NULL,18,NULL,NULL,'PO2024/0002',NULL,NULL,NULL,'2024-12-12 00:05:00',0.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,0.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-12 00:12:48','2024-12-12 00:12:48'),(70,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0023','',NULL,NULL,NULL,'2025-01-07 14:15:24',69750.0000,NULL,0.0000,'percentage',10.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,62775.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-01-07 14:15:24','2025-01-07 14:15:24'),(71,1,8,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0024','',NULL,NULL,NULL,'2025-01-07 14:16:27',25.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-01-07 14:16:27','2025-01-07 14:16:27'),(72,1,8,0,NULL,NULL,NULL,'sell',NULL,'draft','quotation',1,NULL,NULL,1,NULL,'2025/0002','',NULL,NULL,NULL,'2025-01-07 14:17:29',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-01-07 14:17:29','2025-01-07 14:17:29'),(73,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0025','',NULL,NULL,NULL,'2025-01-07 18:01:20',25.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-01-07 18:01:20','2025-01-07 18:01:20'),(74,1,7,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 13:14:36',300.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,25,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-27 13:14:36','2025-01-27 13:14:36'),(75,1,8,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-01 13:14:36',300.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,25,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-27 13:14:36','2025-01-27 13:14:36'),(76,1,7,0,NULL,NULL,NULL,'sell',NULL,'draft','proforma',1,NULL,NULL,21,NULL,'2025/0003','',NULL,NULL,NULL,'2025-01-27 13:10:00',300.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,'Thato Mmusi','Plot 26738\r\nNkoyaphiri \r\nGaborone',NULL,'shipped','Thato',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,300.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,'7eca1cb06a8e749afd517b92bdb9696d',1,'months',NULL,NULL,NULL,'2025-01-27 13:16:20','2025-01-27 13:17:36'),(77,1,7,0,NULL,NULL,NULL,'sell',NULL,'draft','quotation',1,NULL,NULL,22,NULL,'2025/0004','',NULL,NULL,NULL,'2025-01-27 13:23:00',350.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,350.0000,NULL,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-27 13:25:51','2025-01-27 13:25:51'),(78,1,7,1,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0026','',NULL,NULL,NULL,'2025-02-10 19:54:57',450.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,450.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-02-10 19:54:57','2025-02-10 19:54:58'),(79,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0027','',NULL,NULL,NULL,'2025-02-21 12:23:43',450.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,450.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-02-21 12:23:43','2025-02-21 12:23:43'),(80,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0028','',NULL,NULL,NULL,'2025-02-21 12:26:31',350.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,350.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-02-21 12:26:31','2025-02-21 12:26:31'),(81,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0029','',NULL,NULL,NULL,'2025-02-21 12:45:02',250.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,250.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-02-21 12:45:02','2025-02-21 12:45:02'),(82,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0030','',NULL,NULL,NULL,'2025-02-22 16:07:35',25.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-02-22 16:07:35','2025-02-22 16:07:35'),(83,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0031','',NULL,NULL,NULL,'2025-02-22 16:11:20',25.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,25.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-02-22 16:11:20','2025-02-22 16:11:20'),(84,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0032','',NULL,NULL,NULL,'2025-02-24 04:53:25',100.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,100.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-02-24 04:53:25','2025-02-24 04:53:25'),(85,1,7,1,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0033','',NULL,NULL,NULL,'2025-02-24 10:30:38',125.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,125.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-02-24 10:30:38','2025-02-24 10:30:38'),(86,1,7,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0034','',NULL,NULL,NULL,'2025-02-24 11:49:31',1000.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,1000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,0.0000,'percentage',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'2025-02-24 11:49:31','2025-02-24 11:49:31');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `types_of_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `types_of_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `location_price_group` text DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') DEFAULT NULL,
  `enable_custom_fields` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `types_of_services_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `types_of_services` WRITE;
/*!40000 ALTER TABLE `types_of_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `types_of_services` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `actual_name` varchar(191) NOT NULL,
  `short_name` varchar(191) NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `base_unit_id` int(11) DEFAULT NULL,
  `base_unit_multiplier` decimal(20,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  KEY `units_base_unit_id_index` (`base_unit_id`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'Pieces','Pc(s)',0,NULL,NULL,1,NULL,'2024-08-23 19:47:28','2024-08-23 19:47:28'),(2,1,'Feet','Ft',0,NULL,NULL,1,NULL,'2024-08-23 23:46:57','2024-08-24 19:49:20'),(3,1,'Grams','g',0,NULL,NULL,1,NULL,'2024-08-24 19:25:54','2024-08-24 19:49:46'),(4,1,'packet','packets',1,NULL,NULL,1,NULL,'2024-08-29 16:52:39','2024-08-29 16:52:39'),(5,2,'Pieces','Pc(s)',0,NULL,NULL,2,NULL,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(6,3,'Pieces','Pc(s)',0,NULL,NULL,3,NULL,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(7,4,'Pieces','Pc(s)',0,NULL,NULL,5,NULL,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(8,5,'Pieces','Pc(s)',0,NULL,NULL,6,NULL,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(9,6,'Pieces','Pc(s)',0,NULL,NULL,7,NULL,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(10,7,'Pieces','Pc(s)',0,NULL,NULL,8,NULL,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(11,1,'Dozen','Dozen',0,1,12.0000,1,NULL,'2024-12-06 13:35:38','2024-12-06 13:35:38'),(12,8,'Pieces','Pc(s)',0,NULL,NULL,10,NULL,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(13,9,'Pieces','Pc(s)',0,NULL,NULL,11,NULL,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(14,10,'Pieces','Pc(s)',0,NULL,NULL,12,NULL,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(15,11,'Pieces','Pc(s)',0,NULL,NULL,13,NULL,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(16,12,'Pieces','Pc(s)',0,NULL,NULL,14,NULL,'2025-02-22 17:18:54','2025-02-22 17:18:54');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_contact_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_contact_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_contact_access_user_id_index` (`user_id`),
  KEY `user_contact_access_contact_id_index` (`contact_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_contact_access` WRITE;
/*!40000 ALTER TABLE `user_contact_access` DISABLE KEYS */;
INSERT INTO `user_contact_access` VALUES (2,4,16);
/*!40000 ALTER TABLE `user_contact_access` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) NOT NULL DEFAULT 'user',
  `surname` char(10) DEFAULT NULL,
  `first_name` varchar(191) NOT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `username` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `password` varchar(191) DEFAULT NULL,
  `language` char(7) NOT NULL DEFAULT 'en',
  `contact_no` char(15) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `essentials_department_id` int(11) DEFAULT NULL,
  `essentials_designation_id` int(11) DEFAULT NULL,
  `essentials_salary` decimal(22,4) DEFAULT NULL,
  `essentials_pay_period` varchar(191) DEFAULT NULL,
  `essentials_pay_cycle` varchar(191) DEFAULT NULL,
  `available_at` datetime DEFAULT NULL COMMENT 'Service staff avilable at. Calculated from product preparation_time_in_minutes',
  `paused_at` datetime DEFAULT NULL COMMENT 'Service staff available time paused at, Will be nulled on resume.',
  `max_sales_discount_percent` decimal(5,2) DEFAULT NULL,
  `allow_login` tinyint(1) NOT NULL DEFAULT 1,
  `status` enum('active','inactive','terminated') NOT NULL DEFAULT 'active',
  `is_enable_service_staff_pin` tinyint(1) NOT NULL DEFAULT 0,
  `service_staff_pin` text DEFAULT NULL,
  `crm_contact_id` int(10) unsigned DEFAULT NULL,
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT 0,
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT 0.00,
  `selected_contacts` tinyint(1) NOT NULL DEFAULT 0,
  `dob` date DEFAULT NULL,
  `gender` varchar(191) DEFAULT NULL,
  `marital_status` enum('married','unmarried','divorced') DEFAULT NULL,
  `blood_group` char(10) DEFAULT NULL,
  `contact_number` char(20) DEFAULT NULL,
  `alt_number` varchar(191) DEFAULT NULL,
  `family_number` varchar(191) DEFAULT NULL,
  `fb_link` varchar(191) DEFAULT NULL,
  `twitter_link` varchar(191) DEFAULT NULL,
  `social_media_1` varchar(191) DEFAULT NULL,
  `social_media_2` varchar(191) DEFAULT NULL,
  `permanent_address` text DEFAULT NULL,
  `current_address` text DEFAULT NULL,
  `guardian_name` varchar(191) DEFAULT NULL,
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `bank_details` longtext DEFAULT NULL,
  `id_proof_name` varchar(191) DEFAULT NULL,
  `id_proof_number` varchar(191) DEFAULT NULL,
  `crm_department` varchar(191) DEFAULT NULL COMMENT 'Contact person''s department',
  `crm_designation` varchar(191) DEFAULT NULL COMMENT 'Contact person''s designation',
  `location_id` int(11) DEFAULT NULL COMMENT 'user primary work location',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  KEY `users_user_type_index` (`user_type`),
  KEY `users_essentials_department_id_index` (`essentials_department_id`),
  KEY `users_essentials_designation_id_index` (`essentials_designation_id`),
  KEY `users_crm_contact_id_index` (`crm_contact_id`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `users_crm_contact_id_foreign` FOREIGN KEY (`crm_contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'user','Mr','Ahmet',NULL,'hipson','MAJD@GMAIL.COM','$2y$10$UvJWMJJd25jVjaWE1ghdTeeKxllQbDJP0P1hIbraYAq8EdvsNmeSu','en',NULL,NULL,'KuSfGg3JCONUhtVdGubr6Y2PIkiEo3Mmuae7OTxozvB8tpQ0kwWgbHCbBg0n',1,NULL,NULL,NULL,'month',NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-08-23 19:47:28','2025-02-22 16:30:06'),(2,'user','SAJ','P',NULL,'username','info@gmail.com','$2y$10$eB2/xgARwFJhWK21/B9mlesvJOAPJBwFWt/bvQvHewhnTo7Wr5ka2','en',NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-02 17:19:13','2024-09-02 17:19:13'),(3,'user','Mrhaj','sjis',NULL,'admin','s@gmail.com','$2y$10$ZVBPDFrQYlG0fohYMSNL.eRvsx4mt7an0T/z8PLoYOPrBeIHyT34W','en',NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-03 22:51:53','2024-09-03 22:51:53'),(4,'user','Wajih','wajih','boukadida','Technico','wajih877@gmail.com','$2y$10$iOpv2e6CrHizEcp4Tgocwugfht1tn3DbMfXeKQspaFq2ErWYd9WHm','en',NULL,NULL,NULL,1,NULL,NULL,NULL,'month',NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,1.00,0,NULL,'male','married',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-04 23:59:13','2024-09-04 23:59:45'),(5,'user','sam','Samson','Nyerere','samm','replypointsolutions@gmail.com','$2y$10$mzkEKtxvlnI/9tN34LmdLedvWSnOUcwqxt2El2TE0gNiR1omdrXXC','en',NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 13:01:21','2024-09-14 13:01:21'),(6,'user','Mr','Abdul','Rehman','Abdul','ar4762779@gmail.com','$2y$10$WSoy9Rqn94c/zoOe1G11KeMjU.jRECIELdKzptvffO5aSK4UCAklW','en',NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-09-14 15:57:41','2024-09-14 15:57:41'),(7,'user',NULL,'kelvin',NULL,'hooh','m0165557155@gmail.com','$2y$10$zbKtzARMNCu7ng/OUZGTQeEVHYmxUIpR85a1FknJUIrdKfFV4gcQ.','en',NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-15 14:38:29','2024-11-15 14:38:29'),(8,'user','Mr','Elieza','Kalaita','ezaeli','eliezakalaita@gmail.com','$2y$10$qkGGLkmLWUaTPDL4bU4hPuw6RTZ9G7nqCvTbgZfN2LoWcg9RvnOpK','en',NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-02 16:39:47','2024-12-02 16:39:47'),(9,'user','mr','Yasir','khan','test 1','test@gamil.com','$2y$10$7GWxnsQrUtZ8SF43V6h8m.4IeLY3hT/a29fV3HitMRXfy1ipi5Jo2','en',NULL,NULL,NULL,1,NULL,NULL,NULL,'month',NULL,NULL,NULL,NULL,1,'active',1,'12345',NULL,0,0.00,0,NULL,'male','married','dfd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-07 15:39:31','2024-12-07 15:39:31'),(10,'user',NULL,'Abu',NULL,'admin5705','feltobidru@tozya.com','$2y$10$4ALXtAB7c8zXnU4R.paFKu4M8QbqgibJud1YAKBg9IhGp7ZHnXoC2','en',NULL,NULL,NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-12 22:13:26','2024-12-12 22:13:26'),(11,'user',NULL,'seasons',NULL,'webuser','liknoherzo@tozya.com','$2y$10$e2NMP3svXxkUxaDlRDSNNO1Q6hSB3bDNDERKtaRBfqDADQJdlThSO','en',NULL,NULL,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-12 22:15:12','2024-12-12 22:15:12'),(12,'user','dfda','sdffd','fdsf','sfds','dadas@fsdf.ca','$2y$10$DE6V0egbFqfk9pPYQEIZGezocJYeMoBzMWa.BC/RTjjWGttN5bz8e','en',NULL,NULL,NULL,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-15 11:39:44','2025-02-15 11:39:44'),(13,'user',NULL,'asdas','asd','fazssss','fazssss@gmail.com','$2y$10$eI8sGNXwO6rL8HCi1prMPuDb84rK.jekJnb6aHbvdRj8QneudZDe.','en',NULL,NULL,NULL,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-15 11:41:01','2025-02-15 11:41:01'),(14,'user','Mr','M.Saqlain','ERP','testuser@gmail.com','Testuser@gmail.com','$2y$10$/02LFfXBYMxGeGhWURS5guUldn6QMtFRdrQLX13rRFeMEsIL/BY3i','en',NULL,NULL,NULL,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-22 17:18:54','2025-02-22 17:18:54');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_group_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_group_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_id` int(10) unsigned NOT NULL,
  `price_group_id` int(10) unsigned NOT NULL,
  `price_inc_tax` decimal(22,4) NOT NULL,
  `price_type` varchar(191) NOT NULL DEFAULT 'fixed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_group_prices_variation_id_foreign` (`variation_id`),
  KEY `variation_group_prices_price_group_id_foreign` (`price_group_id`),
  CONSTRAINT `variation_group_prices_price_group_id_foreign` FOREIGN KEY (`price_group_id`) REFERENCES `selling_price_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variation_group_prices_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_group_prices` WRITE;
/*!40000 ALTER TABLE `variation_group_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_group_prices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_location_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_location_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `product_variation_id` int(10) unsigned NOT NULL COMMENT 'id from product_variations table',
  `variation_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `qty_available` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_location_details_location_id_foreign` (`location_id`),
  KEY `variation_location_details_product_id_index` (`product_id`),
  KEY `variation_location_details_product_variation_id_index` (`product_variation_id`),
  KEY `variation_location_details_variation_id_index` (`variation_id`),
  CONSTRAINT `variation_location_details_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `variation_location_details_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_location_details` WRITE;
/*!40000 ALTER TABLE `variation_location_details` DISABLE KEYS */;
INSERT INTO `variation_location_details` VALUES (1,2,2,2,1,81.0000,'2024-08-24 17:08:12','2024-09-24 18:11:00'),(2,1,1,1,1,73.0000,'2024-08-24 17:08:30','2024-12-06 03:04:40'),(3,1,1,1,2,10.0000,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(4,2,2,2,2,10.0000,'2024-08-24 17:23:30','2024-08-24 17:23:30'),(5,4,4,4,1,217.0000,'2024-08-24 19:24:17','2024-12-07 15:50:30'),(6,5,5,5,1,35.0000,'2024-08-24 19:27:41','2024-12-07 15:28:24'),(7,6,6,6,1,145.0000,'2024-08-24 20:02:12','2024-12-07 14:45:50'),(8,6,6,6,2,150.0000,'2024-08-24 20:02:12','2024-08-24 20:02:12'),(9,7,7,7,1,242.0000,'2024-08-24 20:04:00','2024-11-17 06:16:51'),(10,9,9,9,1,7.0000,'2024-08-24 20:05:51','2025-01-07 14:15:24'),(11,10,10,10,1,147.0000,'2024-08-24 20:09:20','2024-12-06 03:04:40'),(12,12,12,12,1,2221.0000,'2024-08-24 20:11:02','2025-01-07 14:15:24'),(13,14,14,14,1,199.0000,'2024-08-29 16:47:06','2024-09-14 12:57:26'),(14,15,15,15,1,447.0000,'2024-08-29 16:49:29','2024-12-06 03:04:40'),(15,16,16,16,1,41.0000,'2024-08-29 16:54:57','2024-12-06 03:04:40'),(16,17,17,17,1,498.0000,'2024-08-29 16:58:25','2024-09-14 12:57:26'),(17,19,19,19,7,49986.0000,'2024-09-26 17:47:09','2025-02-10 19:54:57'),(18,17,17,17,7,1.0000,'2024-11-15 15:03:02','2025-02-24 11:49:31'),(19,17,17,17,8,96.0000,'2024-11-15 15:03:02','2025-01-07 14:16:27'),(20,20,20,20,7,160.0000,'2024-12-10 23:23:01','2024-12-12 00:12:48'),(21,20,20,20,8,11.0000,'2024-12-10 23:44:01','2024-12-10 23:44:01'),(22,25,25,25,7,1.0000,'2025-01-27 13:14:36','2025-01-27 13:14:36'),(23,25,25,25,8,1.0000,'2025-01-27 13:14:36','2025-01-27 13:14:36');
/*!40000 ALTER TABLE `variation_location_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `woocommerce_attr_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_templates_business_id_foreign` (`business_id`),
  KEY `variation_templates_woocommerce_attr_id_index` (`woocommerce_attr_id`),
  CONSTRAINT `variation_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_templates` WRITE;
/*!40000 ALTER TABLE `variation_templates` DISABLE KEYS */;
INSERT INTO `variation_templates` VALUES (1,'Size (Tshirts)',1,1,'2024-08-24 19:51:19','2025-02-07 16:44:22'),(2,'Size (Shoes)',1,2,'2024-08-24 19:51:52','2025-02-07 16:44:22'),(3,'Waist Size (Jeans)',1,3,'2024-08-24 19:52:25','2025-02-07 16:44:22'),(4,'Color',1,4,'2024-08-24 19:53:39','2025-02-07 16:44:22');
/*!40000 ALTER TABLE `variation_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_value_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_value_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `variation_template_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_value_templates_name_index` (`name`),
  KEY `variation_value_templates_variation_template_id_index` (`variation_template_id`),
  CONSTRAINT `variation_value_templates_variation_template_id_foreign` FOREIGN KEY (`variation_template_id`) REFERENCES `variation_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_value_templates` WRITE;
/*!40000 ALTER TABLE `variation_value_templates` DISABLE KEYS */;
INSERT INTO `variation_value_templates` VALUES (1,'S',1,'2024-08-24 19:51:19','2024-08-24 19:51:19'),(2,'M',1,'2024-08-24 19:51:19','2024-08-24 19:51:19'),(3,'L',1,'2024-08-24 19:51:19','2024-08-24 19:51:19'),(4,'XL',1,'2024-08-24 19:51:19','2024-08-24 19:51:19'),(5,'5',2,'2024-08-24 19:51:52','2024-08-24 19:51:52'),(6,'6',2,'2024-08-24 19:51:52','2024-08-24 19:51:52'),(7,'7',2,'2024-08-24 19:51:52','2024-08-24 19:51:52'),(8,'8',2,'2024-08-24 19:51:52','2024-08-24 19:51:52'),(9,'9',2,'2024-08-24 19:51:52','2024-08-24 19:51:52'),(10,'28',3,'2024-08-24 19:52:25','2024-08-24 19:52:25'),(11,'30',3,'2024-08-24 19:52:25','2024-08-24 19:52:25'),(12,'32',3,'2024-08-24 19:52:25','2024-08-24 19:52:25'),(13,'34',3,'2024-08-24 19:52:25','2024-08-24 19:52:25'),(14,'Black',4,'2024-08-24 19:53:39','2024-08-24 19:53:39'),(15,'Blue',4,'2024-08-24 19:53:39','2024-08-24 19:53:39'),(16,'Brown',4,'2024-08-24 19:53:39','2024-08-24 19:53:39'),(17,'Grey',4,'2024-08-24 19:53:39','2024-08-24 19:53:39'),(18,'Gold',4,'2024-08-24 19:53:39','2024-08-24 19:53:39'),(19,'White',4,'2024-08-24 19:53:39','2024-08-24 19:53:39');
/*!40000 ALTER TABLE `variation_value_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `sub_sku` varchar(191) DEFAULT NULL,
  `product_variation_id` int(10) unsigned NOT NULL,
  `woocommerce_variation_id` int(11) DEFAULT NULL,
  `variation_value_id` int(11) DEFAULT NULL,
  `default_purchase_price` decimal(22,4) DEFAULT NULL,
  `dpp_inc_tax` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `profit_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `default_sell_price` decimal(22,4) DEFAULT NULL,
  `sell_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `combo_variations` text DEFAULT NULL COMMENT 'Contains the combo variation details',
  PRIMARY KEY (`id`),
  KEY `variations_product_id_foreign` (`product_id`),
  KEY `variations_product_variation_id_foreign` (`product_variation_id`),
  KEY `variations_name_index` (`name`),
  KEY `variations_sub_sku_index` (`sub_sku`),
  KEY `variations_variation_value_id_index` (`variation_value_id`),
  KEY `variations_woocommerce_variation_id_index` (`woocommerce_variation_id`),
  CONSTRAINT `variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variations_product_variation_id_foreign` FOREIGN KEY (`product_variation_id`) REFERENCES `product_variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variations` WRITE;
/*!40000 ALTER TABLE `variations` DISABLE KEYS */;
INSERT INTO `variations` VALUES (1,'DUMMY',1,'0001',1,NULL,NULL,100.0000,100.0000,25.0000,125.0000,125.0000,'2024-08-24 17:07:22','2025-02-07 16:31:34',NULL,'[]'),(2,'DUMMY',2,'0002',2,NULL,NULL,50.0000,50.0000,50.0000,75.0000,75.0000,'2024-08-24 17:08:04','2025-02-07 16:31:34',NULL,'[]'),(3,'DUMMY',3,'0003',3,NULL,NULL,0.0000,0.0000,25.0000,0.0000,0.0000,'2024-08-24 18:58:17','2025-02-07 16:31:34',NULL,'[]'),(4,'DUMMY',4,'0004',4,NULL,NULL,10.0000,10.0000,25.0000,12.5000,12.5000,'2024-08-24 19:23:58','2025-02-07 16:31:34',NULL,'[]'),(5,'DUMMY',5,'Apple - Fuji',5,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-08-24 19:26:33','2025-02-07 16:31:34',NULL,'[]'),(6,'DUMMY',6,'0006',6,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-08-24 20:01:48','2025-02-07 16:31:34',NULL,'[]'),(7,'DUMMY',7,'0007',7,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-08-24 20:03:54','2025-02-07 16:31:34',NULL,'[]'),(9,'DUMMY',9,'0009',9,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-08-24 20:05:45','2025-02-07 16:31:34',NULL,'[]'),(10,'DUMMY',10,'0010',10,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-08-24 20:09:10','2025-02-07 16:31:34',NULL,'[]'),(11,'DUMMY',11,'0011',11,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-08-24 20:10:28','2025-02-07 16:31:34',NULL,'[]'),(12,'DUMMY',12,'0012',12,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-08-24 20:10:54','2025-02-07 16:31:34',NULL,'[]'),(13,'DUMMY',13,'0013',13,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-08-29 16:46:12','2025-02-07 16:31:34',NULL,'[]'),(14,'DUMMY',14,'0014',14,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-08-29 16:46:47','2025-02-07 16:31:34',NULL,'[]'),(15,'DUMMY',15,'0015',15,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-08-29 16:49:19','2025-02-07 16:31:34',NULL,'[]'),(16,'DUMMY',16,'0016',16,NULL,NULL,100.0000,100.0000,-50.0000,50.0000,50.0000,'2024-08-29 16:54:23','2025-02-07 16:31:34',NULL,'[]'),(17,'DUMMY',17,'AS0026',17,NULL,NULL,20.0000,20.0000,25.0000,25.0000,25.0000,'2024-08-29 16:57:55','2025-02-07 16:31:34',NULL,'[]'),(18,'DUMMY',18,'0018',18,NULL,NULL,100.0000,100.0000,25.0000,125.0000,125.0000,'2024-09-24 09:20:16','2025-02-07 16:31:34',NULL,'[]'),(19,'DUMMY',19,'0019',19,NULL,NULL,150.0000,150.0000,25.0000,187.5000,187.5000,'2024-09-26 17:45:58','2025-02-07 16:31:34',NULL,'[]'),(20,'DUMMY',20,'0020',20,NULL,NULL,0.0000,0.0000,25.0000,0.0000,0.0000,'2024-12-10 23:20:06','2025-02-07 16:31:34',NULL,'[]'),(21,'DUMMY',21,'0021',21,NULL,NULL,0.0000,0.0000,25.0000,0.0000,0.0000,'2024-12-10 23:58:31','2025-02-07 16:31:34',NULL,'[]'),(22,'DUMMY',22,'0022',22,NULL,NULL,0.0000,0.0000,25.0000,0.0000,0.0000,'2024-12-12 00:57:26','2025-02-07 16:31:34',NULL,'[]'),(23,'DUMMY',23,'SKU00001',23,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,'2025-01-27 12:52:55','2025-02-07 16:31:34',NULL,'[]'),(24,'DUMMY',24,'0024',24,NULL,NULL,0.0000,0.0000,0.0000,300.0000,300.0000,'2025-01-27 13:01:15','2025-02-07 16:31:34',NULL,'[]'),(25,'DUMMY',25,'000186',25,NULL,NULL,0.0000,0.0000,25.0000,0.0000,0.0000,'2025-01-27 13:14:36','2025-02-07 16:31:34',NULL,'[]'),(26,'DUMMY',26,'00158',26,NULL,NULL,0.0000,0.0000,25.0000,0.0000,0.0000,'2025-01-27 13:25:34','2025-02-07 16:31:34',NULL,'[]'),(27,'DUMMY',27,'00021',27,NULL,NULL,300.0000,300.0000,25.0000,375.0000,375.0000,'2025-01-27 13:38:02','2025-02-07 16:31:34',NULL,'[]');
/*!40000 ALTER TABLE `variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warranties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `duration` int(11) NOT NULL,
  `duration_type` enum('days','months','years') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warranties_business_id_index` (`business_id`),
  KEY `warranties_duration_type_index` (`duration_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warranties` WRITE;
/*!40000 ALTER TABLE `warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `woocommerce_sync_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `woocommerce_sync_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `sync_type` varchar(191) NOT NULL,
  `operation_type` varchar(191) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `details` longtext DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `woocommerce_sync_logs` WRITE;
/*!40000 ALTER TABLE `woocommerce_sync_logs` DISABLE KEYS */;
INSERT INTO `woocommerce_sync_logs` VALUES (1,1,'categories','reset',NULL,NULL,1,'2025-02-07 16:31:27','2025-02-07 16:31:27'),(2,1,'all_products','reset',NULL,NULL,1,'2025-02-07 16:31:34','2025-02-07 16:31:34'),(3,1,'orders',NULL,NULL,NULL,1,'2025-02-07 16:31:50','2025-02-07 16:31:50'),(4,1,'categories','created','[\"Lubricant\",\"Accessories\",\"Book\",\"Computer & Accessories\",\"Electronics\",\"Food & Grocery\",\"Men\'s\",\"Women\'s\",\"Athletic Clothing\",\"Autobiography\",\"Belts\",\"Children\'s books\",\"195\"]',NULL,1,'2025-02-07 16:43:46','2025-02-07 16:43:46'),(5,1,'categories',NULL,NULL,NULL,1,'2025-02-07 16:44:22','2025-02-07 16:44:22'),(6,1,'all_products','created','[\"0019\",\"AS0026\",\"0020\",\"0021\",\"0022\"]',NULL,1,'2025-02-07 16:44:23','2025-02-07 16:44:23'),(7,1,'all_products',NULL,NULL,NULL,1,'2025-02-07 16:44:24','2025-02-07 16:44:24');
/*!40000 ALTER TABLE `woocommerce_sync_logs` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

